/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import ru.tinkoff.piapi.contract.v1.Account;
import ru.tinkoff.piapi.contract.v1.GetAccountsRequest;
import ru.tinkoff.piapi.contract.v1.GetAccountsResponse;
import ru.tinkoff.piapi.contract.v1.GetInfoRequest;
import ru.tinkoff.piapi.contract.v1.GetInfoResponse;
import ru.tinkoff.piapi.contract.v1.GetMarginAttributesRequest;
import ru.tinkoff.piapi.contract.v1.GetMarginAttributesResponse;
import ru.tinkoff.piapi.contract.v1.GetUserTariffRequest;
import ru.tinkoff.piapi.contract.v1.GetUserTariffResponse;
import ru.tinkoff.piapi.contract.v1.UsersServiceGrpc;
import ru.tinkoff.piapi.core.utils.Helpers;

public class UsersService {
    private final UsersServiceGrpc.UsersServiceBlockingStub userBlockingStub;
    private final UsersServiceGrpc.UsersServiceStub userStub;

    UsersService(@Nonnull UsersServiceGrpc.UsersServiceBlockingStub userBlockingStub, @Nonnull UsersServiceGrpc.UsersServiceStub userStub) {
        this.userBlockingStub = userBlockingStub;
        this.userStub = userStub;
    }

    @Nonnull
    public List<Account> getAccountsSync() {
        return this.userBlockingStub.getAccounts(GetAccountsRequest.newBuilder().build()).getAccountsList();
    }

    @Nonnull
    public GetMarginAttributesResponse getMarginAttributesSync(@Nonnull String accountId) {
        return this.userBlockingStub.getMarginAttributes(GetMarginAttributesRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public GetUserTariffResponse getUserTariffSync() {
        return this.userBlockingStub.getUserTariff(GetUserTariffRequest.newBuilder().build());
    }

    @Nonnull
    public GetInfoResponse getInfoSync() {
        return this.userBlockingStub.getInfo(GetInfoRequest.newBuilder().build());
    }

    @Nonnull
    public CompletableFuture<List<Account>> getAccounts() {
        return Helpers.wrapWithFuture(observer -> this.userStub.getAccounts(GetAccountsRequest.newBuilder().build(), observer)).thenApply(GetAccountsResponse::getAccountsList);
    }

    @Nonnull
    public CompletableFuture<GetMarginAttributesResponse> getMarginAttributes(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.userStub.getMarginAttributes(GetMarginAttributesRequest.newBuilder().setAccountId(accountId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<GetUserTariffResponse> getUserTariff() {
        return Helpers.wrapWithFuture(observer -> this.userStub.getUserTariff(GetUserTariffRequest.newBuilder().build(), observer));
    }

    @Nonnull
    public CompletableFuture<GetInfoResponse> getInfo() {
        return Helpers.wrapWithFuture(observer -> this.userStub.getInfo(GetInfoRequest.newBuilder().build(), observer));
    }
}

