/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import ru.tinkoff.piapi.contract.v1.CancelStopOrderRequest;
import ru.tinkoff.piapi.contract.v1.GetStopOrdersRequest;
import ru.tinkoff.piapi.contract.v1.GetStopOrdersResponse;
import ru.tinkoff.piapi.contract.v1.PostStopOrderRequest;
import ru.tinkoff.piapi.contract.v1.PostStopOrderResponse;
import ru.tinkoff.piapi.contract.v1.Quotation;
import ru.tinkoff.piapi.contract.v1.StopOrder;
import ru.tinkoff.piapi.contract.v1.StopOrderDirection;
import ru.tinkoff.piapi.contract.v1.StopOrderExpirationType;
import ru.tinkoff.piapi.contract.v1.StopOrderType;
import ru.tinkoff.piapi.contract.v1.StopOrdersServiceGrpc;
import ru.tinkoff.piapi.core.ReadonlyModeViolationException;
import ru.tinkoff.piapi.core.utils.DateUtils;
import ru.tinkoff.piapi.core.utils.Helpers;

public class StopOrdersService {
    private final StopOrdersServiceGrpc.StopOrdersServiceBlockingStub stopOrdersBlockingStub;
    private final StopOrdersServiceGrpc.StopOrdersServiceStub stopOrdersStub;
    private final boolean readonlyMode;

    StopOrdersService(@Nonnull StopOrdersServiceGrpc.StopOrdersServiceBlockingStub stopOrdersBlockingStub, @Nonnull StopOrdersServiceGrpc.StopOrdersServiceStub stopOrdersStub, boolean readonlyMode) {
        this.stopOrdersBlockingStub = stopOrdersBlockingStub;
        this.stopOrdersStub = stopOrdersStub;
        this.readonlyMode = readonlyMode;
    }

    @Nonnull
    public String postStopOrderGoodTillCancelSync(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull Quotation stopPrice, @Nonnull StopOrderDirection direction, @Nonnull String accountId, @Nonnull StopOrderType type) {
        if (this.readonlyMode) {
            throw new ReadonlyModeViolationException();
        }
        return this.stopOrdersBlockingStub.postStopOrder(PostStopOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setStopPrice(stopPrice).setDirection(direction).setAccountId(accountId).setExpirationType(StopOrderExpirationType.STOP_ORDER_EXPIRATION_TYPE_GOOD_TILL_CANCEL).setStopOrderType(type).build()).getStopOrderId();
    }

    @Nonnull
    public String postStopOrderGoodTillDateSync(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull Quotation stopPrice, @Nonnull StopOrderDirection direction, @Nonnull String accountId, @Nonnull StopOrderType type, @Nonnull Instant expireDate) {
        if (this.readonlyMode) {
            throw new ReadonlyModeViolationException();
        }
        return this.stopOrdersBlockingStub.postStopOrder(PostStopOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setStopPrice(stopPrice).setDirection(direction).setAccountId(accountId).setExpirationType(StopOrderExpirationType.STOP_ORDER_EXPIRATION_TYPE_GOOD_TILL_DATE).setStopOrderType(type).setExpireDate(DateUtils.instantToTimestamp(expireDate)).build()).getStopOrderId();
    }

    @Nonnull
    public List<StopOrder> getStopOrdersSync(@Nonnull String accountId) {
        return this.stopOrdersBlockingStub.getStopOrders(GetStopOrdersRequest.newBuilder().setAccountId(accountId).build()).getStopOrdersList();
    }

    @Nonnull
    public Instant cancelStopOrderSync(@Nonnull String accountId, @Nonnull String stopOrderId) {
        if (this.readonlyMode) {
            throw new ReadonlyModeViolationException();
        }
        Timestamp responseTime = this.stopOrdersBlockingStub.cancelStopOrder(CancelStopOrderRequest.newBuilder().setAccountId(accountId).setStopOrderId(stopOrderId).build()).getTime();
        return DateUtils.timestampToInstant(responseTime);
    }

    @Nonnull
    public CompletableFuture<String> postStopOrderGoodTillCancel(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull Quotation stopPrice, @Nonnull StopOrderDirection direction, @Nonnull String accountId, @Nonnull StopOrderType type) {
        if (this.readonlyMode) {
            return CompletableFuture.failedFuture(new ReadonlyModeViolationException());
        }
        return Helpers.wrapWithFuture(observer -> this.stopOrdersStub.postStopOrder(PostStopOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setStopPrice(stopPrice).setDirection(direction).setAccountId(accountId).setExpirationType(StopOrderExpirationType.STOP_ORDER_EXPIRATION_TYPE_GOOD_TILL_CANCEL).setStopOrderType(type).build(), observer)).thenApply(PostStopOrderResponse::getStopOrderId);
    }

    @Nonnull
    public CompletableFuture<String> postStopOrderGoodTillDate(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull Quotation stopPrice, @Nonnull StopOrderDirection direction, @Nonnull String accountId, @Nonnull StopOrderType type, @Nonnull Instant expireDate) {
        if (this.readonlyMode) {
            return CompletableFuture.failedFuture(new ReadonlyModeViolationException());
        }
        return Helpers.wrapWithFuture(observer -> this.stopOrdersStub.postStopOrder(PostStopOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setStopPrice(stopPrice).setDirection(direction).setAccountId(accountId).setExpirationType(StopOrderExpirationType.STOP_ORDER_EXPIRATION_TYPE_GOOD_TILL_DATE).setStopOrderType(type).setExpireDate(DateUtils.instantToTimestamp(expireDate)).build(), observer)).thenApply(PostStopOrderResponse::getStopOrderId);
    }

    @Nonnull
    public CompletableFuture<List<StopOrder>> getStopOrders(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.stopOrdersStub.getStopOrders(GetStopOrdersRequest.newBuilder().setAccountId(accountId).build(), observer)).thenApply(GetStopOrdersResponse::getStopOrdersList);
    }

    @Nonnull
    public CompletableFuture<Instant> cancelStopOrder(@Nonnull String accountId, @Nonnull String stopOrderId) {
        if (this.readonlyMode) {
            return CompletableFuture.failedFuture(new ReadonlyModeViolationException());
        }
        return Helpers.wrapWithFuture(observer -> this.stopOrdersStub.cancelStopOrder(CancelStopOrderRequest.newBuilder().setAccountId(accountId).setStopOrderId(stopOrderId).build(), observer)).thenApply(response -> DateUtils.timestampToInstant(response.getTime()));
    }
}

