/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.tinkoff.piapi.contract.v1.Account;
import ru.tinkoff.piapi.contract.v1.CancelOrderRequest;
import ru.tinkoff.piapi.contract.v1.CloseSandboxAccountRequest;
import ru.tinkoff.piapi.contract.v1.GetAccountsRequest;
import ru.tinkoff.piapi.contract.v1.GetAccountsResponse;
import ru.tinkoff.piapi.contract.v1.GetOrderStateRequest;
import ru.tinkoff.piapi.contract.v1.GetOrdersRequest;
import ru.tinkoff.piapi.contract.v1.GetOrdersResponse;
import ru.tinkoff.piapi.contract.v1.MoneyValue;
import ru.tinkoff.piapi.contract.v1.OpenSandboxAccountRequest;
import ru.tinkoff.piapi.contract.v1.OpenSandboxAccountResponse;
import ru.tinkoff.piapi.contract.v1.Operation;
import ru.tinkoff.piapi.contract.v1.OperationState;
import ru.tinkoff.piapi.contract.v1.OperationsRequest;
import ru.tinkoff.piapi.contract.v1.OperationsResponse;
import ru.tinkoff.piapi.contract.v1.OrderDirection;
import ru.tinkoff.piapi.contract.v1.OrderState;
import ru.tinkoff.piapi.contract.v1.OrderType;
import ru.tinkoff.piapi.contract.v1.PortfolioRequest;
import ru.tinkoff.piapi.contract.v1.PortfolioResponse;
import ru.tinkoff.piapi.contract.v1.PositionsRequest;
import ru.tinkoff.piapi.contract.v1.PositionsResponse;
import ru.tinkoff.piapi.contract.v1.PostOrderRequest;
import ru.tinkoff.piapi.contract.v1.PostOrderResponse;
import ru.tinkoff.piapi.contract.v1.Quotation;
import ru.tinkoff.piapi.contract.v1.SandboxPayInRequest;
import ru.tinkoff.piapi.contract.v1.SandboxPayInResponse;
import ru.tinkoff.piapi.contract.v1.SandboxServiceGrpc;
import ru.tinkoff.piapi.core.utils.DateUtils;
import ru.tinkoff.piapi.core.utils.Helpers;

public class SandboxService {
    private final SandboxServiceGrpc.SandboxServiceBlockingStub sandboxBlockingStub;
    private final SandboxServiceGrpc.SandboxServiceStub sandboxStub;

    SandboxService(@Nonnull SandboxServiceGrpc.SandboxServiceBlockingStub sandboxBlockingStub, @Nonnull SandboxServiceGrpc.SandboxServiceStub sandboxStub) {
        this.sandboxBlockingStub = sandboxBlockingStub;
        this.sandboxStub = sandboxStub;
    }

    @Nonnull
    public String openAccountSync() {
        return this.sandboxBlockingStub.openSandboxAccount(OpenSandboxAccountRequest.newBuilder().build()).getAccountId();
    }

    @Nonnull
    public List<Account> getAccountsSync() {
        return this.sandboxBlockingStub.getSandboxAccounts(GetAccountsRequest.newBuilder().build()).getAccountsList();
    }

    public void closeAccountSync(@Nonnull String accountId) {
        this.sandboxBlockingStub.closeSandboxAccount(CloseSandboxAccountRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public PostOrderResponse postOrderSync(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull OrderDirection direction, @Nonnull String accountId, @Nonnull OrderType type, @Nonnull String orderId) {
        return this.sandboxBlockingStub.postSandboxOrder(PostOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setDirection(direction).setAccountId(accountId).setOrderType(type).setOrderId(Helpers.preprocessInputOrderId(orderId)).build());
    }

    @Nonnull
    public List<OrderState> getOrdersSync(@Nonnull String accountId) {
        return this.sandboxBlockingStub.getSandboxOrders(GetOrdersRequest.newBuilder().setAccountId(accountId).build()).getOrdersList();
    }

    @Nonnull
    public Instant cancelOrderSync(@Nonnull String accountId, @Nonnull String orderId) {
        Timestamp responseTime = this.sandboxBlockingStub.cancelSandboxOrder(CancelOrderRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build()).getTime();
        return DateUtils.timestampToInstant(responseTime);
    }

    @Nonnull
    public OrderState getOrderStateSync(@Nonnull String accountId, @Nonnull String orderId) {
        return this.sandboxBlockingStub.getSandboxOrderState(GetOrderStateRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build());
    }

    @Nonnull
    public PositionsResponse getPositionsSync(@Nonnull String accountId) {
        return this.sandboxBlockingStub.getSandboxPositions(PositionsRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public List<Operation> getOperationsSync(@Nonnull String accountId, @Nonnull Instant from, @Nonnull Instant to, @Nonnull OperationState operationState, @Nullable String figi) {
        return this.sandboxBlockingStub.getSandboxOperations(OperationsRequest.newBuilder().setAccountId(accountId).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).setState(operationState).setFigi(figi == null ? "" : figi).build()).getOperationsList();
    }

    @Nonnull
    public PortfolioResponse getPortfolioSync(@Nonnull String accountId) {
        return this.sandboxBlockingStub.getSandboxPortfolio(PortfolioRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public MoneyValue payInSync(@Nonnull String accountId, @Nonnull MoneyValue moneyValue) {
        return this.sandboxBlockingStub.sandboxPayIn(SandboxPayInRequest.newBuilder().setAccountId(accountId).setAmount(moneyValue).build()).getBalance();
    }

    @Nonnull
    public CompletableFuture<String> openAccount() {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.openSandboxAccount(OpenSandboxAccountRequest.newBuilder().build(), observer)).thenApply(OpenSandboxAccountResponse::getAccountId);
    }

    @Nonnull
    public CompletableFuture<List<Account>> getAccounts() {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.getSandboxAccounts(GetAccountsRequest.newBuilder().build(), observer)).thenApply(GetAccountsResponse::getAccountsList);
    }

    @Nonnull
    public CompletableFuture<Void> closeAccount(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.closeSandboxAccount(CloseSandboxAccountRequest.newBuilder().setAccountId(accountId).build(), observer)).thenApply(r -> null);
    }

    @Nonnull
    public CompletableFuture<PostOrderResponse> postOrder(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull OrderDirection direction, @Nonnull String accountId, @Nonnull OrderType type, @Nonnull String orderId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.postSandboxOrder(PostOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setDirection(direction).setAccountId(accountId).setOrderType(type).setOrderId(Helpers.preprocessInputOrderId(orderId)).build(), observer));
    }

    @Nonnull
    public CompletableFuture<List<OrderState>> getOrders(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.getSandboxOrders(GetOrdersRequest.newBuilder().setAccountId(accountId).build(), observer)).thenApply(GetOrdersResponse::getOrdersList);
    }

    @Nonnull
    public CompletableFuture<Instant> cancelOrder(@Nonnull String accountId, @Nonnull String orderId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.cancelSandboxOrder(CancelOrderRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build(), observer)).thenApply(response -> DateUtils.timestampToInstant(response.getTime()));
    }

    @Nonnull
    public CompletableFuture<OrderState> getOrderState(@Nonnull String accountId, @Nonnull String orderId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.getSandboxOrderState(GetOrderStateRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<PositionsResponse> getPositions(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.getSandboxPositions(PositionsRequest.newBuilder().setAccountId(accountId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<List<Operation>> getOperations(@Nonnull String accountId, @Nonnull Instant from, @Nonnull Instant to, @Nonnull OperationState operationState, @Nullable String figi) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.getSandboxOperations(OperationsRequest.newBuilder().setAccountId(accountId).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).setState(operationState).setFigi(figi == null ? "" : figi).build(), observer)).thenApply(OperationsResponse::getOperationsList);
    }

    @Nonnull
    public CompletableFuture<PortfolioResponse> getPortfolio(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.getSandboxPortfolio(PortfolioRequest.newBuilder().setAccountId(accountId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<MoneyValue> payIn(@Nonnull String accountId, @Nonnull MoneyValue moneyValue) {
        return Helpers.wrapWithFuture(observer -> this.sandboxStub.sandboxPayIn(SandboxPayInRequest.newBuilder().setAccountId(accountId).setAmount(moneyValue).build(), observer)).thenApply(SandboxPayInResponse::getBalance);
    }
}

