/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import com.google.protobuf.Timestamp;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import ru.tinkoff.piapi.contract.v1.CancelOrderRequest;
import ru.tinkoff.piapi.contract.v1.GetOrderStateRequest;
import ru.tinkoff.piapi.contract.v1.GetOrdersRequest;
import ru.tinkoff.piapi.contract.v1.GetOrdersResponse;
import ru.tinkoff.piapi.contract.v1.OrderDirection;
import ru.tinkoff.piapi.contract.v1.OrderState;
import ru.tinkoff.piapi.contract.v1.OrderType;
import ru.tinkoff.piapi.contract.v1.OrdersServiceGrpc;
import ru.tinkoff.piapi.contract.v1.OrdersStreamServiceGrpc;
import ru.tinkoff.piapi.contract.v1.PostOrderRequest;
import ru.tinkoff.piapi.contract.v1.PostOrderResponse;
import ru.tinkoff.piapi.contract.v1.Quotation;
import ru.tinkoff.piapi.contract.v1.TradesStreamRequest;
import ru.tinkoff.piapi.contract.v1.TradesStreamResponse;
import ru.tinkoff.piapi.core.ReadonlyModeViolationException;
import ru.tinkoff.piapi.core.utils.DateUtils;
import ru.tinkoff.piapi.core.utils.Helpers;

public class OrdersService {
    private final OrdersStreamServiceGrpc.OrdersStreamServiceStub ordersStreamStub;
    private final OrdersServiceGrpc.OrdersServiceBlockingStub ordersBlockingStub;
    private final OrdersServiceGrpc.OrdersServiceStub ordersStub;
    private final boolean readonlyMode;

    OrdersService(@Nonnull OrdersStreamServiceGrpc.OrdersStreamServiceStub ordersStreamStub, @Nonnull OrdersServiceGrpc.OrdersServiceBlockingStub ordersBlockingStub, @Nonnull OrdersServiceGrpc.OrdersServiceStub ordersStub, boolean readonlyMode) {
        this.ordersStreamStub = ordersStreamStub;
        this.ordersBlockingStub = ordersBlockingStub;
        this.ordersStub = ordersStub;
        this.readonlyMode = readonlyMode;
    }

    @Nonnull
    public Flow.Publisher<TradesStreamResponse> ordersStream() {
        Multi mutinyPublisher = Multi.createFrom().emitter(emitter -> this.ordersStreamStub.tradesStream(TradesStreamRequest.newBuilder().build(), Helpers.wrapEmitterWithStreamObserver(emitter)), BackPressureStrategy.BUFFER);
        return FlowAdapters.toFlowPublisher((Publisher)mutinyPublisher);
    }

    public void subscribeTradesStream(Consumer<TradesStreamResponse> consumer) {
        Multi.createFrom().safePublisher(FlowAdapters.toPublisher(this.ordersStream())).subscribe().asIterable().forEach(consumer);
    }

    @Nonnull
    public PostOrderResponse postOrderSync(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull OrderDirection direction, @Nonnull String accountId, @Nonnull OrderType type, @Nonnull String orderId) {
        if (this.readonlyMode) {
            throw new ReadonlyModeViolationException();
        }
        return this.ordersBlockingStub.postOrder(PostOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setDirection(direction).setAccountId(accountId).setOrderType(type).setOrderId(Helpers.preprocessInputOrderId(orderId)).build());
    }

    @Nonnull
    public Instant cancelOrderSync(@Nonnull String accountId, @Nonnull String orderId) {
        if (this.readonlyMode) {
            throw new ReadonlyModeViolationException();
        }
        Timestamp responseTime = this.ordersBlockingStub.cancelOrder(CancelOrderRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build()).getTime();
        return DateUtils.timestampToInstant(responseTime);
    }

    @Nonnull
    public OrderState getOrderStateSync(@Nonnull String accountId, @Nonnull String orderId) {
        return this.ordersBlockingStub.getOrderState(GetOrderStateRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build());
    }

    @Nonnull
    public List<OrderState> getOrdersSync(@Nonnull String accountId) {
        return this.ordersBlockingStub.getOrders(GetOrdersRequest.newBuilder().setAccountId(accountId).build()).getOrdersList();
    }

    @Nonnull
    public CompletableFuture<PostOrderResponse> postOrder(@Nonnull String figi, long quantity, @Nonnull Quotation price, @Nonnull OrderDirection direction, @Nonnull String accountId, @Nonnull OrderType type, @Nonnull String orderId) {
        if (this.readonlyMode) {
            return CompletableFuture.failedFuture(new ReadonlyModeViolationException());
        }
        return Helpers.wrapWithFuture(observer -> this.ordersStub.postOrder(PostOrderRequest.newBuilder().setFigi(figi).setQuantity(quantity).setPrice(price).setDirection(direction).setAccountId(accountId).setOrderType(type).setOrderId(Helpers.preprocessInputOrderId(orderId)).build(), observer));
    }

    @Nonnull
    public CompletableFuture<Instant> cancelOrder(@Nonnull String accountId, @Nonnull String orderId) {
        if (this.readonlyMode) {
            return CompletableFuture.failedFuture(new ReadonlyModeViolationException());
        }
        return Helpers.wrapWithFuture(observer -> this.ordersStub.cancelOrder(CancelOrderRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build(), observer)).thenApply(response -> DateUtils.timestampToInstant(response.getTime()));
    }

    @Nonnull
    public CompletableFuture<OrderState> getOrderState(@Nonnull String accountId, @Nonnull String orderId) {
        return Helpers.wrapWithFuture(observer -> this.ordersStub.getOrderState(GetOrderStateRequest.newBuilder().setAccountId(accountId).setOrderId(orderId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<List<OrderState>> getOrders(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.ordersStub.getOrders(GetOrdersRequest.newBuilder().setAccountId(accountId).build(), observer)).thenApply(GetOrdersResponse::getOrdersList);
    }
}

