/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.tinkoff.piapi.contract.v1.Operation;
import ru.tinkoff.piapi.contract.v1.OperationState;
import ru.tinkoff.piapi.contract.v1.OperationsRequest;
import ru.tinkoff.piapi.contract.v1.OperationsResponse;
import ru.tinkoff.piapi.contract.v1.OperationsServiceGrpc;
import ru.tinkoff.piapi.contract.v1.PortfolioRequest;
import ru.tinkoff.piapi.contract.v1.PortfolioResponse;
import ru.tinkoff.piapi.contract.v1.PositionsRequest;
import ru.tinkoff.piapi.contract.v1.PositionsResponse;
import ru.tinkoff.piapi.contract.v1.WithdrawLimitsRequest;
import ru.tinkoff.piapi.contract.v1.WithdrawLimitsResponse;
import ru.tinkoff.piapi.core.utils.DateUtils;
import ru.tinkoff.piapi.core.utils.Helpers;

public class OperationsService {
    private final OperationsServiceGrpc.OperationsServiceBlockingStub operationsBlockingStub;
    private final OperationsServiceGrpc.OperationsServiceStub operationsStub;

    OperationsService(@Nonnull OperationsServiceGrpc.OperationsServiceBlockingStub operationsBlockingStub, @Nonnull OperationsServiceGrpc.OperationsServiceStub operationsStub) {
        this.operationsBlockingStub = operationsBlockingStub;
        this.operationsStub = operationsStub;
    }

    @Nonnull
    public List<Operation> getOperationsSync(@Nonnull String accountId, @Nonnull Instant from, @Nonnull Instant to, @Nonnull OperationState operationState, @Nullable String figi) {
        return this.operationsBlockingStub.getOperations(OperationsRequest.newBuilder().setAccountId(accountId).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).setState(operationState).setFigi(figi == null ? "" : figi).build()).getOperationsList();
    }

    @Nonnull
    public PortfolioResponse getPortfolioSync(@Nonnull String accountId) {
        return this.operationsBlockingStub.getPortfolio(PortfolioRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public PositionsResponse getPositionsSync(@Nonnull String accountId) {
        return this.operationsBlockingStub.getPositions(PositionsRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public WithdrawLimitsResponse getWithdrawLimitsSync(@Nonnull String accountId) {
        return this.operationsBlockingStub.getWithdrawLimits(WithdrawLimitsRequest.newBuilder().setAccountId(accountId).build());
    }

    @Nonnull
    public CompletableFuture<List<Operation>> getOperations(@Nonnull String accountId, @Nonnull Instant from, @Nonnull Instant to, @Nonnull OperationState operationState, @Nullable String figi) {
        return Helpers.wrapWithFuture(observer -> this.operationsStub.getOperations(OperationsRequest.newBuilder().setAccountId(accountId).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).setState(operationState).setFigi(figi == null ? "" : figi).build(), observer)).thenApply(OperationsResponse::getOperationsList);
    }

    @Nonnull
    public CompletableFuture<PortfolioResponse> getPortfolio(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.operationsStub.getPortfolio(PortfolioRequest.newBuilder().setAccountId(accountId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<PositionsResponse> getPositions(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.operationsStub.getPositions(PositionsRequest.newBuilder().setAccountId(accountId).build(), observer));
    }

    @Nonnull
    public CompletableFuture<WithdrawLimitsResponse> getWithdrawLimits(@Nonnull String accountId) {
        return Helpers.wrapWithFuture(observer -> this.operationsStub.getWithdrawLimits(WithdrawLimitsRequest.newBuilder().setAccountId(accountId).build(), observer));
    }
}

