/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.stub.MetadataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.piapi.contract.v1.InstrumentsServiceGrpc;
import ru.tinkoff.piapi.contract.v1.MarketDataServiceGrpc;
import ru.tinkoff.piapi.contract.v1.MarketDataStreamServiceGrpc;
import ru.tinkoff.piapi.contract.v1.OperationsServiceGrpc;
import ru.tinkoff.piapi.contract.v1.OrdersServiceGrpc;
import ru.tinkoff.piapi.contract.v1.OrdersStreamServiceGrpc;
import ru.tinkoff.piapi.contract.v1.SandboxServiceGrpc;
import ru.tinkoff.piapi.contract.v1.StopOrdersServiceGrpc;
import ru.tinkoff.piapi.contract.v1.UsersServiceGrpc;
import ru.tinkoff.piapi.core.InstrumentsService;
import ru.tinkoff.piapi.core.MarketDataService;
import ru.tinkoff.piapi.core.OperationsService;
import ru.tinkoff.piapi.core.OrdersService;
import ru.tinkoff.piapi.core.SandboxService;
import ru.tinkoff.piapi.core.StopOrdersService;
import ru.tinkoff.piapi.core.UsersService;

public class InvestApi {
    private static final String configResourceName = "config.properties";
    private static final String targetPath = "target";
    private static final String connectionTimeoutPath = "connection-timeout";
    private static final String requestTimeoutPath = "request-timeout";
    private static final String target;
    private static final Duration connectionTimeout;
    private static final Duration requestTimeout;
    private final Channel channel;
    private final boolean sandboxMode;
    private final boolean readonlyMode;
    private final UsersService userService;
    private final OperationsService operationsService;
    private final InstrumentsService instrumentsService;
    private final StopOrdersService stopOrdersService;
    private final OrdersService ordersService;
    private final MarketDataService marketDataService;
    private final SandboxService sandboxService;

    private InvestApi(@Nonnull Channel channel, boolean sandboxMode, boolean readonlyMode) {
        assert (!sandboxMode || !readonlyMode) : "\u041d\u0435\u043b\u044c\u0437\u044f \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c\u044b \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u0430\" \u0438 \"\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f\" ";
        this.channel = channel;
        this.sandboxMode = sandboxMode;
        this.readonlyMode = readonlyMode;
        this.instrumentsService = new InstrumentsService(InstrumentsServiceGrpc.newBlockingStub((Channel)channel), InstrumentsServiceGrpc.newStub((Channel)channel));
        this.marketDataService = new MarketDataService(MarketDataStreamServiceGrpc.newStub((Channel)channel), MarketDataServiceGrpc.newBlockingStub((Channel)channel), MarketDataServiceGrpc.newStub((Channel)channel));
        if (sandboxMode) {
            this.sandboxService = new SandboxService(SandboxServiceGrpc.newBlockingStub((Channel)channel), SandboxServiceGrpc.newStub((Channel)channel));
            this.userService = null;
            this.operationsService = null;
            this.stopOrdersService = null;
            this.ordersService = null;
        } else {
            this.userService = new UsersService(UsersServiceGrpc.newBlockingStub((Channel)channel), UsersServiceGrpc.newStub((Channel)channel));
            this.operationsService = new OperationsService(OperationsServiceGrpc.newBlockingStub((Channel)channel), OperationsServiceGrpc.newStub((Channel)channel));
            this.stopOrdersService = new StopOrdersService(StopOrdersServiceGrpc.newBlockingStub((Channel)channel), StopOrdersServiceGrpc.newStub((Channel)channel), readonlyMode);
            this.ordersService = new OrdersService(OrdersStreamServiceGrpc.newStub((Channel)channel), OrdersServiceGrpc.newBlockingStub((Channel)channel), OrdersServiceGrpc.newStub((Channel)channel), readonlyMode);
            this.sandboxService = null;
        }
    }

    @Nonnull
    public static InvestApi create(@Nonnull Channel channel) {
        return new InvestApi(channel, false, false);
    }

    @Nonnull
    public static InvestApi create(@Nonnull String token) {
        return new InvestApi(InvestApi.defaultChannel(token), false, false);
    }

    @Nonnull
    public static InvestApi createReadonly(@Nonnull Channel channel) {
        return new InvestApi(channel, false, true);
    }

    @Nonnull
    public static InvestApi createReadonly(@Nonnull String token) {
        return new InvestApi(InvestApi.defaultChannel(token), false, true);
    }

    @Nonnull
    public static InvestApi createSandbox(@Nonnull Channel channel) {
        return new InvestApi(channel, true, false);
    }

    @Nonnull
    public static InvestApi createSandbox(@Nonnull String token) {
        return new InvestApi(InvestApi.defaultChannel(token), true, false);
    }

    @Nonnull
    public static Channel defaultChannel(String token) {
        Metadata headers = new Metadata();
        InvestApi.addAuthHeader(headers, token);
        return ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)target).intercept(new ClientInterceptor[]{new LoggingInterceptor(), MetadataUtils.newAttachHeadersInterceptor((Metadata)headers), new TimeoutInterceptor(requestTimeout)})).withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionTimeout.toMillis())).useTransportSecurity().build();
    }

    public static void addAuthHeader(@Nonnull Metadata metadata, @Nonnull String token) {
        Metadata.Key authKey = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        metadata.put(authKey, (Object)("Bearer " + token));
    }

    private static Properties loadProps() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties props = new Properties();
        try (InputStream resourceStream = loader.getResourceAsStream(configResourceName);){
            props.load(resourceStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    @Nonnull
    public MarketDataService getMarketDataService() {
        return this.marketDataService;
    }

    @Nonnull
    public OrdersService getOrdersService() {
        if (this.sandboxMode) {
            throw new IllegalStateException("\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u044b\".");
        }
        return this.ordersService;
    }

    @Nonnull
    public StopOrdersService getStopOrdersService() {
        if (this.sandboxMode) {
            throw new IllegalStateException("\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u044b\".");
        }
        return this.stopOrdersService;
    }

    @Nonnull
    public InstrumentsService getInstrumentsService() {
        return this.instrumentsService;
    }

    @Nonnull
    public OperationsService getOperationsService() {
        if (this.sandboxMode) {
            throw new IllegalStateException("\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u044b\".");
        }
        return this.operationsService;
    }

    @Nonnull
    public UsersService getUserService() {
        if (this.sandboxMode) {
            throw new IllegalStateException("\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u044b\".");
        }
        return this.userService;
    }

    @Nonnull
    public SandboxService getSandboxService() {
        if (!this.sandboxMode) {
            throw new IllegalStateException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u0440\u0435\u0436\u0438\u043c \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u044b\".");
        }
        return this.sandboxService;
    }

    @Nonnull
    public Channel getChannel() {
        return this.channel;
    }

    public boolean isSandboxMode() {
        return this.sandboxMode;
    }

    public boolean isReadonlyMode() {
        return this.readonlyMode;
    }

    static {
        Properties props = InvestApi.loadProps();
        String packageName = InvestApi.class.getPackageName();
        target = props.getProperty(String.format("%s.%s", packageName, targetPath));
        connectionTimeout = Duration.parse(props.getProperty(String.format("%s.%s", packageName, connectionTimeoutPath)));
        requestTimeout = Duration.parse(props.getProperty(String.format("%s.%s", packageName, requestTimeoutPath)));
    }

    static class LoggingClientCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private static final Metadata.Key<String> trackingIdKey = Metadata.Key.of((String)"x-tracking-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        private final Logger logger;
        private final MethodDescriptor<?, RespT> method;
        private volatile String lastTrackingId;

        LoggingClientCallListener(ClientCall.Listener<RespT> listener, Logger logger, MethodDescriptor<?, RespT> method) {
            super(listener);
            this.logger = logger;
            this.method = method;
        }

        public void onHeaders(Metadata headers) {
            this.lastTrackingId = (String)headers.get(trackingIdKey);
            this.delegate().onHeaders(headers);
        }

        public void onMessage(RespT message) {
            if (this.method.getType() == MethodDescriptor.MethodType.UNARY) {
                this.logger.debug("\u041f\u0440\u0438\u0448\u0451\u043b \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u043c\u0435\u0442\u043e\u0434\u0430 {} \u0441\u0435\u0440\u0432\u0438\u0441\u0430 {}. (x-tracking-id = {})", new Object[]{this.method.getBareMethodName(), this.method.getServiceName(), this.lastTrackingId});
            } else {
                this.logger.debug("\u041f\u0440\u0438\u0448\u043b\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442 \u043f\u043e\u0442\u043e\u043a\u0430 {} \u0441\u0435\u0440\u0432\u0438\u0441\u0430 {}.", (Object)this.method.getBareMethodName(), (Object)this.method.getServiceName());
            }
            this.delegate().onMessage(message);
        }
    }

    static class LoggingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Logger logger;
        private final MethodDescriptor<ReqT, RespT> method;

        LoggingClientCall(ClientCall<ReqT, RespT> call, Logger logger, MethodDescriptor<ReqT, RespT> method) {
            super(call);
            this.logger = logger;
            this.method = method;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            this.logger.debug("\u0413\u043e\u0442\u043e\u0432\u0438\u0442\u0441\u044f \u0432\u044b\u0437\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u0430 {} \u0441\u0435\u0440\u0432\u0438\u0441\u0430 {}.", (Object)this.method.getBareMethodName(), (Object)this.method.getServiceName());
            super.start(new LoggingClientCallListener<RespT>(responseListener, this.logger, this.method), headers);
        }
    }

    static class LoggingInterceptor
    implements ClientInterceptor {
        private final Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class);

        LoggingInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new LoggingClientCall<ReqT, RespT>(next.newCall(method, callOptions), this.logger, method);
        }
    }

    static class TimeoutInterceptor
    implements ClientInterceptor {
        private final Duration timeout;

        public TimeoutInterceptor(Duration timeout) {
            this.timeout = timeout;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (method.getType() == MethodDescriptor.MethodType.UNARY) {
                callOptions = callOptions.withDeadlineAfter(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            return next.newCall(method, callOptions);
        }
    }
}

