/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import ru.tinkoff.piapi.contract.v1.AccruedInterest;
import ru.tinkoff.piapi.contract.v1.Bond;
import ru.tinkoff.piapi.contract.v1.BondResponse;
import ru.tinkoff.piapi.contract.v1.BondsResponse;
import ru.tinkoff.piapi.contract.v1.CurrenciesResponse;
import ru.tinkoff.piapi.contract.v1.Currency;
import ru.tinkoff.piapi.contract.v1.CurrencyResponse;
import ru.tinkoff.piapi.contract.v1.Dividend;
import ru.tinkoff.piapi.contract.v1.Etf;
import ru.tinkoff.piapi.contract.v1.EtfResponse;
import ru.tinkoff.piapi.contract.v1.EtfsResponse;
import ru.tinkoff.piapi.contract.v1.Future;
import ru.tinkoff.piapi.contract.v1.FutureResponse;
import ru.tinkoff.piapi.contract.v1.FuturesResponse;
import ru.tinkoff.piapi.contract.v1.GetAccruedInterestsRequest;
import ru.tinkoff.piapi.contract.v1.GetAccruedInterestsResponse;
import ru.tinkoff.piapi.contract.v1.GetDividendsRequest;
import ru.tinkoff.piapi.contract.v1.GetDividendsResponse;
import ru.tinkoff.piapi.contract.v1.GetFuturesMarginRequest;
import ru.tinkoff.piapi.contract.v1.GetFuturesMarginResponse;
import ru.tinkoff.piapi.contract.v1.Instrument;
import ru.tinkoff.piapi.contract.v1.InstrumentIdType;
import ru.tinkoff.piapi.contract.v1.InstrumentRequest;
import ru.tinkoff.piapi.contract.v1.InstrumentResponse;
import ru.tinkoff.piapi.contract.v1.InstrumentStatus;
import ru.tinkoff.piapi.contract.v1.InstrumentsRequest;
import ru.tinkoff.piapi.contract.v1.InstrumentsServiceGrpc;
import ru.tinkoff.piapi.contract.v1.Share;
import ru.tinkoff.piapi.contract.v1.ShareResponse;
import ru.tinkoff.piapi.contract.v1.SharesResponse;
import ru.tinkoff.piapi.contract.v1.TradingSchedule;
import ru.tinkoff.piapi.contract.v1.TradingSchedulesRequest;
import ru.tinkoff.piapi.contract.v1.TradingSchedulesResponse;
import ru.tinkoff.piapi.core.utils.DateUtils;
import ru.tinkoff.piapi.core.utils.Helpers;

public class InstrumentsService {
    private static final String TO_IS_NOT_AFTER_FROM_MESSAGE = "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u043d\u0430\u0447\u0430\u043b\u0430.";
    private final InstrumentsServiceGrpc.InstrumentsServiceBlockingStub instrumentsBlockingStub;
    private final InstrumentsServiceGrpc.InstrumentsServiceStub instrumentsStub;

    InstrumentsService(@Nonnull InstrumentsServiceGrpc.InstrumentsServiceBlockingStub instrumentsBlockingStub, @Nonnull InstrumentsServiceGrpc.InstrumentsServiceStub instrumentsStub) {
        this.instrumentsBlockingStub = instrumentsBlockingStub;
        this.instrumentsStub = instrumentsStub;
    }

    private static <R> Optional<R> wrapPossibleNotFoundWithOptional(R response, Throwable ex) {
        if (response != null) {
            return Optional.of(response);
        }
        if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)ex).getStatus() == Status.NOT_FOUND) {
            return Optional.empty();
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new RuntimeException(ex);
    }

    @Nonnull
    public List<TradingSchedule> getTradingSchedulesSync(@Nonnull Instant from, @Nonnull Instant to) {
        if (this.areFromAndToValid(from, to)) {
            return this.instrumentsBlockingStub.tradingSchedules(TradingSchedulesRequest.newBuilder().setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build()).getExchangesList();
        }
        throw new IllegalArgumentException(TO_IS_NOT_AFTER_FROM_MESSAGE);
    }

    @Nonnull
    public Optional<TradingSchedule> getTradingScheduleSync(@Nonnull String exchange, @Nonnull Instant from, @Nonnull Instant to) {
        if (this.areFromAndToValid(from, to)) {
            try {
                return Optional.of((TradingSchedule)this.instrumentsBlockingStub.tradingSchedules(TradingSchedulesRequest.newBuilder().setExchange(exchange).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build()).getExchangesList().get(0));
            }
            catch (StatusRuntimeException ex) {
                if (ex.getStatus() == Status.NOT_FOUND) {
                    return Optional.empty();
                }
                throw ex;
            }
        }
        throw new IllegalArgumentException(TO_IS_NOT_AFTER_FROM_MESSAGE);
    }

    @Nonnull
    public Optional<Bond> getBondByTickerSync(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTickerSync(ticker, classCode, request -> this.instrumentsBlockingStub.bondBy(request).getInstrument());
    }

    @Nonnull
    public Optional<Bond> getBondByFigiSync(@Nonnull String figi) {
        return this.getInstrumentByFigiSync(figi, request -> this.instrumentsBlockingStub.bondBy(request).getInstrument());
    }

    @Nonnull
    public List<Bond> getTradableBondsSync() {
        return this.instrumentsBlockingStub.bonds(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build()).getInstrumentsList();
    }

    @Nonnull
    public List<Bond> getAllBondsSync() {
        return this.instrumentsBlockingStub.bonds(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build()).getInstrumentsList();
    }

    @Nonnull
    public Optional<Currency> getCurrencyByTickerSync(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTickerSync(ticker, classCode, request -> this.instrumentsBlockingStub.currencyBy(request).getInstrument());
    }

    @Nonnull
    public Optional<Currency> getCurrencyByFigiSync(@Nonnull String figi) {
        return this.getInstrumentByFigiSync(figi, request -> this.instrumentsBlockingStub.currencyBy(request).getInstrument());
    }

    @Nonnull
    public List<Currency> getTradableCurrenciesSync() {
        return this.instrumentsBlockingStub.currencies(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build()).getInstrumentsList();
    }

    @Nonnull
    public List<Currency> getAllCurrenciesSync() {
        return this.instrumentsBlockingStub.currencies(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build()).getInstrumentsList();
    }

    @Nonnull
    public Optional<Etf> getEtfByTickerSync(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTickerSync(ticker, classCode, request -> this.instrumentsBlockingStub.etfBy(request).getInstrument());
    }

    @Nonnull
    public Optional<Etf> getEtfByFigiSync(@Nonnull String figi) {
        return this.getInstrumentByFigiSync(figi, request -> this.instrumentsBlockingStub.etfBy(request).getInstrument());
    }

    @Nonnull
    public List<Etf> getTradableEtfsSync() {
        return this.instrumentsBlockingStub.etfs(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build()).getInstrumentsList();
    }

    @Nonnull
    public List<Etf> getAllEtfsSync() {
        return this.instrumentsBlockingStub.etfs(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build()).getInstrumentsList();
    }

    @Nonnull
    public Optional<Future> getFutureByTickerSync(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTickerSync(ticker, classCode, request -> this.instrumentsBlockingStub.futureBy(request).getInstrument());
    }

    @Nonnull
    public Optional<Future> getFutureByFigiSync(@Nonnull String figi) {
        return this.getInstrumentByFigiSync(figi, request -> this.instrumentsBlockingStub.futureBy(request).getInstrument());
    }

    @Nonnull
    public List<Future> getTradableFuturesSync() {
        return this.instrumentsBlockingStub.futures(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build()).getInstrumentsList();
    }

    @Nonnull
    public List<Future> getAllFuturesSync() {
        return this.instrumentsBlockingStub.futures(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build()).getInstrumentsList();
    }

    @Nonnull
    public Optional<Share> getShareByTickerSync(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTickerSync(ticker, classCode, request -> this.instrumentsBlockingStub.shareBy(request).getInstrument());
    }

    @Nonnull
    public Optional<Share> getShareByFigiSync(@Nonnull String figi) {
        return this.getInstrumentByFigiSync(figi, request -> this.instrumentsBlockingStub.shareBy(request).getInstrument());
    }

    @Nonnull
    public List<Share> getTradableSharesSync() {
        return this.instrumentsBlockingStub.shares(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build()).getInstrumentsList();
    }

    @Nonnull
    public List<Share> getAllSharesSync() {
        return this.instrumentsBlockingStub.shares(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build()).getInstrumentsList();
    }

    @Nonnull
    public List<AccruedInterest> getAccruedInterestsSync(@Nonnull String figi, @Nonnull Instant from, @Nonnull Instant to) {
        return this.instrumentsBlockingStub.getAccruedInterests(GetAccruedInterestsRequest.newBuilder().setFigi(figi).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build()).getAccruedInterestsList();
    }

    @Nonnull
    public GetFuturesMarginResponse getFuturesMarginSync(@Nonnull String figi) {
        return this.instrumentsBlockingStub.getFuturesMargin(GetFuturesMarginRequest.newBuilder().setFigi(figi).build());
    }

    @Nonnull
    public Optional<Instrument> getInstrumentByTickerSync(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTickerSync(ticker, classCode, request -> this.instrumentsBlockingStub.getInstrumentBy(request).getInstrument());
    }

    @Nonnull
    public Optional<Instrument> getInstrumentByFigiSync(@Nonnull String figi) {
        return this.getInstrumentByFigiSync(figi, request -> this.instrumentsBlockingStub.getInstrumentBy(request).getInstrument());
    }

    @Nonnull
    public List<Dividend> getDividendsSync(@Nonnull String figi, @Nonnull Instant from, @Nonnull Instant to) {
        return this.instrumentsBlockingStub.getDividends(GetDividendsRequest.newBuilder().setFigi(figi).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build()).getDividendsList();
    }

    @Nonnull
    public CompletableFuture<List<TradingSchedule>> getTradingSchedules(@Nonnull Instant from, @Nonnull Instant to) {
        if (this.areFromAndToValid(from, to)) {
            return Helpers.wrapWithFuture(observer -> this.instrumentsStub.tradingSchedules(TradingSchedulesRequest.newBuilder().setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build(), observer)).thenApply(TradingSchedulesResponse::getExchangesList);
        }
        return CompletableFuture.failedFuture(new IllegalArgumentException(TO_IS_NOT_AFTER_FROM_MESSAGE));
    }

    @Nonnull
    public CompletableFuture<Optional<TradingSchedule>> getTradingSchedule(@Nonnull String exchange, @Nonnull Instant from, @Nonnull Instant to) {
        if (this.areFromAndToValid(from, to)) {
            return Helpers.wrapWithFuture(observer -> this.instrumentsStub.tradingSchedules(TradingSchedulesRequest.newBuilder().setExchange(exchange).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build(), observer)).handle((response, ex) -> {
                if (response != null) {
                    return Optional.of((TradingSchedule)response.getExchangesList().get(0));
                }
                if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)((Object)ex)).getStatus() == Status.NOT_FOUND) {
                    return Optional.empty();
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException((Throwable)ex);
            });
        }
        return CompletableFuture.failedFuture(new IllegalArgumentException(TO_IS_NOT_AFTER_FROM_MESSAGE));
    }

    @Nonnull
    public CompletableFuture<Optional<Bond>> getBondByTicker(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTicker(ticker, classCode, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).bondBy(arg_0, arg_1), BondResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<Optional<Bond>> getBondByFigi(@Nonnull String figi) {
        return this.getInstrumentByFigi(figi, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).bondBy(arg_0, arg_1), BondResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<List<Bond>> getTradableBonds() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.bonds(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build(), observer)).thenApply(BondsResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<List<Bond>> getAllBonds() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.bonds(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build(), observer)).thenApply(BondsResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<Optional<Currency>> getCurrencyByTicker(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTicker(ticker, classCode, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).currencyBy(arg_0, arg_1), CurrencyResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<Optional<Currency>> getCurrencyByFigi(@Nonnull String figi) {
        return this.getInstrumentByFigi(figi, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).currencyBy(arg_0, arg_1), CurrencyResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<List<Currency>> getTradableCurrencies() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.currencies(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build(), observer)).thenApply(CurrenciesResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<List<Currency>> getAllCurrencies() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.currencies(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build(), observer)).thenApply(CurrenciesResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<Optional<Etf>> getEtfByTicker(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTicker(ticker, classCode, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).etfBy(arg_0, arg_1), EtfResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<Optional<Etf>> getEtfByFigi(@Nonnull String figi) {
        return this.getInstrumentByFigi(figi, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).etfBy(arg_0, arg_1), EtfResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<List<Etf>> getTradableEtfs() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.etfs(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build(), observer)).thenApply(EtfsResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<List<Etf>> getAllEtfs() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.etfs(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build(), observer)).thenApply(EtfsResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<Optional<Future>> getFutureByTicker(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTicker(ticker, classCode, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).futureBy(arg_0, arg_1), FutureResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<Optional<Future>> getFutureByFigi(@Nonnull String figi) {
        return this.getInstrumentByFigi(figi, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).futureBy(arg_0, arg_1), FutureResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<List<Future>> getAllFutures() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.futures(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build(), observer)).thenApply(FuturesResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<List<Future>> getTradableFutures() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.futures(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build(), observer)).thenApply(FuturesResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<Optional<Share>> getShareByTicker(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTicker(ticker, classCode, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).shareBy(arg_0, arg_1), ShareResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<Optional<Share>> getShareByFigi(@Nonnull String figi) {
        return this.getInstrumentByFigi(figi, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).shareBy(arg_0, arg_1), ShareResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<List<Share>> getAllShares() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.shares(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_ALL).build(), observer)).thenApply(SharesResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<List<Share>> getTradableShares() {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.shares(InstrumentsRequest.newBuilder().setInstrumentStatus(InstrumentStatus.INSTRUMENT_STATUS_BASE).build(), observer)).thenApply(SharesResponse::getInstrumentsList);
    }

    @Nonnull
    public CompletableFuture<List<AccruedInterest>> getAccruedInterests(@Nonnull String figi, @Nonnull Instant from, @Nonnull Instant to) {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.getAccruedInterests(GetAccruedInterestsRequest.newBuilder().setFigi(figi).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build(), observer)).thenApply(GetAccruedInterestsResponse::getAccruedInterestsList);
    }

    @Nonnull
    public CompletableFuture<GetFuturesMarginResponse> getFuturesMargin(@Nonnull String figi) {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.getFuturesMargin(GetFuturesMarginRequest.newBuilder().setFigi(figi).build(), observer));
    }

    @Nonnull
    public CompletableFuture<Optional<Instrument>> getInstrumentByTicker(@Nonnull String ticker, @Nonnull String classCode) {
        return this.getInstrumentByTicker(ticker, classCode, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).getInstrumentBy(arg_0, arg_1), InstrumentResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<Optional<Instrument>> getInstrumentByFigi(@Nonnull String figi) {
        return this.getInstrumentByFigi(figi, (arg_0, arg_1) -> ((InstrumentsServiceGrpc.InstrumentsServiceStub)this.instrumentsStub).getInstrumentBy(arg_0, arg_1), InstrumentResponse::getInstrument);
    }

    @Nonnull
    public CompletableFuture<List<Dividend>> getDividends(@Nonnull String figi, @Nonnull Instant from, @Nonnull Instant to) {
        return Helpers.wrapWithFuture(observer -> this.instrumentsStub.getDividends(GetDividendsRequest.newBuilder().setFigi(figi).setFrom(DateUtils.instantToTimestamp(from)).setTo(DateUtils.instantToTimestamp(to)).build(), observer)).thenApply(GetDividendsResponse::getDividendsList);
    }

    private <T> Optional<T> getInstrumentByTickerSync(@Nonnull String ticker, @Nonnull String classCode, Function<InstrumentRequest, T> getter) {
        try {
            return Optional.of(getter.apply(InstrumentRequest.newBuilder().setIdType(InstrumentIdType.INSTRUMENT_ID_TYPE_TICKER).setId(ticker).setClassCode(classCode).build()));
        }
        catch (StatusRuntimeException ex) {
            if (ex.getStatus() == Status.NOT_FOUND) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    private <T> Optional<T> getInstrumentByFigiSync(@Nonnull String figi, Function<InstrumentRequest, T> getter) {
        try {
            return Optional.of(getter.apply(InstrumentRequest.newBuilder().setIdType(InstrumentIdType.INSTRUMENT_ID_TYPE_FIGI).setId(figi).build()));
        }
        catch (StatusRuntimeException ex) {
            if (ex.getStatus() == Status.NOT_FOUND) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    private <T, R> CompletableFuture<Optional<T>> getInstrumentByTicker(@Nonnull String ticker, @Nonnull String classCode, BiConsumer<InstrumentRequest, StreamObserver<R>> call, Function<R, T> extractor) {
        return ((CompletableFuture)Helpers.wrapWithFuture(observer -> call.accept(InstrumentRequest.newBuilder().setIdType(InstrumentIdType.INSTRUMENT_ID_TYPE_TICKER).setId(ticker).setClassCode(classCode).build(), (StreamObserver)observer)).handle(InstrumentsService::wrapPossibleNotFoundWithOptional)).thenApply(x -> x.map(extractor));
    }

    private <T, R> CompletableFuture<Optional<T>> getInstrumentByFigi(@Nonnull String figi, BiConsumer<InstrumentRequest, StreamObserver<R>> call, Function<R, T> extractor) {
        return ((CompletableFuture)Helpers.wrapWithFuture(observer -> call.accept(InstrumentRequest.newBuilder().setIdType(InstrumentIdType.INSTRUMENT_ID_TYPE_FIGI).setId(figi).build(), (StreamObserver)observer)).handle(InstrumentsService::wrapPossibleNotFoundWithOptional)).thenApply(x -> x.map(extractor));
    }

    private boolean areFromAndToValid(Instant from, Instant to) {
        return from.isBefore(to);
    }
}

