/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.symbol.processor.utils;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueArgument;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.symbol.processor.utils.Publisher;
import ru.tinkoff.kora.kafka.symbol.processor.utils.PublisherMethod;
import ru.tinkoff.kora.kafka.symbol.processor.utils.RecordElement;
import ru.tinkoff.kora.kafka.symbol.processor.utils.RecordType;
import ru.tinkoff.kora.kafka.symbol.processor.utils.TransactionalPublisher;
import ru.tinkoff.kora.ksp.common.exception.ProcessingErrorException;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"parseMethods", "", "Lru/tinkoff/kora/kafka/symbol/processor/utils/PublisherMethod;", "type", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "parseParameters", "Lru/tinkoff/kora/kafka/symbol/processor/utils/PublisherMethod$Parameters;", "method", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "parsePublisher", "Lru/tinkoff/kora/kafka/symbol/processor/utils/Publisher;", "parseTransactionalPublisher", "Lru/tinkoff/kora/kafka/symbol/processor/utils/TransactionalPublisher;", "kafka-symbol-processor"})
public final class KafkaPublisherUtilsKt {
    @NotNull
    public static final TransactionalPublisher parseTransactionalPublisher(@NotNull KSClassDeclaration type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KSTypeReference kSTypeReference = ((KSTypeArgument)CollectionsKt.first((List)((KSTypeReference)SequencesKt.first((Sequence)type.getSuperTypes())).resolve().getArguments())).getType();
        Intrinsics.checkNotNull((Object)kSTypeReference);
        KSDeclaration kSDeclaration = kSTypeReference.resolve().getDeclaration();
        Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
        Publisher publisher = KafkaPublisherUtilsKt.parsePublisher((KSClassDeclaration)kSDeclaration);
        return new TransactionalPublisher(type, publisher);
    }

    @NotNull
    public static final Publisher parsePublisher(@NotNull KSClassDeclaration type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List supertypes2 = SequencesKt.toList((Sequence)type.getSuperTypes());
        KSType supertype = ((KSTypeReference)supertypes2.get(0)).resolve();
        List<PublisherMethod> publisherMethods = KafkaPublisherUtilsKt.parseMethods(type);
        KSTypeArgument key = (KSTypeArgument)supertype.getArguments().get(0);
        KSTypeArgument value = (KSTypeArgument)supertype.getArguments().get(1);
        return new Publisher(type, supertype, new RecordType(key), new RecordType(value), publisherMethods);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PublisherMethod> parseMethods(KSClassDeclaration type) {
        ArrayList<PublisherMethod> methods = new ArrayList<PublisherMethod>();
        for (KSFunctionDeclaration element : UtilsKt.getDeclaredFunctions((KSClassDeclaration)type)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KSValueArgument it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            KSAnnotation topicAnnotation;
            Object v0;
            Object element$iv2;
            block4: {
                Sequence $this$firstOrNull$iv = element.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    KSAnnotation it2 = (KSAnnotation)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)KsTypesKt.toClassName((KSType)it2.getAnnotationType().resolve()), (Object)KafkaClassNames.INSTANCE.getKafkaTopicAnnotation())) continue;
                    v0 = element$iv2;
                    break block4;
                }
                v0 = null;
            }
            if ((topicAnnotation = (KSAnnotation)v0) == null) continue;
            Iterable $i$f$firstOrNull = topicAnnotation.getArguments();
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KSValueArgument)element$iv$iv;
                boolean bl = false;
                KSName kSName = it.getName();
                Intrinsics.checkNotNull((Object)kSName);
                if (!Intrinsics.areEqual((Object)kSName.getShortName(), (Object)"value")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (KSValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf(it.getValue()));
            }
            String pathToTopicConfig = (String)CollectionsKt.first((List)((List)destination$iv$iv));
            PublisherMethod.Parameters parameters = KafkaPublisherUtilsKt.parseParameters(element);
            methods.add(new PublisherMethod(element, pathToTopicConfig, parameters));
        }
        return methods;
    }

    private static final PublisherMethod.Parameters parseParameters(KSFunctionDeclaration method) {
        RecordElement keyParameter = null;
        RecordElement valueParameter = null;
        KSValueParameter headersParameter = null;
        for (KSValueParameter parameter : method.getParameters()) {
            if (Intrinsics.areEqual((Object)KsTypesKt.toClassName((KSType)parameter.getType().resolve()), (Object)KafkaClassNames.INSTANCE.getHeaders())) {
                headersParameter = parameter;
                continue;
            }
            if (valueParameter == null) {
                valueParameter = new RecordElement(parameter);
                continue;
            }
            if (keyParameter == null) {
                keyParameter = valueParameter;
                valueParameter = new RecordElement(parameter);
                continue;
            }
            KSName kSName = parameter.getName();
            Intrinsics.checkNotNull((Object)kSName);
            String string = kSName.getQualifier();
            KSName kSName2 = keyParameter.getElement().getName();
            Intrinsics.checkNotNull((Object)kSName2);
            String string2 = kSName2.getQualifier();
            KSName kSName3 = valueParameter.getElement().getName();
            Intrinsics.checkNotNull((Object)kSName3);
            String message = "@KafkaPublisher method has unknown type parameter '" + string + "'. Previous unknown type parameters are: '" + string2 + "'(detected as key), '" + kSName3.getQualifier() + "'(detected as value)";
            throw new ProcessingErrorException(message, (KSAnnotated)parameter);
        }
        RecordElement recordElement = valueParameter;
        Intrinsics.checkNotNull(recordElement);
        return new PublisherMethod.Parameters(keyParameter, recordElement, headersParameter);
    }
}

