/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.symbol.processor.utils;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaClassNames;
import ru.tinkoff.kora.ksp.common.AnnotationUtils;
import ru.tinkoff.kora.ksp.common.TagUtils;
import ru.tinkoff.kora.ksp.common.exception.ProcessingErrorException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\b*\u00020\tH\u0002J\f\u0010\u000b\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/utils/KafkaPublisherUtils;", "", "()V", "parsePublisherType", "Lru/tinkoff/kora/kafka/symbol/processor/utils/KafkaPublisherUtils$PublisherData;", "method", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "isHeaders", "", "Lcom/squareup/kotlinpoet/TypeName;", "isProducerCallback", "isProducerRecord", "PublisherData", "kafka-symbol-processor"})
public final class KafkaPublisherUtils {
    @NotNull
    public static final KafkaPublisherUtils INSTANCE = new KafkaPublisherUtils();

    private KafkaPublisherUtils() {
    }

    @NotNull
    public final PublisherData parsePublisherType(@NotNull KSFunctionDeclaration method) {
        TypeName keyType;
        Object recordType;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        KSValueParameter key = null;
        KSValueParameter value = null;
        KSValueParameter headers = null;
        KSValueParameter record = null;
        KSValueParameter producerCallback = null;
        for (KSValueParameter parameter : method.getParameters()) {
            TypeName type = KsTypesKt.toTypeName$default((KSTypeReference)parameter.getType(), null, (int)1, null);
            if (this.isProducerCallback(type)) {
                if (producerCallback != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: only one Callback parameter is allowed", (KSAnnotated)parameter);
                }
                producerCallback = parameter;
                continue;
            }
            if (this.isHeaders(type)) {
                if (record != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: Headers parameter can't be used with record parameter", (KSAnnotated)parameter);
                }
                if (headers != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: only one Headers parameter is allowed", (KSAnnotated)parameter);
                }
                headers = parameter;
                continue;
            }
            if (this.isProducerRecord(type)) {
                if (value != null || headers != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: Record parameter can't be combined with other parameters", (KSAnnotated)parameter);
                }
                if (AnnotationUtils.INSTANCE.isAnnotationPresent((KSAnnotated)method, KafkaClassNames.INSTANCE.getKafkaTopicAnnotation())) {
                    throw new ProcessingErrorException("Invalid publisher signature: Record parameter can't be combined @Topic annotation", (KSAnnotated)parameter);
                }
                record = parameter;
                continue;
            }
            if (record != null) {
                throw new ProcessingErrorException("Invalid publisher signature: Record parameter can't be combined with key or value parameters", (KSAnnotated)parameter);
            }
            if (key != null) {
                throw new ProcessingErrorException("Invalid publisher signature: only ProducerRecord or Headers, key and value parameters are allowed", (KSAnnotated)parameter);
            }
            if (value != null) {
                key = value;
            }
            value = parameter;
        }
        if (record != null) {
            recordType = record.getType().resolve();
            TypeName typeName = KsTypesKt.toTypeName$default((KSType)recordType, null, (int)1, null).copy(false, CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)typeName, (String)"null cannot be cast to non-null type com.squareup.kotlinpoet.ParameterizedTypeName");
            ParameterizedTypeName recordTypeName = (ParameterizedTypeName)typeName;
            keyType = (TypeName)recordTypeName.getTypeArguments().get(0);
            TypeName valueType = (TypeName)recordTypeName.getTypeArguments().get(1);
            Set keyTag = TagUtils.INSTANCE.parseTagValue((KSAnnotated)recordType.getArguments().get(0));
            Set valueTag = TagUtils.INSTANCE.parseTagValue((KSAnnotated)recordType.getArguments().get(1));
            return new PublisherData(keyType, keyTag, valueType, valueTag, key, value, headers, record, producerCallback);
        }
        if (!AnnotationUtils.INSTANCE.isAnnotationPresent((KSAnnotated)method, KafkaClassNames.INSTANCE.getKafkaTopicAnnotation())) {
            throw new ProcessingErrorException("Invalid publisher signature: key/value/headers signature requires @Topic annotation", (KSAnnotated)method);
        }
        if (value == null) {
            recordType = "Required value was null.";
            throw new IllegalArgumentException(recordType.toString());
        }
        TypeName valueType = KsTypesKt.toTypeName$default((KSType)value.getType().resolve(), null, (int)1, null).copy(false, CollectionsKt.emptyList());
        Set valueTag = TagUtils.INSTANCE.parseTags((KSAnnotated)value);
        if (key == null) {
            return new PublisherData(null, SetsKt.emptySet(), valueType, valueTag, key, value, headers, record, producerCallback);
        }
        keyType = KsTypesKt.toTypeName$default((KSType)key.getType().resolve(), null, (int)1, null).copy(false, CollectionsKt.emptyList());
        Set keyTag = TagUtils.INSTANCE.parseTags((KSAnnotated)key);
        return new PublisherData(keyType, keyTag, valueType, valueTag, key, value, headers, record, producerCallback);
    }

    private final boolean isProducerCallback(TypeName $this$isProducerCallback) {
        return Intrinsics.areEqual((Object)$this$isProducerCallback, (Object)KafkaClassNames.INSTANCE.getProducerCallback());
    }

    private final boolean isHeaders(TypeName $this$isHeaders) {
        return Intrinsics.areEqual((Object)$this$isHeaders, (Object)KafkaClassNames.INSTANCE.getHeaders());
    }

    private final boolean isProducerRecord(TypeName $this$isProducerRecord) {
        return $this$isProducerRecord instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)$this$isProducerRecord).getRawType(), (Object)KafkaClassNames.INSTANCE.getProducerRecord());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Be\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003J{\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006,"}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/utils/KafkaPublisherUtils$PublisherData;", "", "keyType", "Lcom/squareup/kotlinpoet/TypeName;", "keyTag", "", "", "valueType", "valueTag", "keyVar", "Lcom/google/devtools/ksp/symbol/KSValueParameter;", "valueVar", "headersVar", "recordVar", "callback", "(Lcom/squareup/kotlinpoet/TypeName;Ljava/util/Set;Lcom/squareup/kotlinpoet/TypeName;Ljava/util/Set;Lcom/google/devtools/ksp/symbol/KSValueParameter;Lcom/google/devtools/ksp/symbol/KSValueParameter;Lcom/google/devtools/ksp/symbol/KSValueParameter;Lcom/google/devtools/ksp/symbol/KSValueParameter;Lcom/google/devtools/ksp/symbol/KSValueParameter;)V", "getCallback", "()Lcom/google/devtools/ksp/symbol/KSValueParameter;", "getHeadersVar", "getKeyTag", "()Ljava/util/Set;", "getKeyType", "()Lcom/squareup/kotlinpoet/TypeName;", "getKeyVar", "getRecordVar", "getValueTag", "getValueType", "getValueVar", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka-symbol-processor"})
    public static final class PublisherData {
        @Nullable
        private final TypeName keyType;
        @NotNull
        private final Set<String> keyTag;
        @NotNull
        private final TypeName valueType;
        @NotNull
        private final Set<String> valueTag;
        @Nullable
        private final KSValueParameter keyVar;
        @Nullable
        private final KSValueParameter valueVar;
        @Nullable
        private final KSValueParameter headersVar;
        @Nullable
        private final KSValueParameter recordVar;
        @Nullable
        private final KSValueParameter callback;

        public PublisherData(@Nullable TypeName keyType, @NotNull Set<String> keyTag, @NotNull TypeName valueType, @NotNull Set<String> valueTag, @Nullable KSValueParameter keyVar, @Nullable KSValueParameter valueVar, @Nullable KSValueParameter headersVar, @Nullable KSValueParameter recordVar, @Nullable KSValueParameter callback) {
            Intrinsics.checkNotNullParameter(keyTag, (String)"keyTag");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter(valueTag, (String)"valueTag");
            this.keyType = keyType;
            this.keyTag = keyTag;
            this.valueType = valueType;
            this.valueTag = valueTag;
            this.keyVar = keyVar;
            this.valueVar = valueVar;
            this.headersVar = headersVar;
            this.recordVar = recordVar;
            this.callback = callback;
        }

        @Nullable
        public final TypeName getKeyType() {
            return this.keyType;
        }

        @NotNull
        public final Set<String> getKeyTag() {
            return this.keyTag;
        }

        @NotNull
        public final TypeName getValueType() {
            return this.valueType;
        }

        @NotNull
        public final Set<String> getValueTag() {
            return this.valueTag;
        }

        @Nullable
        public final KSValueParameter getKeyVar() {
            return this.keyVar;
        }

        @Nullable
        public final KSValueParameter getValueVar() {
            return this.valueVar;
        }

        @Nullable
        public final KSValueParameter getHeadersVar() {
            return this.headersVar;
        }

        @Nullable
        public final KSValueParameter getRecordVar() {
            return this.recordVar;
        }

        @Nullable
        public final KSValueParameter getCallback() {
            return this.callback;
        }

        @Nullable
        public final TypeName component1() {
            return this.keyType;
        }

        @NotNull
        public final Set<String> component2() {
            return this.keyTag;
        }

        @NotNull
        public final TypeName component3() {
            return this.valueType;
        }

        @NotNull
        public final Set<String> component4() {
            return this.valueTag;
        }

        @Nullable
        public final KSValueParameter component5() {
            return this.keyVar;
        }

        @Nullable
        public final KSValueParameter component6() {
            return this.valueVar;
        }

        @Nullable
        public final KSValueParameter component7() {
            return this.headersVar;
        }

        @Nullable
        public final KSValueParameter component8() {
            return this.recordVar;
        }

        @Nullable
        public final KSValueParameter component9() {
            return this.callback;
        }

        @NotNull
        public final PublisherData copy(@Nullable TypeName keyType, @NotNull Set<String> keyTag, @NotNull TypeName valueType, @NotNull Set<String> valueTag, @Nullable KSValueParameter keyVar, @Nullable KSValueParameter valueVar, @Nullable KSValueParameter headersVar, @Nullable KSValueParameter recordVar, @Nullable KSValueParameter callback) {
            Intrinsics.checkNotNullParameter(keyTag, (String)"keyTag");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter(valueTag, (String)"valueTag");
            return new PublisherData(keyType, keyTag, valueType, valueTag, keyVar, valueVar, headersVar, recordVar, callback);
        }

        public static /* synthetic */ PublisherData copy$default(PublisherData publisherData, TypeName typeName, Set set, TypeName typeName2, Set set2, KSValueParameter kSValueParameter, KSValueParameter kSValueParameter2, KSValueParameter kSValueParameter3, KSValueParameter kSValueParameter4, KSValueParameter kSValueParameter5, int n, Object object) {
            if ((n & 1) != 0) {
                typeName = publisherData.keyType;
            }
            if ((n & 2) != 0) {
                set = publisherData.keyTag;
            }
            if ((n & 4) != 0) {
                typeName2 = publisherData.valueType;
            }
            if ((n & 8) != 0) {
                set2 = publisherData.valueTag;
            }
            if ((n & 0x10) != 0) {
                kSValueParameter = publisherData.keyVar;
            }
            if ((n & 0x20) != 0) {
                kSValueParameter2 = publisherData.valueVar;
            }
            if ((n & 0x40) != 0) {
                kSValueParameter3 = publisherData.headersVar;
            }
            if ((n & 0x80) != 0) {
                kSValueParameter4 = publisherData.recordVar;
            }
            if ((n & 0x100) != 0) {
                kSValueParameter5 = publisherData.callback;
            }
            return publisherData.copy(typeName, set, typeName2, set2, kSValueParameter, kSValueParameter2, kSValueParameter3, kSValueParameter4, kSValueParameter5);
        }

        @NotNull
        public String toString() {
            return "PublisherData(keyType=" + this.keyType + ", keyTag=" + this.keyTag + ", valueType=" + this.valueType + ", valueTag=" + this.valueTag + ", keyVar=" + this.keyVar + ", valueVar=" + this.valueVar + ", headersVar=" + this.headersVar + ", recordVar=" + this.recordVar + ", callback=" + this.callback + ")";
        }

        public int hashCode() {
            int result = this.keyType == null ? 0 : this.keyType.hashCode();
            result = result * 31 + ((Object)this.keyTag).hashCode();
            result = result * 31 + this.valueType.hashCode();
            result = result * 31 + ((Object)this.valueTag).hashCode();
            result = result * 31 + (this.keyVar == null ? 0 : this.keyVar.hashCode());
            result = result * 31 + (this.valueVar == null ? 0 : this.valueVar.hashCode());
            result = result * 31 + (this.headersVar == null ? 0 : this.headersVar.hashCode());
            result = result * 31 + (this.recordVar == null ? 0 : this.recordVar.hashCode());
            result = result * 31 + (this.callback == null ? 0 : this.callback.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PublisherData)) {
                return false;
            }
            PublisherData publisherData = (PublisherData)other;
            if (!Intrinsics.areEqual((Object)this.keyType, (Object)publisherData.keyType)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.keyTag, publisherData.keyTag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueType, (Object)publisherData.valueType)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.valueTag, publisherData.valueTag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.keyVar, (Object)publisherData.keyVar)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueVar, (Object)publisherData.valueVar)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headersVar, (Object)publisherData.headersVar)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.recordVar, (Object)publisherData.recordVar)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.callback, (Object)publisherData.callback);
        }
    }
}

