/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.symbol.processor.consumer;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaConsumerConfigGenerator;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaConsumerModuleGenerator;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaContainerGenerator;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaHandlerGenerator;
import ru.tinkoff.kora.ksp.common.BaseSymbolProcessor;
import ru.tinkoff.kora.ksp.common.KspCommonUtilsKt;
import ru.tinkoff.kora.ksp.common.exception.ProcessingErrorException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaListenerSymbolProcessor;", "Lru/tinkoff/kora/ksp/common/BaseSymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "getResolver", "()Lcom/google/devtools/ksp/processing/Resolver;", "setResolver", "(Lcom/google/devtools/ksp/processing/Resolver;)V", "processController", "", "controller", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "processRound", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "kafka-symbol-processor"})
public final class KafkaListenerSymbolProcessor
extends BaseSymbolProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    public Resolver resolver;

    public KafkaListenerSymbolProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(environment);
        this.environment = environment;
    }

    @NotNull
    public final Resolver getResolver() {
        Resolver resolver = this.resolver;
        if (resolver != null) {
            return resolver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resolver");
        return null;
    }

    public final void setResolver(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"<set-?>");
        this.resolver = resolver;
    }

    @NotNull
    public List<KSAnnotated> processRound(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.setResolver(resolver);
        HashSet<KSClassDeclaration> controllers = new HashSet<KSClassDeclaration>();
        for (KSAnnotated it : Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)KafkaClassNames.INSTANCE.getKafkaListener().getCanonicalName(), (boolean)false, (int)2, null)) {
            KspCommonUtilsKt.visitFunction((KSAnnotated)it, (Function1)((Function1)new Function1<KSFunctionDeclaration, Boolean>(controllers){
                final /* synthetic */ HashSet<KSClassDeclaration> $controllers;
                {
                    this.$controllers = $controllers;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KSFunctionDeclaration ksFunctionDeclaration) {
                    Intrinsics.checkNotNullParameter((Object)ksFunctionDeclaration, (String)"ksFunctionDeclaration");
                    KSDeclaration kSDeclaration = ksFunctionDeclaration.getParentDeclaration();
                    Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
                    return this.$controllers.add((KSClassDeclaration)kSDeclaration);
                }
            }));
        }
        for (KSClassDeclaration ksClassDeclaration : controllers) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)ksClassDeclaration, (String)"ksClassDeclaration");
                this.processController(ksClassDeclaration);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.getKspLogger());
            }
        }
        return CollectionsKt.emptyList();
    }

    private final void processController(KSClassDeclaration controller) {
        KafkaHandlerGenerator methodGenerator = new KafkaHandlerGenerator(this.environment.getLogger());
        KafkaConsumerConfigGenerator kafkaConfigGenerator = new KafkaConsumerConfigGenerator();
        KafkaContainerGenerator kafkaContainerGenerator = new KafkaContainerGenerator();
        KafkaConsumerModuleGenerator generator = new KafkaConsumerModuleGenerator(methodGenerator, kafkaConfigGenerator, kafkaContainerGenerator);
        FileSpec file = generator.generateModule(controller);
        OriginatingKSFilesKt.writeTo$default((FileSpec)file, (CodeGenerator)this.environment.getCodeGenerator(), (boolean)false, null, (int)4, null);
    }
}

