/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.symbol.processor.consumer;

import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.Modifier;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaUtils;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.ConsumerParameter;
import ru.tinkoff.kora.ksp.common.KotlinPoetUtils;
import ru.tinkoff.kora.ksp.common.TagUtils;
import ru.tinkoff.kora.ksp.common.exception.ProcessingErrorException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J&\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J$\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaHandlerGenerator;", "", "kspLogger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "(Lcom/google/devtools/ksp/processing/KSPLogger;)V", "context", "Lcom/squareup/kotlinpoet/ClassName;", "getContext", "()Lcom/squareup/kotlinpoet/ClassName;", "dispatchers", "getDispatchers", "generate", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaHandlerGenerator$HandlerFunction;", "functionDeclaration", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "parameters", "", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/ConsumerParameter;", "generateKeyValue", "b", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "generateRecord", "function", "generateRecords", "HandlerFunction", "kafka-symbol-processor"})
public final class KafkaHandlerGenerator {
    @NotNull
    private final KSPLogger kspLogger;
    @NotNull
    private final ClassName dispatchers;
    @NotNull
    private final ClassName context;

    public KafkaHandlerGenerator(@NotNull KSPLogger kspLogger) {
        Intrinsics.checkNotNullParameter((Object)kspLogger, (String)"kspLogger");
        this.kspLogger = kspLogger;
        String[] stringArray = new String[]{"Dispatchers"};
        this.dispatchers = new ClassName("kotlinx.coroutines", stringArray);
        stringArray = new String[]{"Context"};
        this.context = new ClassName("ru.tinkoff.kora.common", stringArray);
    }

    @NotNull
    public final ClassName getDispatchers() {
        return this.dispatchers;
    }

    @NotNull
    public final ClassName getContext() {
        return this.context;
    }

    @NotNull
    public final HandlerFunction generate(@NotNull KSFunctionDeclaration functionDeclaration, @NotNull List<? extends ConsumerParameter> parameters) {
        boolean bl;
        boolean hasRecords;
        FunSpec.Builder b;
        block7: {
            boolean bl2;
            block6: {
                Intrinsics.checkNotNullParameter((Object)functionDeclaration, (String)"functionDeclaration");
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                KSDeclaration kSDeclaration = functionDeclaration.getParentDeclaration();
                Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
                KSClassDeclaration controller = (KSClassDeclaration)kSDeclaration;
                String tagName = KafkaUtils.INSTANCE.tagTypeName(functionDeclaration);
                b = FunSpec.Companion.builder(KafkaUtils.INSTANCE.handlerFunName(functionDeclaration)).addParameter("controller", (TypeName)KsClassDeclarationsKt.toClassName((KSClassDeclaration)controller), new KModifier[0]).addAnnotation(TagUtils.INSTANCE.toTagAnnotation((Collection)CollectionsKt.listOf((Object)tagName)));
                Iterable $this$any$iv = parameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConsumerParameter it = (ConsumerParameter)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof ConsumerParameter.Records)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            hasRecords = bl2;
            Iterable $this$any$iv = parameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConsumerParameter it = (ConsumerParameter)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof ConsumerParameter.Record)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasRecord = bl;
        return hasRecords ? this.generateRecords(b, functionDeclaration, parameters) : (hasRecord ? this.generateRecord(b, functionDeclaration, parameters) : this.generateKeyValue(b, functionDeclaration, parameters));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HandlerFunction generateRecord(@NotNull FunSpec.Builder b, @NotNull KSFunctionDeclaration function, @NotNull List<? extends ConsumerParameter> parameters) {
        Object object;
        void controlFlow$iv;
        void $this$controlFlow$iv;
        Object element$iv4;
        boolean bl;
        boolean catchesKeyException;
        Object element$iv22;
        TypeName valueType;
        TypeName keyType;
        ConsumerParameter.Record recordParameter;
        block34: {
            boolean bl2;
            block33: {
                String message;
                Object element$iv32;
                block32: {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    Iterable $this$first$iv = parameters;
                    boolean $i$f$first = false;
                    for (Object element$iv32 : $this$first$iv) {
                        ConsumerParameter it = (ConsumerParameter)element$iv32;
                        boolean bl3 = false;
                        if (!(it instanceof ConsumerParameter.Record)) continue;
                        break block32;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv32;
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type ru.tinkoff.kora.kafka.symbol.processor.consumer.ConsumerParameter.Record");
                recordParameter = (ConsumerParameter.Record)t;
                TypeName typeName = KsTypesKt.toTypeName$default((KSTypeReference)recordParameter.getParameter().getType(), null, (int)1, null);
                Intrinsics.checkNotNull((Object)typeName, (String)"null cannot be cast to non-null type com.squareup.kotlinpoet.ParameterizedTypeName");
                ParameterizedTypeName recordType = (ParameterizedTypeName)typeName;
                keyType = TypeName.copy$default((TypeName)((TypeName)recordType.getTypeArguments().get(0)), (boolean)false, null, (int)2, null);
                valueType = TypeName.copy$default((TypeName)((TypeName)recordType.getTypeArguments().get(1)), (boolean)false, null, (int)2, null);
                if (Intrinsics.areEqual((Object)keyType, (Object)TypeNames.STAR) || Intrinsics.areEqual((Object)keyType, (Object)TypeNames.ANY)) {
                    keyType = (TypeName)TypeNames.BYTE_ARRAY;
                } else if (!(keyType instanceof ParameterizedTypeName) && !(keyType instanceof ClassName)) {
                    message = "Kafka listener method has invalid key type " + keyType;
                    throw new ProcessingErrorException(message, (KSAnnotated)function);
                }
                if (!(valueType instanceof ParameterizedTypeName) && !(valueType instanceof ClassName)) {
                    message = "Kafka listener method has invalid value type " + valueType;
                    throw new ProcessingErrorException(message, (KSAnnotated)function);
                }
                Iterable $this$any$iv = parameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv22 : $this$any$iv) {
                        ConsumerParameter it = (ConsumerParameter)element$iv22;
                        boolean bl4 = false;
                        if (!(it instanceof ConsumerParameter.KeyDeserializationException || it instanceof ConsumerParameter.Exception)) continue;
                        bl2 = true;
                        break block33;
                    }
                    bl2 = false;
                }
            }
            catchesKeyException = bl2;
            Iterable $this$any$iv = parameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv4 : $this$any$iv) {
                    ConsumerParameter it = (ConsumerParameter)element$iv4;
                    boolean bl5 = false;
                    if (!(it instanceof ConsumerParameter.ValueDeserializationException || it instanceof ConsumerParameter.Exception)) continue;
                    bl = true;
                    break block34;
                }
                bl = false;
            }
        }
        boolean catchesValueException = bl;
        KotlinPoetUtils $i$f$any = new KotlinPoetUtils[]{keyType, valueType};
        ParameterizedTypeName handlerType = ParameterizedTypeName.Companion.get(KafkaClassNames.INSTANCE.getRecordHandler(), (TypeName[])$i$f$any);
        FunSpec.Builder.returns$default((FunSpec.Builder)b, (TypeName)((TypeName)handlerType), null, (int)2, null);
        $i$f$any = KotlinPoetUtils.INSTANCE;
        element$iv22 = b;
        element$iv4 = "return %T { consumer, tctx, record ->";
        Object[] it = new Object[]{handlerType};
        Object[] args$iv = it;
        boolean $i$f$controlFlow = false;
        $this$controlFlow$iv.beginControlFlow((String)controlFlow$iv, Arrays.copyOf(args$iv, args$iv.length));
        void $this$generateRecord_u24lambda_u246 = $this$controlFlow$iv;
        boolean bl6 = false;
        if (catchesKeyException || catchesValueException) {
            Object[] objectArray;
            void controlFlow$iv2;
            void $this$controlFlow$iv2;
            if (catchesKeyException) {
                object = new Object[]{KafkaClassNames.INSTANCE.getRecordKeyDeserializationException()};
                $this$generateRecord_u24lambda_u246.addStatement("var keyException: %T? = null", (Object[])object);
            }
            if (catchesValueException) {
                object = new Object[]{KafkaClassNames.INSTANCE.getRecordValueDeserializationException()};
                $this$generateRecord_u24lambda_u246.addStatement("var valueException: %T? = null", (Object[])object);
            }
            object = KotlinPoetUtils.INSTANCE;
            void var19_28 = $this$generateRecord_u24lambda_u246;
            String string = "try";
            Object[] args$iv2 = new Object[]{};
            boolean $i$f$controlFlow2 = false;
            $this$controlFlow$iv2.beginControlFlow((String)controlFlow$iv2, Arrays.copyOf(args$iv2, args$iv2.length));
            void $this$generateRecord_u24lambda_u246_u24lambda_u245 = $this$controlFlow$iv2;
            boolean bl7 = false;
            if (catchesKeyException) {
                $this$generateRecord_u24lambda_u246_u24lambda_u245.addStatement("record.key()", new Object[0]);
            }
            if (catchesValueException) {
                $this$generateRecord_u24lambda_u246_u24lambda_u245.addStatement("record.value()", new Object[0]);
            }
            if (catchesKeyException) {
                objectArray = new Object[]{KafkaClassNames.INSTANCE.getRecordKeyDeserializationException()};
                $this$generateRecord_u24lambda_u246_u24lambda_u245.nextControlFlow("catch (e: %T)", objectArray);
                $this$generateRecord_u24lambda_u246_u24lambda_u245.addStatement("keyException = e", new Object[0]);
            }
            if (catchesValueException) {
                objectArray = new Object[]{KafkaClassNames.INSTANCE.getRecordValueDeserializationException()};
                $this$generateRecord_u24lambda_u246_u24lambda_u245.nextControlFlow("catch (e: %T)", objectArray);
                $this$generateRecord_u24lambda_u246_u24lambda_u245.addStatement("valueException = e", new Object[0]);
            }
            $this$controlFlow$iv2.endControlFlow();
        }
        if (function.getModifiers().contains(Modifier.SUSPEND)) {
            object = new Object[]{this.dispatchers, this.context, this.context};
            b.beginControlFlow("kotlinx.coroutines.runBlocking(%T.Unconfined + %T.Kotlin.asCoroutineContext(%T.current()))", (Object[])object);
        }
        object = new Object[]{function.getSimpleName().asString()};
        $this$generateRecord_u24lambda_u246.addCode("controller.%N(", (Object[])object);
        object = parameters.iterator();
        int n = 0;
        while (object.hasNext()) {
            String string;
            ConsumerParameter consumerParameter;
            int i = n++;
            ConsumerParameter it2 = (ConsumerParameter)object.next();
            if (i > 0) {
                $this$generateRecord_u24lambda_u246.addCode(", ", new Object[0]);
            }
            if ((consumerParameter = it2) instanceof ConsumerParameter.Consumer) {
                string = "consumer";
            } else if (consumerParameter instanceof ConsumerParameter.Record) {
                string = "record";
            } else if (consumerParameter instanceof ConsumerParameter.KeyDeserializationException) {
                string = "keyException";
            } else if (consumerParameter instanceof ConsumerParameter.ValueDeserializationException) {
                string = "valueException";
            } else if (consumerParameter instanceof ConsumerParameter.Exception) {
                string = "keyException ?: valueException";
            } else {
                throw new ProcessingErrorException("Record listener can't have parameter of type " + it2.getParameter().getType() + ", only consumer, record, RecordKeyDeserializationException, RecordValueDeserializationException and Exception are allowed", (KSAnnotated)it2.getParameter());
            }
            $this$generateRecord_u24lambda_u246.addCode(string, new Object[0]);
        }
        $this$generateRecord_u24lambda_u246.addCode(")\n", new Object[0]);
        if (function.getModifiers().contains(Modifier.SUSPEND)) {
            b.endControlFlow();
        }
        $this$controlFlow$iv.endControlFlow();
        Set keyTag = TagUtils.INSTANCE.parseTags(recordParameter.getKey());
        Set valueTag = TagUtils.INSTANCE.parseTags(recordParameter.getValue());
        return new HandlerFunction(b.build(), keyType, keyTag, valueType, valueTag);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HandlerFunction generateRecords(@NotNull FunSpec.Builder b, @NotNull KSFunctionDeclaration function, @NotNull List<? extends ConsumerParameter> parameters) {
        Object object;
        void controlFlow$iv;
        void $this$controlFlow$iv;
        Object it;
        Object element$iv2;
        block15: {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Iterable $this$first$iv = parameters;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                it = (ConsumerParameter)element$iv2;
                boolean bl = false;
                if (!(it instanceof ConsumerParameter.Records)) continue;
                break block15;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type ru.tinkoff.kora.kafka.symbol.processor.consumer.ConsumerParameter.Records");
        ConsumerParameter.Records recordsParameter = (ConsumerParameter.Records)t;
        TypeName keyTypeName = TypeName.copy$default((TypeName)KsTypesKt.toTypeName$default((KSType)recordsParameter.getKey(), null, (int)1, null), (boolean)false, null, (int)2, null);
        TypeName valueTypeName = TypeName.copy$default((TypeName)KsTypesKt.toTypeName$default((KSType)recordsParameter.getValue(), null, (int)1, null), (boolean)false, null, (int)2, null);
        if (Intrinsics.areEqual((Object)keyTypeName, (Object)TypeNames.STAR) || Intrinsics.areEqual((Object)keyTypeName, (Object)TypeNames.ANY)) {
            keyTypeName = (TypeName)TypeNames.BYTE_ARRAY;
        } else if (!(keyTypeName instanceof ParameterizedTypeName) && !(keyTypeName instanceof ClassName)) {
            String message = "Kafka listener method has invalid key type " + keyTypeName;
            throw new ProcessingErrorException(message, (KSAnnotated)function);
        }
        if (!(valueTypeName instanceof ParameterizedTypeName) && !(valueTypeName instanceof ClassName)) {
            String message = "Kafka listener method has invalid value type " + valueTypeName;
            throw new ProcessingErrorException(message, (KSAnnotated)function);
        }
        KotlinPoetUtils kotlinPoetUtils = new KotlinPoetUtils[]{keyTypeName, valueTypeName};
        ParameterizedTypeName handlerType = ParameterizedTypeName.Companion.get(KafkaClassNames.INSTANCE.getRecordsHandler(), (TypeName[])kotlinPoetUtils);
        FunSpec.Builder.returns$default((FunSpec.Builder)b, (TypeName)((TypeName)handlerType), null, (int)2, null);
        kotlinPoetUtils = KotlinPoetUtils.INSTANCE;
        element$iv2 = b;
        it = "return %T { consumer, tctx, records ->";
        Object[] bl = new Object[]{handlerType};
        Object[] args$iv = bl;
        boolean $i$f$controlFlow = false;
        $this$controlFlow$iv.beginControlFlow((String)controlFlow$iv, Arrays.copyOf(args$iv, args$iv.length));
        void $this$generateRecords_u24lambda_u248 = $this$controlFlow$iv;
        boolean bl2 = false;
        if (function.getModifiers().contains(Modifier.SUSPEND)) {
            object = new Object[]{this.dispatchers, this.context, this.context};
            b.beginControlFlow("kotlinx.coroutines.runBlocking(%T.Unconfined + %T.Kotlin.asCoroutineContext(%T.current()))", (Object[])object);
        }
        object = new Object[]{function.getSimpleName().asString()};
        $this$generateRecords_u24lambda_u248.addCode("controller.%N(", (Object[])object);
        object = parameters.iterator();
        int n = 0;
        while (object.hasNext()) {
            String string;
            ConsumerParameter consumerParameter;
            int i = n++;
            ConsumerParameter it2 = (ConsumerParameter)object.next();
            if (i > 0) {
                $this$generateRecords_u24lambda_u248.addCode(", ", new Object[0]);
            }
            if ((consumerParameter = it2) instanceof ConsumerParameter.Consumer) {
                string = "consumer";
            } else if (consumerParameter instanceof ConsumerParameter.RecordsTelemetry) {
                string = "tctx";
            } else if (consumerParameter instanceof ConsumerParameter.Records) {
                string = "records";
            } else {
                throw new ProcessingErrorException("Records listener can't have parameter of type " + it2.getParameter().getType() + ", only consumer, records and records telemetry are allowed", (KSAnnotated)it2.getParameter());
            }
            $this$generateRecords_u24lambda_u248.addCode(string, new Object[0]);
        }
        $this$generateRecords_u24lambda_u248.addCode(")\n", new Object[0]);
        if (function.getModifiers().contains(Modifier.SUSPEND)) {
            b.endControlFlow();
        }
        $this$controlFlow$iv.endControlFlow();
        Set keyTag = TagUtils.INSTANCE.parseTags(recordsParameter.getKey());
        Set valueTag = TagUtils.INSTANCE.parseTags(recordsParameter.getValue());
        return new HandlerFunction(b.build(), keyTypeName, keyTag, valueTypeName, valueTag);
    }

    /*
     * WARNING - void declaration
     */
    private final HandlerFunction generateKeyValue(FunSpec.Builder b, KSFunctionDeclaration functionDeclaration, List<? extends ConsumerParameter> parameters) {
        void $this$generateKeyValue_u24lambda_u2411;
        Object[] objectArray;
        void controlFlow$iv;
        void $this$controlFlow$iv;
        Object element$iv32;
        boolean bl;
        boolean catchesKeyException;
        Object element$iv222;
        TypeName typeName;
        TypeName keyType;
        ConsumerParameter headerParameter;
        ConsumerParameter.Unknown valueParameter;
        ConsumerParameter.Unknown keyParameter;
        block38: {
            boolean bl2;
            block37: {
                keyParameter = null;
                valueParameter = null;
                headerParameter = null;
                for (ConsumerParameter consumerParameter : parameters) {
                    if (!(consumerParameter instanceof ConsumerParameter.Unknown)) continue;
                    if (Intrinsics.areEqual((Object)KsTypesKt.toClassName((KSType)consumerParameter.getParameter().getType().resolve()).getCanonicalName(), (Object)KafkaClassNames.INSTANCE.getHeaders().getCanonicalName())) {
                        headerParameter = consumerParameter;
                        continue;
                    }
                    if (valueParameter == null) {
                        valueParameter = (ConsumerParameter.Unknown)consumerParameter;
                        continue;
                    }
                    if (keyParameter == null) {
                        keyParameter = valueParameter;
                        valueParameter = (ConsumerParameter.Unknown)consumerParameter;
                        continue;
                    }
                    KSName kSName = consumerParameter.getParameter().getName();
                    KSName kSName2 = keyParameter.getParameter().getName();
                    KSName kSName3 = valueParameter.getParameter().getName();
                    String message = "Kafka listener method has unknown type parameter '" + (kSName != null ? kSName.asString() : null) + "'. Previous unknown type parameters are: '" + (kSName2 != null ? kSName2.asString() : null) + "'(detected as key), '" + (kSName3 != null ? kSName3.asString() : null) + "'(detected as value)";
                    throw new ProcessingErrorException(message, (KSAnnotated)consumerParameter.getParameter());
                }
                if (valueParameter == null) {
                    String message = "Kafka listener method should have one of ConsumerRecord, ConsumerRecords or non service type parameters";
                    throw new ProcessingErrorException(message, (KSAnnotated)functionDeclaration);
                }
                keyType = null;
                ConsumerParameter.Unknown unknown = keyParameter;
                TypeName typeName2 = unknown != null && (unknown = unknown.getParameter()) != null && (unknown = unknown.getType()) != null && (unknown = KsTypesKt.toTypeName$default((KSTypeReference)unknown, null, (int)1, null)) != null ? TypeName.copy$default((TypeName)unknown, (boolean)false, null, (int)2, null) : (keyType = null);
                if (keyType != null && !(keyType instanceof ClassName) && !(keyType instanceof ParameterizedTypeName)) {
                    String string = "Kafka listener method has invalid key type " + keyType;
                    throw new ProcessingErrorException(string, (KSAnnotated)functionDeclaration);
                }
                typeName = TypeName.copy$default((TypeName)KsTypesKt.toTypeName$default((KSTypeReference)valueParameter.getParameter().getType(), null, (int)1, null), (boolean)false, null, (int)2, null);
                if (!(typeName instanceof ClassName) && !(typeName instanceof ParameterizedTypeName)) {
                    String message = "Kafka listener method has invalid value type " + typeName;
                    throw new ProcessingErrorException(message, (KSAnnotated)functionDeclaration);
                }
                if (keyType == null) {
                    keyType = TypeNames.BYTE_ARRAY;
                }
                Iterable $this$any$iv = parameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv222 : $this$any$iv) {
                        ConsumerParameter it = (ConsumerParameter)element$iv222;
                        boolean bl3 = false;
                        if (!(it instanceof ConsumerParameter.KeyDeserializationException || it instanceof ConsumerParameter.Exception)) continue;
                        bl2 = true;
                        break block37;
                    }
                    bl2 = false;
                }
            }
            catchesKeyException = bl2;
            Iterable $this$any$iv = parameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv32 : $this$any$iv) {
                    ConsumerParameter it = (ConsumerParameter)element$iv32;
                    boolean bl4 = false;
                    if (!(it instanceof ConsumerParameter.ValueDeserializationException || it instanceof ConsumerParameter.Exception)) continue;
                    bl = true;
                    break block38;
                }
                bl = false;
            }
        }
        boolean catchesValueException = bl;
        KotlinPoetUtils $i$f$any = new KotlinPoetUtils[]{keyType, typeName};
        ParameterizedTypeName handlerType = ParameterizedTypeName.Companion.get(KafkaClassNames.INSTANCE.getRecordHandler(), (TypeName[])$i$f$any);
        FunSpec.Builder.returns$default((FunSpec.Builder)b, (TypeName)((TypeName)handlerType), null, (int)2, null);
        $i$f$any = KotlinPoetUtils.INSTANCE;
        element$iv222 = CodeBlock.Companion.builder();
        element$iv32 = "return %T { consumer, tctx, record ->";
        Object[] it = new Object[]{handlerType};
        Object[] args$iv = it;
        boolean $i$f$controlFlow = false;
        $this$controlFlow$iv.beginControlFlow((String)controlFlow$iv, Arrays.copyOf(args$iv, args$iv.length));
        void var17_27 = $this$controlFlow$iv;
        FunSpec.Builder builder = b;
        boolean bl5 = false;
        if (catchesKeyException) {
            objectArray = new Object[]{KafkaClassNames.INSTANCE.getRecordKeyDeserializationException()};
            $this$generateKeyValue_u24lambda_u2411.addStatement("var keyException: %T? = null", objectArray);
        }
        if (catchesValueException) {
            objectArray = new Object[]{KafkaClassNames.INSTANCE.getRecordValueDeserializationException()};
            $this$generateKeyValue_u24lambda_u2411.addStatement("var valueException: %T? = null", objectArray);
        }
        if (keyParameter != null) {
            objectArray = new Object[]{keyType};
            $this$generateKeyValue_u24lambda_u2411.addStatement("var key: %T? = null", objectArray);
        }
        objectArray = new Object[]{typeName};
        $this$generateKeyValue_u24lambda_u2411.addStatement("var value: %T? = null", objectArray);
        if (catchesKeyException || catchesValueException) {
            $this$generateKeyValue_u24lambda_u2411.beginControlFlow("try", new Object[0]);
        }
        if (keyParameter != null) {
            $this$generateKeyValue_u24lambda_u2411.addStatement("key = record.key()", new Object[0]);
        } else if (catchesKeyException) {
            $this$generateKeyValue_u24lambda_u2411.addStatement("record.key()", new Object[0]);
        }
        $this$generateKeyValue_u24lambda_u2411.addStatement("value = record.value()", new Object[0]);
        if (headerParameter != null) {
            $this$generateKeyValue_u24lambda_u2411.addStatement("val headers = record.headers()", new Object[0]);
        }
        if (catchesKeyException) {
            objectArray = new Object[]{KafkaClassNames.INSTANCE.getRecordKeyDeserializationException()};
            $this$generateKeyValue_u24lambda_u2411.nextControlFlow("catch (e: %T)", objectArray);
            $this$generateKeyValue_u24lambda_u2411.addStatement("keyException = e", new Object[0]);
        }
        if (catchesValueException) {
            objectArray = new Object[]{KafkaClassNames.INSTANCE.getRecordValueDeserializationException()};
            $this$generateKeyValue_u24lambda_u2411.nextControlFlow("catch (e: %T)", objectArray);
            $this$generateKeyValue_u24lambda_u2411.addStatement("valueException = e", new Object[0]);
        }
        if (catchesKeyException || catchesValueException) {
            $this$generateKeyValue_u24lambda_u2411.endControlFlow();
        }
        if (functionDeclaration.getModifiers().contains(Modifier.SUSPEND)) {
            objectArray = new Object[]{this.dispatchers, this.context, this.context};
            $this$generateKeyValue_u24lambda_u2411.beginControlFlow("kotlinx.coroutines.runBlocking(%T.Unconfined + %T.Kotlin.asCoroutineContext(%T.current()))", objectArray);
        }
        objectArray = new Object[]{functionDeclaration.getSimpleName().asString()};
        $this$generateKeyValue_u24lambda_u2411.add("controller.%N(", objectArray);
        boolean keySeen = false;
        Iterator<? extends ConsumerParameter> iterator = parameters.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConsumerParameter consumerParameter;
            int i = n++;
            ConsumerParameter parameter = iterator.next();
            if (i > 0) {
                $this$generateKeyValue_u24lambda_u2411.add(", ", new Object[0]);
            }
            if ((consumerParameter = parameter) instanceof ConsumerParameter.Consumer) {
                $this$generateKeyValue_u24lambda_u2411.add("consumer", new Object[0]);
                continue;
            }
            if (consumerParameter instanceof ConsumerParameter.Exception) {
                $this$generateKeyValue_u24lambda_u2411.add("keyException ?: valueException", new Object[0]);
                continue;
            }
            if (consumerParameter instanceof ConsumerParameter.KeyDeserializationException) {
                $this$generateKeyValue_u24lambda_u2411.add("keyException", new Object[0]);
                continue;
            }
            if (consumerParameter instanceof ConsumerParameter.ValueDeserializationException) {
                $this$generateKeyValue_u24lambda_u2411.add("valueException", new Object[0]);
                continue;
            }
            if (consumerParameter instanceof ConsumerParameter.Unknown) {
                if (Intrinsics.areEqual((Object)parameter, (Object)headerParameter)) {
                    $this$generateKeyValue_u24lambda_u2411.add("headers", new Object[0]);
                    continue;
                }
                if (keyParameter == null || keySeen) {
                    $this$generateKeyValue_u24lambda_u2411.add("value", new Object[0]);
                    continue;
                }
                keySeen = true;
                $this$generateKeyValue_u24lambda_u2411.add("key", new Object[0]);
                continue;
            }
            String msg = "Record listener can't have parameter of type " + parameter.getParameter().getType() + ", only consumer, record, record key, record value, exception and record telemetry are allowed";
            throw new ProcessingErrorException(msg, (KSAnnotated)parameter.getParameter());
        }
        $this$generateKeyValue_u24lambda_u2411.add(")\n", new Object[0]);
        if (functionDeclaration.getModifiers().contains(Modifier.SUSPEND)) {
            $this$generateKeyValue_u24lambda_u2411.endControlFlow();
        }
        builder.addCode($this$controlFlow$iv.endControlFlow().build());
        Object object = keyParameter;
        if (object == null || (object = ((ConsumerParameter.Unknown)object).getParameter()) == null || (object = TagUtils.INSTANCE.parseTags((KSAnnotated)object)) == null) {
            object = SetsKt.emptySet();
        }
        Object keyTag = object;
        Set valueTag = TagUtils.INSTANCE.parseTags((KSAnnotated)valueParameter.getParameter());
        return new HandlerFunction(b.build(), keyType, (Set<String>)keyTag, typeName, valueTag);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003JG\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006 "}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaHandlerGenerator$HandlerFunction;", "", "funSpec", "Lcom/squareup/kotlinpoet/FunSpec;", "keyType", "Lcom/squareup/kotlinpoet/TypeName;", "keyTag", "", "", "valueType", "valueTag", "(Lcom/squareup/kotlinpoet/FunSpec;Lcom/squareup/kotlinpoet/TypeName;Ljava/util/Set;Lcom/squareup/kotlinpoet/TypeName;Ljava/util/Set;)V", "getFunSpec", "()Lcom/squareup/kotlinpoet/FunSpec;", "getKeyTag", "()Ljava/util/Set;", "getKeyType", "()Lcom/squareup/kotlinpoet/TypeName;", "getValueTag", "getValueType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka-symbol-processor"})
    public static final class HandlerFunction {
        @NotNull
        private final FunSpec funSpec;
        @NotNull
        private final TypeName keyType;
        @NotNull
        private final Set<String> keyTag;
        @NotNull
        private final TypeName valueType;
        @NotNull
        private final Set<String> valueTag;

        public HandlerFunction(@NotNull FunSpec funSpec, @NotNull TypeName keyType, @NotNull Set<String> keyTag, @NotNull TypeName valueType, @NotNull Set<String> valueTag) {
            Intrinsics.checkNotNullParameter((Object)funSpec, (String)"funSpec");
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            Intrinsics.checkNotNullParameter(keyTag, (String)"keyTag");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter(valueTag, (String)"valueTag");
            this.funSpec = funSpec;
            this.keyType = keyType;
            this.keyTag = keyTag;
            this.valueType = valueType;
            this.valueTag = valueTag;
        }

        @NotNull
        public final FunSpec getFunSpec() {
            return this.funSpec;
        }

        @NotNull
        public final TypeName getKeyType() {
            return this.keyType;
        }

        @NotNull
        public final Set<String> getKeyTag() {
            return this.keyTag;
        }

        @NotNull
        public final TypeName getValueType() {
            return this.valueType;
        }

        @NotNull
        public final Set<String> getValueTag() {
            return this.valueTag;
        }

        @NotNull
        public final FunSpec component1() {
            return this.funSpec;
        }

        @NotNull
        public final TypeName component2() {
            return this.keyType;
        }

        @NotNull
        public final Set<String> component3() {
            return this.keyTag;
        }

        @NotNull
        public final TypeName component4() {
            return this.valueType;
        }

        @NotNull
        public final Set<String> component5() {
            return this.valueTag;
        }

        @NotNull
        public final HandlerFunction copy(@NotNull FunSpec funSpec, @NotNull TypeName keyType, @NotNull Set<String> keyTag, @NotNull TypeName valueType, @NotNull Set<String> valueTag) {
            Intrinsics.checkNotNullParameter((Object)funSpec, (String)"funSpec");
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            Intrinsics.checkNotNullParameter(keyTag, (String)"keyTag");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            Intrinsics.checkNotNullParameter(valueTag, (String)"valueTag");
            return new HandlerFunction(funSpec, keyType, keyTag, valueType, valueTag);
        }

        public static /* synthetic */ HandlerFunction copy$default(HandlerFunction handlerFunction, FunSpec funSpec, TypeName typeName, Set set, TypeName typeName2, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                funSpec = handlerFunction.funSpec;
            }
            if ((n & 2) != 0) {
                typeName = handlerFunction.keyType;
            }
            if ((n & 4) != 0) {
                set = handlerFunction.keyTag;
            }
            if ((n & 8) != 0) {
                typeName2 = handlerFunction.valueType;
            }
            if ((n & 0x10) != 0) {
                set2 = handlerFunction.valueTag;
            }
            return handlerFunction.copy(funSpec, typeName, set, typeName2, set2);
        }

        @NotNull
        public String toString() {
            return "HandlerFunction(funSpec=" + this.funSpec + ", keyType=" + this.keyType + ", keyTag=" + this.keyTag + ", valueType=" + this.valueType + ", valueTag=" + this.valueTag + ")";
        }

        public int hashCode() {
            int result = this.funSpec.hashCode();
            result = result * 31 + this.keyType.hashCode();
            result = result * 31 + ((Object)this.keyTag).hashCode();
            result = result * 31 + this.valueType.hashCode();
            result = result * 31 + ((Object)this.valueTag).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HandlerFunction)) {
                return false;
            }
            HandlerFunction handlerFunction = (HandlerFunction)other;
            if (!Intrinsics.areEqual((Object)this.funSpec, (Object)handlerFunction.funSpec)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.keyType, (Object)handlerFunction.keyType)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.keyTag, handlerFunction.keyTag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.valueType, (Object)handlerFunction.valueType)) {
                return false;
            }
            return Intrinsics.areEqual(this.valueTag, handlerFunction.valueTag);
        }
    }
}

