/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.symbol.processor.consumer;

import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaUtils;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.ConsumerParameter;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaHandlerGenerator;
import ru.tinkoff.kora.ksp.common.CommonClassNames;
import ru.tinkoff.kora.ksp.common.KotlinPoetUtils;
import ru.tinkoff.kora.ksp.common.TagUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaContainerGenerator;", "", "()V", "generate", "Lcom/squareup/kotlinpoet/FunSpec;", "functionDeclaration", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "handler", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaHandlerGenerator$HandlerFunction;", "parameters", "", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/ConsumerParameter;", "kafka-symbol-processor"})
public final class KafkaContainerGenerator {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FunSpec generate(@NotNull KSFunctionDeclaration functionDeclaration, @NotNull KafkaHandlerGenerator.HandlerFunction handler, @NotNull List<? extends ConsumerParameter> parameters) {
        void controlFlow$iv;
        void $this$controlFlow$iv;
        Object v1;
        ConsumerParameter it;
        Object element$iv2;
        ParameterizedTypeName handlerType;
        TypeName valueType;
        TypeName keyType;
        block3: {
            Intrinsics.checkNotNullParameter((Object)functionDeclaration, (String)"functionDeclaration");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            keyType = handler.getKeyType();
            valueType = handler.getValueType();
            TypeName typeName = handler.getFunSpec().getReturnType();
            Intrinsics.checkNotNull((Object)typeName);
            handlerType = (ParameterizedTypeName)typeName;
            Iterable $this$firstOrNull$iv = parameters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (ConsumerParameter)element$iv2;
                boolean bl = false;
                if (!(it instanceof ConsumerParameter.Consumer)) continue;
                v1 = element$iv2;
                break block3;
            }
            v1 = null;
        }
        ConsumerParameter.Consumer consumerParameter = v1;
        String tagName = KafkaUtils.INSTANCE.tagTypeName(functionDeclaration);
        AnnotationSpec tagAnnotation = TagUtils.INSTANCE.toTagAnnotation((Collection)CollectionsKt.listOf((Object)tagName));
        element$iv2 = new TypeName[]{(TypeName)handlerType};
        FunSpec.Builder builder = FunSpec.Companion.builder(KafkaUtils.INSTANCE.containerFunName(functionDeclaration)).addParameter(ParameterSpec.Companion.builder("config", (TypeName)KafkaClassNames.INSTANCE.getKafkaConsumerConfig(), new KModifier[0]).addAnnotation(tagAnnotation).build()).addParameter(ParameterSpec.Companion.builder("handler", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getValueOf(), element$iv2), new KModifier[0]).addAnnotation(tagAnnotation).build());
        element$iv2 = new TypeName[]{keyType};
        FunSpec.Builder builder2 = builder.addParameter(TagUtils.INSTANCE.tag(ParameterSpec.Companion.builder("keyDeserializer", (TypeName)ParameterizedTypeName.Companion.get(KafkaClassNames.INSTANCE.getDeserializer(), element$iv2), new KModifier[0]), handler.getKeyTag()).build());
        element$iv2 = new TypeName[]{valueType};
        FunSpec.Builder builder3 = builder2.addParameter(TagUtils.INSTANCE.tag(ParameterSpec.Companion.builder("valueDeserializer", (TypeName)ParameterizedTypeName.Companion.get(KafkaClassNames.INSTANCE.getDeserializer(), element$iv2), new KModifier[0]), handler.getValueTag()).build());
        element$iv2 = new TypeName[]{keyType, valueType};
        FunSpec.Builder funBuilder = FunSpec.Builder.returns$default((FunSpec.Builder)builder3.addParameter("telemetry", (TypeName)ParameterizedTypeName.Companion.get(KafkaClassNames.INSTANCE.getKafkaConsumerTelemetry(), element$iv2), new KModifier[0]).addAnnotation(CommonClassNames.INSTANCE.getRoot()).addAnnotation(tagAnnotation), (TypeName)((TypeName)CommonClassNames.INSTANCE.getLifecycle()), null, (int)2, null);
        if (Intrinsics.areEqual((Object)handlerType.getRawType(), (Object)KafkaClassNames.INSTANCE.getRecordHandler())) {
            element$iv2 = new Object[]{KafkaClassNames.INSTANCE.getHandlerWrapper(), consumerParameter == null};
            funBuilder.addStatement("val wrappedHandler = %T.wrapHandlerRecord(telemetry, %L, handler)", element$iv2);
        } else {
            element$iv2 = new Object[]{KafkaClassNames.INSTANCE.getHandlerWrapper(), consumerParameter == null};
            funBuilder.addStatement("val wrappedHandler = %T.wrapHandlerRecords(telemetry, %L, handler)", element$iv2);
        }
        element$iv2 = KotlinPoetUtils.INSTANCE;
        it = funBuilder;
        String bl = "if (config.driverProperties().getProperty(%T.GROUP_ID_CONFIG) == null)";
        Object[] objectArray = new Object[]{KafkaClassNames.INSTANCE.getCommonClientConfigs()};
        Object[] args$iv = objectArray;
        boolean $i$f$controlFlow = false;
        $this$controlFlow$iv.beginControlFlow((String)controlFlow$iv, Arrays.copyOf(args$iv, args$iv.length));
        void $this$generate_u24lambda_u241 = $this$controlFlow$iv;
        boolean bl2 = false;
        $this$generate_u24lambda_u241.addStatement("val topics = config.topics()", new Object[0]);
        $this$generate_u24lambda_u241.addStatement("require(topics != null)", new Object[0]);
        $this$generate_u24lambda_u241.addStatement("require(topics.size == 1)", new Object[0]);
        Object[] objectArray2 = new Object[]{KafkaClassNames.INSTANCE.getKafkaAssignConsumerContainer()};
        $this$generate_u24lambda_u241.addStatement("return %T(config, topics[0], keyDeserializer, valueDeserializer, telemetry, wrappedHandler)", objectArray2);
        $this$generate_u24lambda_u241.nextControlFlow("else", new Object[0]);
        objectArray2 = new Object[]{KafkaClassNames.INSTANCE.getKafkaSubscribeConsumerContainer()};
        $this$generate_u24lambda_u241.addStatement("return %T(config, keyDeserializer, valueDeserializer, wrappedHandler)", objectArray2);
        $this$controlFlow$iv.endControlFlow();
        return funBuilder.build();
    }
}

