/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.utils;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.utils.KafkaUtils;

public final class KafkaPublisherUtils {
    private KafkaPublisherUtils() {
    }

    public static PublisherData parsePublisherType(ExecutableElement method) {
        VariableElement key = null;
        VariableElement value = null;
        VariableElement headers = null;
        VariableElement record = null;
        VariableElement producerCallback = null;
        for (VariableElement variableElement : method.getParameters()) {
            if (KafkaUtils.isProducerCallback(variableElement.asType())) {
                if (producerCallback != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: only one Callback parameter is allowed", (Element)variableElement);
                }
                producerCallback = variableElement;
                continue;
            }
            if (KafkaUtils.isHeaders(variableElement.asType())) {
                if (record != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: Headers parameter can't be used with record parameter", (Element)variableElement);
                }
                if (headers != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: only one Headers parameter is allowed", (Element)variableElement);
                }
                headers = variableElement;
                continue;
            }
            if (KafkaUtils.isProducerRecord(variableElement.asType())) {
                if (value != null || headers != null) {
                    throw new ProcessingErrorException("Invalid publisher signature: Record parameter can't be combined with other parameters", (Element)variableElement);
                }
                if (AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)KafkaClassNames.kafkaTopicAnnotation)) {
                    throw new ProcessingErrorException("Invalid publisher signature: Record parameter can't be combined @Topic annotation", (Element)variableElement);
                }
                record = variableElement;
                continue;
            }
            if (record != null) {
                throw new ProcessingErrorException("Invalid publisher signature: Record parameter can't be combined with key or value parameters", (Element)variableElement);
            }
            if (key != null) {
                throw new ProcessingErrorException("Invalid publisher signature: only ProducerRecord or Headers, key and value parameters are allowed", (Element)variableElement);
            }
            if (value != null) {
                key = value;
            }
            value = variableElement;
        }
        if (record != null) {
            DeclaredType recordType = (DeclaredType)record.asType();
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)TypeName.get((TypeMirror)recordType).withoutAnnotations();
            TypeName keyType = (TypeName)parameterizedTypeName.typeArguments.get(0);
            TypeName valueType = (TypeName)parameterizedTypeName.typeArguments.get(1);
            Set keyTag = TagUtils.parseTagValue((AnnotatedConstruct)recordType.getTypeArguments().get(0));
            Set valueTag = TagUtils.parseTagValue((AnnotatedConstruct)recordType.getTypeArguments().get(1));
            return new PublisherData(keyType, keyTag, valueType, valueTag, key, value, headers, record, producerCallback);
        }
        if (!AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)KafkaClassNames.kafkaTopicAnnotation)) {
            throw new ProcessingErrorException("Invalid publisher signature: key/value/headers signature requires @Topic annotation", (Element)method);
        }
        assert (value != null);
        TypeName valueType = TypeName.get((TypeMirror)value.asType()).withoutAnnotations();
        Set set = TagUtils.parseTagValue((AnnotatedConstruct)value);
        if (key == null) {
            return new PublisherData(null, Set.of(), valueType, set, key, value, headers, record, producerCallback);
        }
        TypeName keyType = TypeName.get((TypeMirror)key.asType()).withoutAnnotations();
        Set keyTag = TagUtils.parseTagValue((AnnotatedConstruct)key);
        return new PublisherData(keyType, keyTag, valueType, set, key, value, headers, record, producerCallback);
    }

    public record PublisherData(@Nullable TypeName keyType, Set<String> keyTag, TypeName valueType, Set<String> valueTag, VariableElement keyVar, VariableElement valueVar, VariableElement headersVar, VariableElement recordVar, VariableElement callback) {
    }
}

