/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.producer;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.producer.KafkaPublisherGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.producer.KafkaPublisherTransactionalGenerator;

public class KafkaPublisherAnnotationProcessor
extends AbstractKoraProcessor {
    private TypeElement kafkaProducerAnnotationElement;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.kafkaProducerAnnotationElement = this.elements.getTypeElement(KafkaClassNames.kafkaPublisherAnnotation.canonicalName());
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(KafkaClassNames.kafkaPublisherAnnotation.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.kafkaProducerAnnotationElement == null) {
            return false;
        }
        Set<? extends Element> producers = roundEnv.getElementsAnnotatedWith(this.kafkaProducerAnnotationElement);
        KafkaPublisherTransactionalGenerator publisherTransactionalGenerator = new KafkaPublisherTransactionalGenerator(this.types, this.elements, this.processingEnv);
        KafkaPublisherGenerator publisherGenerator = new KafkaPublisherGenerator(this.types, this.elements, this.processingEnv);
        for (Element element : producers) {
            try {
                TypeElement typeElement;
                if (!(element instanceof TypeElement) || (typeElement = (TypeElement)element).getKind() != ElementKind.INTERFACE) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
                    continue;
                }
                AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)element, (ClassName)KafkaClassNames.kafkaPublisherAnnotation);
                List<? extends TypeMirror> supertypes = typeElement.getInterfaces();
                if (supertypes.isEmpty()) {
                    ArrayList<ExecutableElement> publishMethods = new ArrayList<ExecutableElement>();
                    for (Element element2 : typeElement.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.METHOD) continue;
                        publishMethods.add((ExecutableElement)element2);
                    }
                    publisherGenerator.generateConfig(typeElement, publishMethods);
                    publisherGenerator.generatePublisherModule(typeElement, publishMethods, annotation);
                    publisherGenerator.generatePublisherImplementation(typeElement, publishMethods, annotation);
                    continue;
                }
                if (supertypes.size() != 1) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
                    continue;
                }
                DeclaredType supertypeMirror = (DeclaredType)supertypes.get(0);
                TypeName typeName = TypeName.get((TypeMirror)supertypeMirror);
                if (!(typeName instanceof ParameterizedTypeName)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
                    continue;
                }
                ParameterizedTypeName supertypeName = (ParameterizedTypeName)typeName;
                if (supertypeName.rawType.equals((Object)KafkaClassNames.transactionalPublisher)) {
                    DeclaredType declaredType = (DeclaredType)supertypeMirror.getTypeArguments().get(0);
                    TypeElement publisherTypeElement = (TypeElement)declaredType.asElement();
                    AnnotationMirror publisherAnnotation = AnnotationUtils.findAnnotation((Element)publisherTypeElement, (ClassName)KafkaClassNames.kafkaPublisherAnnotation);
                    if (publisherAnnotation == null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "TransactionalPublisher can only have argument types that annotated with @KafkaPublisher too", element);
                        continue;
                    }
                    ClassName publisherType = ClassName.get((TypeElement)publisherTypeElement);
                    publisherTransactionalGenerator.generatePublisherTransactionalModule(typeElement, publisherTypeElement, annotation);
                    publisherTransactionalGenerator.generatePublisherTransactionalImpl(typeElement, publisherType, publisherTypeElement);
                    continue;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }
}

