/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.consumer;

import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerConfigGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerContainerGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerHandlerGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerModuleGenerator;

public class KafkaListenerAnnotationProcessor
extends AbstractKoraProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(KafkaClassNames.kafkaListener.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement kafkaListener = this.elements.getTypeElement(KafkaClassNames.kafkaListener.canonicalName());
        Set typeElements = roundEnv.getElementsAnnotatedWith(kafkaListener).stream().map(Element::getEnclosingElement).map(TypeElement.class::cast).collect(Collectors.toSet());
        for (TypeElement element : typeElements) {
            try {
                this.processController(element);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void processController(TypeElement controller) throws IOException {
        KafkaConsumerHandlerGenerator methodGenerator = new KafkaConsumerHandlerGenerator();
        KafkaConsumerConfigGenerator kafkaConfigGenerator = new KafkaConsumerConfigGenerator();
        KafkaConsumerContainerGenerator kafkaConsumerContainerGenerator = new KafkaConsumerContainerGenerator();
        KafkaConsumerModuleGenerator generator = new KafkaConsumerModuleGenerator(this.processingEnv, methodGenerator, kafkaConfigGenerator, kafkaConsumerContainerGenerator);
        JavaFile file = generator.generateModule(controller);
        file.writeTo(this.processingEnv.getFiler());
    }
}

