/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.consumer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.ConsumerParameter;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerConfigGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerContainerGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerHandlerGenerator;

public class KafkaConsumerModuleGenerator {
    private final Elements elements;
    private final KafkaConsumerHandlerGenerator kafkaConsumerHandlerGenerator;
    private final KafkaConsumerConfigGenerator configGenerator;
    private final KafkaConsumerContainerGenerator kafkaConsumerContainerGenerator;

    public KafkaConsumerModuleGenerator(ProcessingEnvironment processingEnv, KafkaConsumerHandlerGenerator kafkaConsumerHandlerGenerator, KafkaConsumerConfigGenerator configGenerator, KafkaConsumerContainerGenerator kafkaConsumerContainerGenerator) {
        this.elements = processingEnv.getElementUtils();
        this.kafkaConsumerHandlerGenerator = kafkaConsumerHandlerGenerator;
        this.configGenerator = configGenerator;
        this.kafkaConsumerContainerGenerator = kafkaConsumerContainerGenerator;
    }

    public final JavaFile generateModule(TypeElement typeElement) {
        TypeSpec.Builder classBuilder = TypeSpec.interfaceBuilder((String)(typeElement.getSimpleName().toString() + "Module")).addOriginatingElement((Element)typeElement).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{KafkaConsumerModuleGenerator.class.getCanonicalName()})).build()).addAnnotation(CommonClassNames.module);
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement method;
            AnnotationMirror annotation;
            if (element.getKind() != ElementKind.METHOD || (annotation = AnnotationUtils.findAnnotation((Element)(method = (ExecutableElement)element), (ClassName)KafkaClassNames.kafkaListener)) == null) continue;
            KafkaConsumerConfigGenerator.KafkaConfigData configTagData = this.configGenerator.generate(method, annotation);
            classBuilder.addMethod(configTagData.configMethod());
            classBuilder.addType(configTagData.tag());
            List<ConsumerParameter> parameters = ConsumerParameter.parseParameters(method);
            KafkaConsumerHandlerGenerator.HandlerMethod handler = this.kafkaConsumerHandlerGenerator.generate(method, parameters);
            classBuilder.addMethod(handler.method());
            MethodSpec container = this.kafkaConsumerContainerGenerator.generate(method, handler, parameters);
            classBuilder.addMethod(container);
        }
        PackageElement packageName = this.elements.getPackageOf(typeElement);
        return JavaFile.builder((String)packageName.getQualifiedName().toString(), (TypeSpec)classBuilder.build()).build();
    }
}

