/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.consumer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.utils.KafkaUtils;

public class KafkaConsumerConfigGenerator {
    public KafkaConfigData generate(ExecutableElement executableElement, AnnotationMirror listenerAnnotation) {
        String tagName = KafkaUtils.prepareConsumerTagName(executableElement);
        TypeSpec.Builder tagBuilder = TypeSpec.classBuilder((String)tagName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        Object configPath = AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)listenerAnnotation, (String)"value");
        CodeBlock.Builder tagsBlock = CodeBlock.builder().add("{", new Object[0]);
        tagsBlock.add("$L.class", new Object[]{tagName});
        tagsBlock.add("}", new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)KafkaUtils.prepareMethodName(executableElement, "Config")).returns((TypeName)KafkaClassNames.kafkaConsumerConfig).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{KafkaClassNames.kafkaConsumerConfig}), "extractor", new Modifier[0]).addStatement("var configValue = config.get($S)", new Object[]{configPath}).addStatement("return extractor.extract(configValue)", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", tagsBlock.build()).build());
        return new KafkaConfigData(tagBuilder.build(), methodBuilder.build());
    }

    public record KafkaConfigData(TypeSpec tag, MethodSpec configMethod) {
        public KafkaConfigData {
            Objects.requireNonNull(tag);
            Objects.requireNonNull(configMethod);
        }
    }
}

