/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.consumer;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.kafka.annotation.processor.utils.KafkaUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConsumerParameter {
    public VariableElement element();

    public static List<ConsumerParameter> parseParameters(ExecutableElement executableElement) {
        ArrayList<ConsumerParameter> result = new ArrayList<ConsumerParameter>(executableElement.getParameters().size());
        for (VariableElement variableElement : executableElement.getParameters()) {
            DeclaredType dt;
            TypeMirror type = variableElement.asType();
            if (KafkaUtils.isConsumerRecord(type)) {
                dt = (DeclaredType)type;
                result.add(new Record(variableElement, dt.getTypeArguments().get(0), dt.getTypeArguments().get(1)));
                continue;
            }
            if (KafkaUtils.isConsumerRecords(type)) {
                dt = (DeclaredType)type;
                result.add(new Records(variableElement, dt.getTypeArguments().get(0), dt.getTypeArguments().get(1)));
                continue;
            }
            if (KafkaUtils.isConsumer(type)) {
                dt = (DeclaredType)type;
                result.add(new Consumer(variableElement, dt.getTypeArguments().get(0), dt.getTypeArguments().get(1)));
                continue;
            }
            if (KafkaUtils.isRecordsTelemetry(type)) {
                dt = (DeclaredType)type;
                result.add(new RecordsTelemetry(variableElement, dt.getTypeArguments().get(0), dt.getTypeArguments().get(1)));
                continue;
            }
            if (KafkaUtils.isHeaders(type)) {
                result.add(new Headers(variableElement));
                continue;
            }
            if (KafkaUtils.isKeyDeserializationException(type)) {
                result.add(new KeyDeserializationException(variableElement));
                continue;
            }
            if (KafkaUtils.isValueDeserializationException(type)) {
                result.add(new ValueDeserializationException(variableElement));
                continue;
            }
            if (KafkaUtils.isAnyException(type)) {
                result.add(new Exception(variableElement));
                continue;
            }
            result.add(new Unknown(variableElement));
        }
        return result;
    }

    public record Record(VariableElement element, TypeMirror key, TypeMirror value) implements ConsumerParameter
    {
    }

    public record Records(VariableElement element, TypeMirror key, TypeMirror value) implements ConsumerParameter
    {
    }

    public record Consumer(VariableElement element, TypeMirror key, TypeMirror value) implements ConsumerParameter
    {
    }

    public record RecordsTelemetry(VariableElement element, TypeMirror key, TypeMirror value) implements ConsumerParameter
    {
    }

    public record Headers(VariableElement element) implements ConsumerParameter
    {
    }

    public record KeyDeserializationException(VariableElement element) implements ConsumerParameter
    {
    }

    public record ValueDeserializationException(VariableElement element) implements ConsumerParameter
    {
    }

    public record Exception(VariableElement element) implements ConsumerParameter
    {
    }

    public record Unknown(VariableElement element) implements ConsumerParameter
    {
    }
}

