/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.async.response;

import jakarta.annotation.Nullable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class QueuePublisher<T>
extends AtomicBoolean
implements Flow.Publisher<T> {
    private final BlockingQueue<Signal<T>> queue = new ArrayBlockingQueue<Signal<T>>(16);
    private volatile Flow.Subscriber<? super T> delegate;
    private static final AtomicLongFieldUpdater<QueuePublisher<?>> DEMAND = AtomicLongFieldUpdater.newUpdater(QueuePublisher.class, "demand");
    private volatile long demand = 0L;
    private static final AtomicIntegerFieldUpdater<QueuePublisher<?>> WIP = AtomicIntegerFieldUpdater.newUpdater(QueuePublisher.class, "wip");
    private volatile int wip = 0;

    public QueuePublisher() {
        super(false);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.delegate = subscriber;
        subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                if (DEMAND.getAndAdd(QueuePublisher.this, n) <= 0L && WIP.compareAndSet(QueuePublisher.this, 0, 1)) {
                    QueuePublisher.this.drainLoop();
                }
            }

            @Override
            public void cancel() {
                QueuePublisher.this.cancel();
            }
        });
    }

    private void drainLoop() {
        try {
            BlockingQueue<Signal<T>> queue = this.queue;
            while (this.demand > 0L) {
                if (this.get()) {
                    return;
                }
                Signal item = (Signal)queue.poll();
                if (item == null) {
                    return;
                }
                if (item.value != null) {
                    DEMAND.decrementAndGet(this);
                    this.delegate.onNext(item.value);
                    continue;
                }
                if (item.error != null) {
                    this.delegate.onError(item.error);
                    continue;
                }
                this.delegate.onComplete();
            }
        }
        finally {
            WIP.set(this, 0);
        }
    }

    public void next(T item) {
        if (this.get()) {
            return;
        }
        try {
            this.queue.put(new Signal<T>(item, null));
        }
        catch (InterruptedException e) {
            this.set(true);
            this.delegate.onError(e);
            return;
        }
        if (WIP.compareAndSet(this, 0, 1)) {
            this.drainLoop();
        }
    }

    public void error(Throwable throwable) {
        try {
            this.queue.put(new Signal<Object>(null, throwable));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void complete() {
        try {
            this.queue.put(new Signal<Object>(null, null));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (WIP.compareAndSet(this, 0, 1)) {
            this.drainLoop();
        }
    }

    public void cancel() {
        try {
            this.queue.put(new Signal<Object>(null, new CancellationException()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.set(true);
    }

    private static final class Signal<T> {
        @Nullable
        private final T value;
        @Nullable
        private final Throwable error;

        private Signal(T value, Throwable error) {
            assert (value == null || error == null);
            this.value = value;
            this.error = error;
        }
    }
}

