/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.async.response;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;

public final class AsyncHttpClientStreamingResponseBody
extends AtomicBoolean
implements HttpBodyInput {
    private static final String UNKNOWN_CONTENT_TYPE = "<UNKNOWN-CONTENT-TYPE\r\n>";
    private final HttpHeaders headers;
    private String contentType;
    private int contentLength = -2;
    private final Flow.Publisher<ByteBuffer> bodyStream;

    public AsyncHttpClientStreamingResponseBody(HttpHeaders headers, Flow.Publisher<ByteBuffer> bodyStream) {
        this.headers = headers;
        this.bodyStream = bodyStream;
    }

    public int contentLength() {
        int cl = this.contentLength;
        if (cl >= -1) {
            return cl;
        }
        String value = this.headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value != null) {
            this.contentLength = Integer.parseInt(value);
            return this.contentLength;
        }
        this.contentLength = -1;
        return -1;
    }

    @Nullable
    public String contentType() {
        String ct = this.contentType;
        if (ct == UNKNOWN_CONTENT_TYPE) {
            return null;
        }
        if (ct != null) {
            return ct;
        }
        String value = this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (value != null) {
            this.contentType = value;
            return this.contentType;
        }
        this.contentType = UNKNOWN_CONTENT_TYPE;
        return null;
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        if (this.compareAndSet(false, true)) {
            this.bodyStream.subscribe(subscriber);
        }
    }

    public void close() throws IOException {
        if (this.compareAndSet(false, true)) {
            this.bodyStream.subscribe(FlowUtils.drain());
        }
    }
}

