/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.async;

import io.netty.handler.codec.http.HttpHeaders;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.async.response.EmptyAsyncHttpClientResponse;
import ru.tinkoff.kora.http.client.async.response.QueuePublisher;
import ru.tinkoff.kora.http.client.async.response.SingleBufferAsyncHttpClientResponse;
import ru.tinkoff.kora.http.client.async.response.StreamingAsyncHttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;

class MonoSinkStreamAsyncHandler
implements AsyncHandler<Object> {
    private final CompletableFuture<HttpClientResponse> future;
    private final AtomicReference<RequestPhase> phase = new AtomicReference<RequestPhase>(RequestPhase.REQUESTED);
    private final Context context;
    private HttpResponseStatus responseStatus;
    private HttpHeaders headers;
    private QueuePublisher<ByteBuffer> publisher;

    public MonoSinkStreamAsyncHandler(Context context, CompletableFuture<HttpClientResponse> future) {
        this.future = future;
        this.context = context;
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
        this.headers = headers;
        return AsyncHandler.State.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
        if (this.phase.compareAndSet(RequestPhase.REQUESTED, RequestPhase.BODY_STREAM_RECEIVED)) {
            Context oldContext = Context.current();
            try {
                this.context.inject();
                if (bodyPart.length() <= 0) {
                    if (bodyPart.isLast()) {
                        this.future.complete(new EmptyAsyncHttpClientResponse(this.responseStatus, this.headers));
                    }
                    AsyncHandler.State state = AsyncHandler.State.CONTINUE;
                    return state;
                }
                ByteBuffer buf = ByteBuffer.allocate(bodyPart.length());
                buf.put(bodyPart.getBodyByteBuffer());
                buf.rewind();
                if (bodyPart.isLast()) {
                    this.future.complete(new SingleBufferAsyncHttpClientResponse(this.context, this.responseStatus, this.headers, buf));
                    AsyncHandler.State state = AsyncHandler.State.CONTINUE;
                    return state;
                }
                this.publisher = new QueuePublisher<ByteBuffer>();
                QueuePublisher<ByteBuffer> s = this.publisher;
                s.next(buf);
                this.future.complete(new StreamingAsyncHttpClientResponse(this.responseStatus, this.headers, s));
            }
            finally {
                oldContext.inject();
            }
        } else {
            if (bodyPart.length() > 0) {
                this.publisher.next(bodyPart.getBodyByteBuffer());
            }
            if (bodyPart.isLast()) {
                this.publisher.complete();
            }
        }
        return AsyncHandler.State.CONTINUE;
    }

    public void onThrowable(Throwable t) {
        if (this.phase.compareAndSet(RequestPhase.REQUESTED, RequestPhase.ERROR)) {
            Context oldContext = Context.current();
            try {
                this.context.inject();
                this.future.completeExceptionally(t);
            }
            finally {
                oldContext.inject();
            }
        } else {
            this.publisher.error(t);
        }
    }

    public Object onCompleted() {
        if (this.phase.compareAndSet(RequestPhase.REQUESTED, RequestPhase.BODY_STREAM_RECEIVED)) {
            Context oldContext = Context.current();
            try {
                this.context.inject();
                this.future.complete(new EmptyAsyncHttpClientResponse(this.responseStatus, this.headers));
            }
            finally {
                oldContext.inject();
            }
        }
        return null;
    }

    private static enum RequestPhase {
        REQUESTED,
        ERROR,
        BODY_STREAM_RECEIVED;

    }
}

