/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.async;

import io.netty.channel.EventLoopGroup;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyType;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.http.client.async.AsyncHttpClient;
import ru.tinkoff.kora.http.client.common.HttpClientConfig;
import ru.tinkoff.kora.http.client.common.HttpClientModule;
import ru.tinkoff.kora.netty.common.NettyCommonModule;

public interface AsyncHttpClientModule
extends NettyCommonModule,
HttpClientModule {
    default public AsyncHttpClientConfig nettyClientConfig(@Tag(value={NettyCommonModule.WorkerLoopGroup.class}) EventLoopGroup eventLoopGroup, HttpClientConfig config) {
        DefaultAsyncHttpClientConfig.Builder builder = Dsl.config().setEventLoopGroup(eventLoopGroup).setConnectTimeout((int)config.connectTimeout().toMillis()).setReadTimeout((int)config.readTimeout().toMillis());
        HttpClientConfig.HttpClientProxyConfig proxy = config.proxy();
        if (config.useEnvProxy()) {
            proxy = HttpClientConfig.HttpClientProxyConfig.fromEnv();
        }
        if (proxy != null) {
            ProxyServer.Builder proxyBuilder = new ProxyServer.Builder(proxy.host(), proxy.port()).setProxyType(ProxyType.HTTP);
            if (proxy.nonProxyHosts() != null) {
                proxyBuilder.setNonProxyHosts(proxy.nonProxyHosts());
            }
            if (proxy.user() != null && proxy.password() != null) {
                proxyBuilder.setRealm(Dsl.basicAuthRealm((String)proxy.user(), (String)proxy.password()));
            }
            builder.setProxyServer(proxyBuilder.build());
        }
        return builder.build();
    }

    default public org.asynchttpclient.AsyncHttpClient nettyAsyncHttpClient(AsyncHttpClientConfig config) {
        return Dsl.asyncHttpClient((AsyncHttpClientConfig)config);
    }

    default public AsyncHttpClient asyncHttpClient(org.asynchttpclient.AsyncHttpClient client) {
        return new AsyncHttpClient(client);
    }
}

