/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.client.async;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.uri.Uri;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.async.AsyncHttpClientRequestBodyGenerator;
import ru.tinkoff.kora.http.client.async.MonoSinkStreamAsyncHandler;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.HttpClientConnectionException;
import ru.tinkoff.kora.http.client.common.HttpClientException;
import ru.tinkoff.kora.http.client.common.HttpClientTimeoutException;
import ru.tinkoff.kora.http.client.common.HttpClientUnknownException;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;

public class AsyncHttpClient
implements HttpClient,
Lifecycle {
    private final org.asynchttpclient.AsyncHttpClient client;

    public AsyncHttpClient(org.asynchttpclient.AsyncHttpClient client) {
        this.client = client;
    }

    public CompletionStage<HttpClientResponse> execute(HttpClientRequest request) {
        Context ctx = Context.current();
        return this.processRequest(ctx, request).exceptionallyCompose(e -> {
            if (e instanceof CompletionException) {
                CompletionException ce = (CompletionException)e;
                e = ce.getCause();
            }
            if (e instanceof IOException) {
                IOException io = (IOException)e;
                return CompletableFuture.failedFuture((Throwable)new HttpClientConnectionException((Exception)io));
            }
            if (e instanceof TimeoutException) {
                TimeoutException timeout = (TimeoutException)e;
                return CompletableFuture.failedFuture((Throwable)new HttpClientTimeoutException(timeout));
            }
            if (e instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                return CompletableFuture.failedFuture((Throwable)new HttpClientConnectionException((Exception)illegalArgumentException));
            }
            if (e instanceof HttpClientException) {
                HttpClientException clientException = (HttpClientException)e;
                return CompletableFuture.failedFuture((Throwable)clientException);
            }
            return CompletableFuture.failedFuture((Throwable)new HttpClientUnknownException(e));
        });
    }

    private CompletionStage<HttpClientResponse> processRequest(Context context, HttpClientRequest request) {
        DefaultHttpHeaders clientHeaders = new DefaultHttpHeaders();
        for (Map.Entry header : request.headers()) {
            clientHeaders.add((String)header.getKey(), (Iterable)header.getValue());
        }
        Uri uri = new Uri(request.uri().getScheme(), request.uri().getRawUserInfo(), request.uri().getHost(), request.uri().getPort(), request.uri().getRawPath(), request.uri().getRawQuery(), request.uri().getRawFragment());
        RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)new RequestBuilder(request.method()).setUri(uri)).setHeaders((HttpHeaders)clientHeaders);
        if (request.requestTimeout() != null) {
            requestBuilder.setRequestTimeout((int)request.requestTimeout().toMillis());
        }
        try {
            this.setBody(requestBuilder, request.body(), context);
        }
        catch (Exception exception) {
            return CompletableFuture.failedFuture(exception);
        }
        CompletableFuture<HttpClientResponse> future = new CompletableFuture<HttpClientResponse>();
        ListenableFuture response = this.client.executeRequest(requestBuilder, (AsyncHandler)new MonoSinkStreamAsyncHandler(context, future));
        return future.whenComplete((rs, error) -> {
            if (error instanceof CancellationException) {
                response.cancel(true);
            }
        });
    }

    private void setBody(RequestBuilder requestBuilder, @Nullable HttpBodyOutput body, Context context) throws Exception {
        if (body == null) {
            return;
        }
        if (body.contentType() != null) {
            requestBuilder.setHeader((CharSequence)"content-type", body.contentType());
        }
        if (body.contentLength() == 0) {
            return;
        }
        ByteBuffer full = body.getFullContentIfAvailable();
        if (full != null) {
            requestBuilder.setBody(full);
            return;
        }
        requestBuilder.setBody((BodyGenerator)new AsyncHttpClientRequestBodyGenerator(body));
    }

    public void init() {
    }

    public void release() throws IOException {
        this.client.close();
    }
}

