/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.aspect;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.logging.aspect.LogAspectClassNames;

public class LogAspectUtils {
    public static final List<String> LEVELS = List.of("ERROR", "WARN", "INFO", "DEBUG", "TRACE");

    @Nullable
    public static String logInLevel(ExecutableElement method, ProcessingEnvironment env) {
        String level;
        AnnotationMirror logAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)LogAspectClassNames.log);
        AnnotationMirror logInAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)LogAspectClassNames.logIn);
        if (logAnnotation == null && logInAnnotation == null) {
            return null;
        }
        if (logInAnnotation != null && (level = LogAspectUtils.parseLogLevel(logInAnnotation, env)) != null) {
            return level;
        }
        if (logAnnotation != null && (level = LogAspectUtils.parseLogLevel(logAnnotation, env)) != null) {
            return level;
        }
        return "INFO";
    }

    @Nullable
    public static String logOutLevel(ExecutableElement method, ProcessingEnvironment env) {
        String level;
        AnnotationMirror logAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)LogAspectClassNames.log);
        AnnotationMirror logOutAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)LogAspectClassNames.logOut);
        if (logAnnotation == null && logOutAnnotation == null) {
            return null;
        }
        if (logOutAnnotation != null && (level = LogAspectUtils.parseLogLevel(logOutAnnotation, env)) != null) {
            return level;
        }
        if (logAnnotation != null && (level = LogAspectUtils.parseLogLevel(logAnnotation, env)) != null) {
            return level;
        }
        return "INFO";
    }

    @Nullable
    public static String logResultLevel(ExecutableElement method, String logOutLevel, ProcessingEnvironment env) {
        AnnotationMirror logOffAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)LogAspectClassNames.logOff);
        if (logOffAnnotation != null) {
            return null;
        }
        AnnotationMirror logResultAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)LogAspectClassNames.logResult);
        String level = LogAspectUtils.parseLogLevel(logResultAnnotation, env);
        if (level != null) {
            if (LEVELS.indexOf(logOutLevel) > LEVELS.indexOf(level)) {
                return logOutLevel;
            }
            return level;
        }
        if (LEVELS.indexOf(logOutLevel) > LEVELS.indexOf("DEBUG")) {
            return logOutLevel;
        }
        return "DEBUG";
    }

    @Nullable
    public static String logParameterLevel(VariableElement parameter, String logInLevel, ProcessingEnvironment env) {
        AnnotationMirror logOffAnnotation = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)LogAspectClassNames.logOff);
        if (logOffAnnotation != null) {
            return null;
        }
        AnnotationMirror logAnnotation = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)LogAspectClassNames.log);
        String logLevel = LogAspectUtils.parseLogLevel(logAnnotation, env);
        if (logLevel != null) {
            if (LEVELS.indexOf(logInLevel) > LEVELS.indexOf(logLevel)) {
                return logInLevel;
            }
            return logLevel;
        }
        if (LEVELS.indexOf(logInLevel) > LEVELS.indexOf("DEBUG")) {
            return logInLevel;
        }
        return "DEBUG";
    }

    private static String parseLogLevel(AnnotationMirror annotation, ProcessingEnvironment env) {
        return Optional.ofNullable(annotation).flatMap(annotationMirror -> env.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)annotationMirror).entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals("value")).map(entry -> ((AnnotationValue)entry.getValue()).getValue().toString()).findFirst()).orElse(null);
    }
}

