/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.aspect;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.logging.aspect.LogAspectClassNames;
import ru.tinkoff.kora.logging.aspect.LogAspectUtils;

public class LogAspect
implements KoraAspect {
    private static final String RESULT_VAR_NAME = "__result";
    private static final String DATA_IN_VAR_NAME = "__dataIn";
    private static final String DATA_OUT_VAR_NAME = "__dataOut";
    private static final String MESSAGE_IN = ">";
    private static final String MESSAGE_OUT = "<";
    private final ProcessingEnvironment env;

    public LogAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(LogAspectClassNames.log.canonicalName(), LogAspectClassNames.logIn.canonicalName(), LogAspectClassNames.logOut.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement executableElement, String superCall, KoraAspect.AspectContext aspectContext) {
        String loggerName = executableElement.getEnclosingElement() + "." + executableElement.getSimpleName();
        String loggerFactoryFieldName = aspectContext.fieldFactory().constructorParam((TypeName)LogAspectClassNames.loggerFactory, List.of());
        String loggerFieldName = aspectContext.fieldFactory().constructorInitialized((TypeName)LogAspectClassNames.logger, CodeBlock.builder().add("$N.getLogger($S)", new Object[]{loggerFactoryFieldName, loggerName}).build());
        boolean isMono = CommonUtils.isMono((TypeMirror)executableElement.getReturnType());
        if (isMono) {
            return this.monoBody(executableElement, superCall, loggerFieldName);
        }
        return this.blockingBody(executableElement, superCall, loggerFieldName);
    }

    private KoraAspect.ApplyResult blockingBody(ExecutableElement executableElement, String superCall, String loggerFieldName) {
        boolean isVoid;
        String logInLevel = LogAspectUtils.logInLevel(executableElement, this.env);
        String logOutLevel = LogAspectUtils.logOutLevel(executableElement, this.env);
        CodeBlock.Builder b = CodeBlock.builder();
        if (logInLevel != null) {
            b.add(this.buildLogIn(executableElement, logInLevel, loggerFieldName));
        }
        boolean bl = isVoid = executableElement.getReturnType().getKind() == TypeKind.VOID;
        if (isVoid) {
            b.add(KoraAspect.callSuper((ExecutableElement)executableElement, (String)superCall)).add(";", new Object[0]);
        } else {
            b.add("var $N = $L;\n", new Object[]{RESULT_VAR_NAME, KoraAspect.callSuper((ExecutableElement)executableElement, (String)superCall)});
        }
        if (logOutLevel != null) {
            String logResultLevel = LogAspectUtils.logResultLevel(executableElement, logOutLevel, this.env);
            CodeBlock resultWriter = CodeBlock.builder().add("gen -> {$>\n", new Object[0]).add("gen.writeStartObject();\n", new Object[0]).add("gen.writeStringField($S, String.valueOf($N));\n", new Object[]{"out", RESULT_VAR_NAME}).add("gen.writeEndObject();", new Object[0]).add("$<\n}", new Object[0]).build();
            if (isVoid || logResultLevel == null) {
                b.addStatement("$N.$L($S)", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), MESSAGE_OUT});
            } else if (logOutLevel.equals(logResultLevel)) {
                this.ifLogLevelEnabled(b, loggerFieldName, logOutLevel, () -> {
                    b.addStatement("var $N = $T.marker($S, $L)", new Object[]{DATA_OUT_VAR_NAME, LogAspectClassNames.structuredArgument, "data", resultWriter});
                    b.add("$N.$L($N, $S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), DATA_OUT_VAR_NAME, MESSAGE_OUT});
                }).add("\n", new Object[0]);
            } else {
                this.ifLogLevelEnabled(b, loggerFieldName, logResultLevel, () -> {
                    b.addStatement("var $N = $T.marker($S, $L)", new Object[]{DATA_OUT_VAR_NAME, LogAspectClassNames.structuredArgument, "data", resultWriter});
                    b.add("$N.$L($N, $S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), DATA_OUT_VAR_NAME, MESSAGE_OUT});
                    b.add("$<\n} else {$>\n", new Object[0]);
                    b.add("$N.$L($S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), MESSAGE_OUT});
                });
            }
        }
        if (!isVoid) {
            b.addStatement("return $N", new Object[]{RESULT_VAR_NAME});
        }
        return new KoraAspect.ApplyResult.MethodBody(b.build());
    }

    private KoraAspect.ApplyResult monoBody(ExecutableElement executableElement, String superCall, String loggerFieldName) {
        String logInLevel = LogAspectUtils.logInLevel(executableElement, this.env);
        String logOutLevel = LogAspectUtils.logOutLevel(executableElement, this.env);
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("var $N = $L;\n", new Object[]{RESULT_VAR_NAME, KoraAspect.callSuper((ExecutableElement)executableElement, (String)superCall)});
        if (logInLevel != null) {
            String finalResultName = "__result_final";
            b.add("var $N = $N;\n", new Object[]{finalResultName, RESULT_VAR_NAME});
            this.ifLogLevelEnabled(b, loggerFieldName, logInLevel, () -> {
                b.add("$N = $T.defer(() -> {$>\n", new Object[]{RESULT_VAR_NAME, CommonClassNames.mono});
                b.add(this.buildLogIn(executableElement, logInLevel, loggerFieldName));
                b.add("return $N;", new Object[]{finalResultName});
                b.add("$<\n});", new Object[0]);
            }).add("\n", new Object[0]);
        }
        if (logOutLevel != null) {
            String logResultLevel = LogAspectUtils.logResultLevel(executableElement, logOutLevel, this.env);
            this.ifLogLevelEnabled(b, loggerFieldName, logOutLevel, () -> {
                ParameterizedTypeName returnType = (ParameterizedTypeName)TypeName.get((TypeMirror)executableElement.getReturnType());
                if (logResultLevel == null || ((TypeName)returnType.typeArguments.get(0)).equals((Object)TypeName.VOID.box())) {
                    b.add("$N = $N.doOnSuccess(v -> $N.$L($S));", new Object[]{RESULT_VAR_NAME, RESULT_VAR_NAME, loggerFieldName, logOutLevel.toLowerCase(), MESSAGE_OUT});
                } else {
                    String resultValue = "__result_value";
                    b.add("var $N = this.$N;\n", new Object[]{loggerFieldName, loggerFieldName});
                    b.add("$N = $N.doOnSuccess($N -> $>{\n", new Object[]{RESULT_VAR_NAME, RESULT_VAR_NAME, resultValue});
                    b.add("if ($N != null) {$>\n", new Object[]{resultValue});
                    if (logOutLevel.equals(logResultLevel)) {
                        this.ifLogLevelEnabled(b, loggerFieldName, logOutLevel, () -> {
                            b.addStatement("var $N = $T.marker($S, gen -> gen.writeStringField($S, String.valueOf($N)))", new Object[]{DATA_OUT_VAR_NAME, LogAspectClassNames.structuredArgument, "data", "out", resultValue});
                            b.add("$N.$L($N, $S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), DATA_OUT_VAR_NAME, MESSAGE_OUT});
                        });
                    } else {
                        this.ifLogLevelEnabled(b, loggerFieldName, logResultLevel, () -> {
                            b.addStatement("var $N = $T.marker($S, gen -> gen.writeStringField($S, String.valueOf($N)))", new Object[]{DATA_OUT_VAR_NAME, LogAspectClassNames.structuredArgument, "data", "out", resultValue});
                            b.add("$N.$L($N, $S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), DATA_OUT_VAR_NAME, MESSAGE_OUT});
                            b.add("$<\n} else {$>\n", new Object[0]);
                            b.add("$N.$L($S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), MESSAGE_OUT});
                        });
                    }
                    b.add("$<\n} else {$>\n", new Object[0]);
                    b.add("$N.$L($S);", new Object[]{loggerFieldName, logOutLevel.toLowerCase(), MESSAGE_OUT});
                    b.add("$<\n}", new Object[0]);
                    b.add("$<\n});", new Object[0]);
                }
            }).add("\n", new Object[0]);
        }
        return new KoraAspect.ApplyResult.MethodBody(b.add("return $N;\n", new Object[]{RESULT_VAR_NAME}).build());
    }

    private CodeBlock buildLogIn(ExecutableElement executableElement, String logInLevel, String loggerFieldName) {
        CodeBlock.Builder b = CodeBlock.builder();
        int methodLevelIdx = LogAspectUtils.LEVELS.indexOf(logInLevel);
        LogInMarker logMarkerCode = this.logInMarker(loggerFieldName, executableElement, logInLevel);
        if (logMarkerCode != null) {
            if (LogAspectUtils.LEVELS.indexOf(logMarkerCode.minLogLevel()) <= methodLevelIdx) {
                this.ifLogLevelEnabled(b, loggerFieldName, logInLevel, () -> {
                    b.add(logMarkerCode.codeBlock());
                    b.add("$N.$L($N, $S);", new Object[]{loggerFieldName, logInLevel.toLowerCase(), DATA_IN_VAR_NAME, MESSAGE_IN});
                }).add("\n", new Object[0]);
            } else {
                this.ifLogLevelEnabled(b, loggerFieldName, logMarkerCode.minLogLevel(), () -> {
                    b.add(logMarkerCode.codeBlock());
                    b.add("$N.$L($N, $S);", new Object[]{loggerFieldName, logInLevel.toLowerCase(), DATA_IN_VAR_NAME, MESSAGE_IN});
                    b.add("$<\n} else {$>\n", new Object[0]);
                    b.add("$N.$L($S);", new Object[]{loggerFieldName, logInLevel.toLowerCase(), MESSAGE_IN});
                }).add("\n", new Object[0]);
            }
        } else {
            b.add("$N.$L($S);\n", new Object[]{loggerFieldName, logInLevel.toLowerCase(), MESSAGE_IN});
        }
        return b.build();
    }

    @Nullable
    private LogInMarker logInMarker(String loggerField, ExecutableElement executableElement, String logInLevel) {
        ArrayList<VariableElement> parametersToLog = new ArrayList<VariableElement>(executableElement.getParameters().size());
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (AnnotationUtils.findAnnotation((Element)variableElement, (ClassName)LogAspectClassNames.logOff) != null) continue;
            parametersToLog.add(variableElement);
        }
        if (parametersToLog.isEmpty()) {
            return null;
        }
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("var $N = $T.marker($S, gen -> {$>", new Object[]{DATA_IN_VAR_NAME, LogAspectClassNames.structuredArgument, "data"});
        b.add("\ngen.writeStartObject();", new Object[0]);
        HashMap hashMap = new HashMap();
        int minLevelIdx = Integer.MAX_VALUE;
        for (VariableElement parameter : parametersToLog) {
            String level = Objects.requireNonNull(LogAspectUtils.logParameterLevel(parameter, logInLevel, this.env));
            minLevelIdx = Math.min(minLevelIdx, LogAspectUtils.LEVELS.indexOf(level));
            hashMap.computeIfAbsent(level, l -> new ArrayList()).add(parameter);
        }
        for (int i = 0; i < LogAspectUtils.LEVELS.size(); ++i) {
            String level = LogAspectUtils.LEVELS.get(i);
            List paramsForLevel = hashMap.getOrDefault(level, List.of());
            if (paramsForLevel.isEmpty()) continue;
            if (i > minLevelIdx) {
                b.add("\nif ($N.$N()) {$>", new Object[]{loggerField, "is" + CommonUtils.capitalize((String)level.toLowerCase()) + "Enabled"});
            }
            for (VariableElement param : paramsForLevel) {
                b.add("\ngen.writeStringField($S, String.valueOf($N));", new Object[]{param.getSimpleName(), param.getSimpleName()});
            }
            if (i <= minLevelIdx) continue;
            b.add("$<\n}", new Object[0]);
        }
        b.add("\ngen.writeEndObject();", new Object[0]);
        return new LogInMarker(b.add("$<\n});\n", new Object[0]).build(), LogAspectUtils.LEVELS.get(minLevelIdx));
    }

    private CodeBlock.Builder ifLogLevelEnabled(CodeBlock.Builder cb, String loggerFieldName, String logLevel, Runnable r) {
        cb.add("if ($N.$N()) {$>\n", new Object[]{loggerFieldName, "is" + CommonUtils.capitalize((String)logLevel.toLowerCase()) + "Enabled"});
        r.run();
        cb.add("$<\n}", new Object[0]);
        return cb;
    }

    record LogInMarker(CodeBlock codeBlock, String minLogLevel) {
    }
}

