/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.r2dbc;

import io.r2dbc.pool.ConnectionPoolConfiguration;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@ConfigValueExtractor
public interface R2dbcDatabaseConfig {
    public String r2dbcUrl();

    public String username();

    public String password();

    public String poolName();

    default public Duration connectionTimeout() {
        return Duration.ofSeconds(10L);
    }

    default public Duration connectionCreateTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Nullable
    public Duration statementTimeout();

    default public Duration idleTimeout() {
        return Duration.ofMinutes(10L);
    }

    default public Duration maxLifetime() {
        return ConnectionPoolConfiguration.NO_TIMEOUT;
    }

    default public int acquireRetry() {
        return 3;
    }

    default public int maxPoolSize() {
        return 10;
    }

    default public int minIdle() {
        return 0;
    }

    default public boolean readinessProbe() {
        return false;
    }

    default public Map<String, String> options() {
        return Map.of();
    }

    public TelemetryConfig telemetry();
}

