/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.r2dbc;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.database.r2dbc.R2dbcDatabaseConfig;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $R2dbcDatabaseConfig_ConfigValueExtractor
implements ConfigValueExtractor<R2dbcDatabaseConfig> {
    public static final R2dbcDatabaseConfig_Defaults DEFAULTS = new R2dbcDatabaseConfig_Defaults();
    private static final PathElement.Key _r2dbcUrl_path = PathElement.get((String)"r2dbcUrl");
    private static final PathElement.Key _username_path = PathElement.get((String)"username");
    private static final PathElement.Key _password_path = PathElement.get((String)"password");
    private static final PathElement.Key _poolName_path = PathElement.get((String)"poolName");
    private static final PathElement.Key _connectionTimeout_path = PathElement.get((String)"connectionTimeout");
    private static final PathElement.Key _connectionCreateTimeout_path = PathElement.get((String)"connectionCreateTimeout");
    private static final PathElement.Key _statementTimeout_path = PathElement.get((String)"statementTimeout");
    private static final PathElement.Key _idleTimeout_path = PathElement.get((String)"idleTimeout");
    private static final PathElement.Key _maxLifetime_path = PathElement.get((String)"maxLifetime");
    private static final PathElement.Key _acquireRetry_path = PathElement.get((String)"acquireRetry");
    private static final PathElement.Key _maxPoolSize_path = PathElement.get((String)"maxPoolSize");
    private static final PathElement.Key _minIdle_path = PathElement.get((String)"minIdle");
    private static final PathElement.Key _readinessProbe_path = PathElement.get((String)"readinessProbe");
    private static final PathElement.Key _options_path = PathElement.get((String)"options");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Duration> extractor1;
    private final ConfigValueExtractor<Duration> connectionTimeout_parser;
    private final ConfigValueExtractor<Duration> connectionCreateTimeout_parser;
    private final ConfigValueExtractor<Duration> statementTimeout_parser;
    private final ConfigValueExtractor<Duration> idleTimeout_parser;
    private final ConfigValueExtractor<Duration> maxLifetime_parser;
    private final ConfigValueExtractor<Boolean> extractor2;
    private final ConfigValueExtractor<Boolean> readinessProbe_parser;
    private final ConfigValueExtractor<Map<String, String>> extractor3;
    private final ConfigValueExtractor<Map<String, String>> options_parser;
    private final ConfigValueExtractor<TelemetryConfig> extractor4;
    private final ConfigValueExtractor<TelemetryConfig> telemetry_parser;

    public $R2dbcDatabaseConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<Boolean> extractor2, ConfigValueExtractor<Map<String, String>> extractor3, ConfigValueExtractor<TelemetryConfig> extractor4) {
        this.extractor1 = extractor1;
        this.connectionTimeout_parser = extractor1;
        this.connectionCreateTimeout_parser = extractor1;
        this.statementTimeout_parser = extractor1;
        this.idleTimeout_parser = extractor1;
        this.maxLifetime_parser = extractor1;
        this.extractor2 = extractor2;
        this.readinessProbe_parser = extractor2;
        this.extractor3 = extractor3;
        this.options_parser = extractor3;
        this.extractor4 = extractor4;
        this.telemetry_parser = extractor4;
    }

    public R2dbcDatabaseConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        String r2dbcUrl = this.parse_r2dbcUrl(_config);
        String username = this.parse_username(_config);
        String password = this.parse_password(_config);
        String poolName = this.parse_poolName(_config);
        Duration connectionTimeout = this.parse_connectionTimeout(_config);
        Duration connectionCreateTimeout = this.parse_connectionCreateTimeout(_config);
        Duration statementTimeout = this.parse_statementTimeout(_config);
        Duration idleTimeout = this.parse_idleTimeout(_config);
        Duration maxLifetime = this.parse_maxLifetime(_config);
        int acquireRetry = this.parse_acquireRetry(_config);
        int maxPoolSize = this.parse_maxPoolSize(_config);
        int minIdle = this.parse_minIdle(_config);
        boolean readinessProbe = this.parse_readinessProbe(_config);
        Map<String, String> options = this.parse_options(_config);
        TelemetryConfig telemetry = this.parse_telemetry(_config);
        return new R2dbcDatabaseConfig_Impl(r2dbcUrl, username, password, poolName, connectionTimeout, connectionCreateTimeout, statementTimeout, idleTimeout, maxLifetime, acquireRetry, maxPoolSize, minIdle, readinessProbe, options, telemetry);
    }

    private String parse_r2dbcUrl(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_r2dbcUrl_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_username(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_username_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_password(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_password_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private String parse_poolName(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_poolName_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
        }
        return value.asString();
    }

    private Duration parse_connectionTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_connectionTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.connectionTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.connectionTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_connectionCreateTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_connectionCreateTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.connectionCreateTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.connectionCreateTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Nullable
    private Duration parse_statementTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_statementTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return (Duration)this.statementTimeout_parser.extract(value);
    }

    private Duration parse_idleTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_idleTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.idleTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.idleTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_maxLifetime(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxLifetime_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.maxLifetime();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.maxLifetime_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private int parse_acquireRetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_acquireRetry_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.acquireRetry();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private int parse_maxPoolSize(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maxPoolSize_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.maxPoolSize();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private int parse_minIdle(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_minIdle_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.minIdle();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private boolean parse_readinessProbe(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_readinessProbe_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.readinessProbe();
            return defaultValue;
        }
        Boolean parsed = (Boolean)this.readinessProbe_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Map<String, String> parse_options(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_options_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Map<String, String> defaultValue = DEFAULTS.options();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Map parsed = (Map)this.options_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private TelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        TelemetryConfig parsed = (TelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    public record R2dbcDatabaseConfig_Impl(String r2dbcUrl, String username, String password, String poolName, Duration connectionTimeout, Duration connectionCreateTimeout, Duration statementTimeout, Duration idleTimeout, Duration maxLifetime, int acquireRetry, int maxPoolSize, int minIdle, boolean readinessProbe, Map<String, String> options, TelemetryConfig telemetry) implements R2dbcDatabaseConfig
    {
        public R2dbcDatabaseConfig_Impl {
            Objects.requireNonNull(r2dbcUrl);
            Objects.requireNonNull(username);
            Objects.requireNonNull(password);
            Objects.requireNonNull(poolName);
            Objects.requireNonNull(connectionTimeout);
            Objects.requireNonNull(connectionCreateTimeout);
            Objects.requireNonNull(idleTimeout);
            Objects.requireNonNull(maxLifetime);
            Objects.requireNonNull(options);
            Objects.requireNonNull(telemetry);
        }
    }

    public static final class R2dbcDatabaseConfig_Defaults
    implements R2dbcDatabaseConfig {
        @Override
        public String r2dbcUrl() {
            return null;
        }

        @Override
        public String username() {
            return null;
        }

        @Override
        public String password() {
            return null;
        }

        @Override
        public String poolName() {
            return null;
        }

        @Override
        public Duration statementTimeout() {
            return null;
        }

        @Override
        public TelemetryConfig telemetry() {
            return null;
        }
    }
}

