/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperationUtils;
import ru.tinkoff.kora.cache.annotation.processor.aop.AbstractAopCacheAspect;

public class CacheableAopKoraAspect
extends AbstractAopCacheAspect {
    private static final ClassName ANNOTATION_CACHEABLE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheable", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHEABLES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheables", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CacheableAopKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHEABLE.canonicalName(), ANNOTATION_CACHEABLES.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        CodeBlock body;
        if (MethodUtils.isFlux((ExecutableElement)method)) {
            throw new ProcessingErrorException("@Cacheable can't be applied for types assignable from " + CommonClassNames.flux, (Element)method);
        }
        if (MethodUtils.isPublisher((ExecutableElement)method)) {
            throw new ProcessingErrorException("@Cacheable can't be applied for type " + CommonClassNames.publisher, (Element)method);
        }
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            throw new ProcessingErrorException("@Cacheable can't be applied for type Void", (Element)method);
        }
        CacheOperation operation = CacheOperationUtils.getCacheOperation(method, this.env, aspectContext);
        if (MethodUtils.isMono((ExecutableElement)method)) {
            if (MethodUtils.isMonoVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("@Cacheable can't be applied for type Void", (Element)method);
            }
            body = this.buildBodyMono(method, operation, superCall);
        } else if (MethodUtils.isFuture((ExecutableElement)method)) {
            if (MethodUtils.isFutureVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("@Cacheable can't be applied for type Void", (Element)method);
            }
            body = this.buildBodyFutureNew(method, operation, superCall);
        } else {
            body = this.buildBodySync(method, operation, superCall);
        }
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock.Builder getCacheSyncBlock(ExecutableElement method, CacheOperation operation) {
        boolean isOptional = MethodUtils.isOptional((ExecutableElement)method);
        Object keyField = "_key1";
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < operation.executions().size(); ++i) {
            CacheOperation.CacheExecution cache = operation.executions().get(i);
            String prefix = i == 0 ? "var _value = " : "_value = ";
            boolean prevKeyMatch = false;
            for (int i1 = 0; i1 < i; ++i1) {
                CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                keyField = "_key" + (i1 + 1);
                prevKeyMatch = true;
                break;
            }
            if (!prevKeyMatch) {
                keyField = "_key" + (i + 1);
                builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
            }
            builder.add(prefix, new Object[0]).add(cache.field(), new Object[0]).add(".get($L);\n", new Object[]{keyField});
            builder.beginControlFlow("if(_value != null)", new Object[0]);
            for (int j = 0; j < i; ++j) {
                CacheOperation.CacheExecution cachePrevPut = operation.executions().get(j);
                String putKeyField = "_key" + (j + 1);
                for (int i1 = 0; i1 < i; ++i1) {
                    CacheOperation.CacheExecution prevCachePut = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cachePrevPut.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    putKeyField = "_key" + (i1 + 1);
                }
                builder.add(cachePrevPut.field(), new Object[0]).add(".put($L, _value);\n", new Object[]{putKeyField});
            }
            if (isOptional) {
                builder.add("return $T.of(_value);", new Object[]{Optional.class});
            } else if (MethodUtils.isFuture((ExecutableElement)method)) {
                TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
                if (CommonUtils.isOptional((TypeMirror)completionType)) {
                    builder.add("return $T.completedFuture($T.of(_value));", new Object[]{CompletableFuture.class, Optional.class});
                } else {
                    builder.add("return $T.completedFuture(_value);", new Object[]{CompletableFuture.class});
                }
            } else if (MethodUtils.isMono((ExecutableElement)method)) {
                TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
                if (CommonUtils.isOptional((TypeMirror)completionType)) {
                    builder.add("return $T.just($T.of(_value));", new Object[]{CommonClassNames.mono, Optional.class});
                } else {
                    builder.add("return $T.just(_value);", new Object[]{CommonClassNames.mono});
                }
            } else {
                builder.add("return _value;", new Object[0]);
            }
            builder.add("\n", new Object[0]);
            builder.endControlFlow();
            builder.add("\n", new Object[0]);
        }
        return builder;
    }

    private CodeBlock buildBodySync(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        boolean isOptional = MethodUtils.isOptional((ExecutableElement)method);
        if (operation.executions().size() == 1) {
            String keyField = "_key";
            CodeBlock keyBlock = CodeBlock.builder().add("var $L = ", new Object[]{"_key"}).addStatement(operation.executions().get(0).cacheKey().code()).build();
            if (isOptional) {
                return CodeBlock.builder().add(keyBlock).add("return $T.ofNullable($L.computeIfAbsent($L, _k -> $L.orElse(null)));", new Object[]{Optional.class, operation.executions().get(0).field(), "_key", superMethod}).build();
            }
            return CodeBlock.builder().add(keyBlock).add("return $L.computeIfAbsent($L, _k -> $L);", new Object[]{operation.executions().get(0).field(), "_key", superMethod}).build();
        }
        CodeBlock.Builder builder = this.getCacheSyncBlock(method, operation);
        builder.add("var _result = ", new Object[0]).add(superMethod, new Object[0]).add(";\n", new Object[0]);
        boolean isPrimitive = method.getReturnType() instanceof PrimitiveType;
        if (isOptional) {
            builder.beginControlFlow("_result.ifPresent(_v ->", new Object[0]);
        } else if (!isPrimitive) {
            builder.beginControlFlow("if(_result != null)", new Object[0]);
        }
        for (int i = 0; i < operation.executions().size(); ++i) {
            CacheOperation.CacheExecution cache = operation.executions().get(i);
            String putKeyField = "_key" + (i + 1);
            for (int i1 = 0; i1 < i; ++i1) {
                CacheOperation.CacheExecution prevCachePut = operation.executions().get(i1);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                putKeyField = "_key" + (i1 + 1);
            }
            if (isOptional) {
                builder.add(cache.field(), new Object[0]).add(".put($L, _v);\n", new Object[]{putKeyField});
                continue;
            }
            builder.add(cache.field(), new Object[0]).add(".put($L, _result);\n", new Object[]{putKeyField});
        }
        if (isOptional) {
            builder.endControlFlow(")", new Object[0]);
        } else if (!isPrimitive) {
            builder.endControlFlow();
        }
        builder.add("return _result;", new Object[0]);
        return builder.build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (operation.executions().stream().allMatch(e -> e.contract() == CacheOperation.CacheExecution.Contract.SYNC)) {
            builder.beginControlFlow("return $T.defer(() -> ", new Object[]{CommonClassNames.mono});
            builder.add(this.getCacheSyncBlock(method, operation).build());
            builder.add("return $L", new Object[]{superMethod}).beginControlFlow(".doOnSuccess(_r ->", new Object[0]);
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            for (int j = 0; j < operation.executions().size(); ++j) {
                CacheOperation.CacheExecution cache = operation.executions().get(j);
                String keyField = "_key" + (j + 1);
                for (int i1 = 0; i1 < j; ++i1) {
                    CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                    keyField = "_key" + (i1 + 1);
                    break;
                }
                CacheOperation.CacheExecution putExec = operation.executions().get(j);
                if (isOptional) {
                    codeBlock.addStatement("$L.put($L, _r.get())", new Object[]{putExec.field(), keyField});
                    continue;
                }
                codeBlock.addStatement("$L.put($L, _r)", new Object[]{putExec.field(), keyField});
            }
            if (isOptional) {
                builder.beginControlFlow("if (_r.isPresent())", new Object[0]).add(codeBlock.build()).endControlFlow();
            } else {
                builder.beginControlFlow("if (_r != null)", new Object[0]).add(codeBlock.build()).endControlFlow();
            }
            builder.endControlFlow(")", new Object[0]).endControlFlow(")", new Object[0]);
        } else {
            String keyField;
            CacheOperation.CacheExecution prevCache;
            int i1;
            CacheOperation.CacheExecution cache;
            int i;
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                boolean prevKeyMatch = false;
                for (i1 = 0; i1 < i; ++i1) {
                    prevCache = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                    prevKeyMatch = true;
                }
                if (prevKeyMatch) continue;
                keyField = "_key" + (i + 1);
                builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
            }
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                String prefix = i == 0 ? "var _value = " : "_value = _value.switchIfEmpty(";
                keyField = "_key" + (i + 1);
                for (i1 = 0; i1 < i; ++i1) {
                    prevCache = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                    keyField = "_key" + (i1 + 1);
                }
                if (cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                    builder.add(prefix, new Object[0]).add("$T.fromCompletionStage(() -> $L", new Object[]{CommonClassNames.mono, cache.field()}).add(".getAsync($L))", new Object[]{keyField});
                } else {
                    builder.add(prefix, new Object[0]).add("$T.fromCallable(() -> $L", new Object[]{CommonClassNames.mono, cache.field()}).add(".get($L))", new Object[]{keyField});
                }
                if (i > 1) {
                    builder.add("\n", new Object[0]).add("    .doOnSuccess(_fromCache -> {\n        if(_fromCache != null) {\n            $T.merge(\n", new Object[]{CommonClassNames.flux});
                    for (int j = 0; j < i; ++j) {
                        prevCache = operation.executions().get(j);
                        String putKeyField = "_key" + (j + 1);
                        for (int i12 = 0; i12 < i; ++i12) {
                            CacheOperation.CacheExecution putPrevCache = operation.executions().get(i12);
                            if (!this.env.getTypeUtils().isSubtype(prevCache.cacheKey().type(), putPrevCache.cacheKey().type())) continue;
                            putKeyField = "_key" + (i12 + 1);
                        }
                        String template = cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC ? (j == i - 1 ? "$T.fromCompletionStage(() -> $L.putAsync($L, _fromCache))\n" : "$T.fromCompletionStage(() -> $L.putAsync($L, _fromCache)),\n") : (j == i - 1 ? "$T.just($L.put($L, _fromCache))\n" : "$T.just($L.put($L, _fromCache)),\n");
                        builder.add("\t\t\t\t", new Object[0]).add(template, new Object[]{CommonClassNames.mono, prevCache.field(), putKeyField});
                    }
                    builder.add("\t\t).then().block();\n}}));\n\n", new Object[0]);
                    continue;
                }
                if (i == 1) {
                    builder.add("\n\t", new Object[0]).add(String.format(".doOnSuccess(_fromCache -> {\n        if(_fromCache != null) {\n            %s.put(_key1, _fromCache);\n        }\n}));\n", operation.executions().get(0).field()), new Object[0]).add("\n", new Object[0]);
                    continue;
                }
                builder.add(";\n", new Object[0]);
            }
            if (isOptional) {
                builder.add("return _value.map($T::of).switchIfEmpty(", new Object[]{Optional.class}).add(superMethod, new Object[0]);
            } else {
                builder.add("return _value.switchIfEmpty(", new Object[0]).add(superMethod, new Object[0]);
            }
            if (operation.executions().size() > 1) {
                if (isOptional) {
                    builder.beginControlFlow(".flatMap(_result -> ", new Object[0]).beginControlFlow("if(_result.isPresent())", new Object[0]).add("return $T.merge(\n", new Object[]{CommonClassNames.flux});
                } else {
                    builder.add(".flatMap(_result -> $T.merge(\n", new Object[]{CommonClassNames.flux});
                }
                for (i = 0; i < operation.executions().size(); ++i) {
                    String resultField;
                    cache = operation.executions().get(i);
                    String putKeyField = "_key" + (i + 1);
                    for (int i13 = 0; i13 < i; ++i13) {
                        CacheOperation.CacheExecution putPrevCache = operation.executions().get(i13);
                        if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), putPrevCache.cacheKey().type())) continue;
                        putKeyField = "_key" + (i13 + 1);
                    }
                    String string = resultField = isOptional ? "_result.get()" : "_result";
                    String template = cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC ? (i == operation.executions().size() - 1 ? "$T.fromCompletionStage(() -> $L.putAsync($L, $L))\n" : "$T.fromCompletionStage(() -> $L.putAsync($L, $L)),\n") : (i == operation.executions().size() - 1 ? "$T.just($L.put($L, $L))\n" : "$T.just($L.put($L, $L)),\n");
                    builder.add("\t", new Object[0]).add(template, new Object[]{CommonClassNames.mono, cache.field(), putKeyField, resultField});
                }
                if (isOptional) {
                    builder.addStatement(").then(Mono.just(_result))", new Object[0]).endControlFlow().add("\n", new Object[0]).addStatement("return Mono.just(_result)", new Object[0]).endControlFlow("))", new Object[0]);
                } else {
                    builder.add(").then(Mono.just(_result))));", new Object[0]);
                }
            } else {
                CacheOperation.CacheExecution execution = operation.executions().get(0);
                if (isOptional) {
                    builder.add(".doOnSuccess(_result -> {\n    if(_result.isPresent()) {\n        var _key = $L;\n        $L.put(_key, _result.get());\n    }\n}));\n", new Object[]{execution.cacheKey().code(), execution.field()});
                } else {
                    builder.add(".doOnSuccess(_result -> {\n    if(_result != null) {\n        var _key = $L;\n        $L.put(_key, _result);\n    }\n}));\n", new Object[]{execution.cacheKey().code(), execution.field()});
                }
            }
        }
        return builder.build();
    }

    CodeBlock putCacheBlock(ExecutableElement method, List<CacheOperation.CacheExecution> executions, String valueField, boolean isValueOptional) {
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (isValueOptional) {
            builder.beginControlFlow("if($L.isPresent())", new Object[]{valueField});
        } else {
            builder.beginControlFlow("if($L != null)", new Object[]{valueField});
        }
        boolean allAreSync = executions.stream().allMatch(o -> o.contract() == CacheOperation.CacheExecution.Contract.SYNC);
        if (allAreSync) {
            for (int j = 0; j < executions.size(); ++j) {
                CacheOperation.CacheExecution cachePrevPut = executions.get(j);
                String putKeyField = "_key" + (j + 1);
                for (int i1 = 0; i1 < executions.size(); ++i1) {
                    CacheOperation.CacheExecution prevCachePut = executions.get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cachePrevPut.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    putKeyField = "_key" + (i1 + 1);
                    break;
                }
                if (isValueOptional) {
                    builder.addStatement("$L.put($L, $L.get())", new Object[]{cachePrevPut.field(), putKeyField, valueField});
                    continue;
                }
                builder.addStatement("$L.put($L, $L)", new Object[]{cachePrevPut.field(), putKeyField, valueField});
            }
            if (isValueOptional || !CommonUtils.isOptional((TypeMirror)completionType)) {
                builder.addStatement("return $T.completedFuture($L)", new Object[]{CompletableFuture.class, valueField});
            } else {
                builder.addStatement("return $T.completedFuture($T.of($L))", new Object[]{CompletableFuture.class, Optional.class, valueField});
            }
        } else {
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            for (int j = 0; j < executions.size(); ++j) {
                CacheOperation.CacheExecution cachePrevPut = executions.get(j);
                String putKeyField = "_key" + (j + 1);
                if (j != 0) {
                    codeBlock.add(",\n", new Object[0]);
                }
                for (int i1 = 0; i1 < executions.size(); ++i1) {
                    CacheOperation.CacheExecution prevCachePut = executions.get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cachePrevPut.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    putKeyField = "_key" + (i1 + 1);
                    break;
                }
                if (cachePrevPut.contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                    if (isValueOptional) {
                        codeBlock.add("\t$L.putAsync($L, $L.get()).toCompletableFuture()", new Object[]{cachePrevPut.field(), putKeyField, valueField});
                        continue;
                    }
                    codeBlock.add("\t$L.putAsync($L, $L).toCompletableFuture()", new Object[]{cachePrevPut.field(), putKeyField, valueField});
                    continue;
                }
                if (isValueOptional) {
                    codeBlock.add("\t$T.completedFuture($L.put($L, $L.get()))", new Object[]{CompletableFuture.class, cachePrevPut.field(), putKeyField, valueField});
                    continue;
                }
                codeBlock.add("\t$T.completedFuture($L.put($L, $L))", new Object[]{CompletableFuture.class, cachePrevPut.field(), putKeyField, valueField});
            }
            builder.add("return CompletableFuture.allOf(\n", new Object[0]).add(codeBlock.build());
            if (isValueOptional || !CommonUtils.isOptional((TypeMirror)completionType)) {
                builder.add("\n).thenApply(_ignore -> $L);\n", new Object[]{valueField});
            } else {
                builder.add("\n).thenApply(_ignore -> $T.ofNullable($L));\n", new Object[]{Optional.class, valueField});
            }
        }
        builder.endControlFlow();
        builder.add("\n", new Object[0]);
        return builder.build();
    }

    private CodeBlock buildBodyFutureNew(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        Object keyField = "_key1";
        int wraps = 0;
        for (int i = 0; i < operation.executions().size(); ++i) {
            CacheOperation.CacheExecution cache = operation.executions().get(i);
            boolean prevKeyMatch = false;
            for (int i1 = 0; i1 < i; ++i1) {
                CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                keyField = "_key" + (i1 + 1);
                prevKeyMatch = true;
                break;
            }
            if (!prevKeyMatch) {
                keyField = "_key" + (i + 1);
                builder.addStatement("var $L = $L", new Object[]{keyField, cache.cacheKey().code()});
            }
            int index = i + 1;
            String valueField = "_value" + index;
            if (cache.contract() == CacheOperation.CacheExecution.Contract.SYNC) {
                builder.add("var $L = $L.get($L);\n", new Object[]{valueField, cache.field(), keyField});
            } else {
                ++wraps;
                builder.beginControlFlow("return $L.getAsync($L).thenCompose($L ->", new Object[]{cache.field(), keyField, valueField});
            }
            List<CacheOperation.CacheExecution> putExecutions = operation.executions().stream().limit(i).toList();
            builder.add(this.putCacheBlock(method, putExecutions, valueField, false));
        }
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        builder.beginControlFlow("return $L.thenCompose(_r ->", new Object[]{superMethod});
        builder.add(this.putCacheBlock(method, operation.executions(), "_r", isOptional));
        builder.addStatement("return $T.completedFuture(_r)", new Object[]{CompletableFuture.class});
        builder.endControlFlow(")", new Object[0]);
        for (int w = 0; w < wraps; ++w) {
            builder.endControlFlow(")", new Object[0]);
        }
        return builder.build();
    }
}

