/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperationUtils;
import ru.tinkoff.kora.cache.annotation.processor.aop.AbstractAopCacheAspect;

public class CachePutAopKoraAspect
extends AbstractAopCacheAspect {
    private static final ClassName ANNOTATION_CACHE_PUT = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePut", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_PUTS = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePuts", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CachePutAopKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHE_PUT.canonicalName(), ANNOTATION_CACHE_PUTS.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        CodeBlock body;
        if (MethodUtils.isFlux((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CachePut can't be applied for types assignable from " + CommonClassNames.flux, (Element)method);
        }
        if (MethodUtils.isPublisher((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CachePut can't be applied for type " + CommonClassNames.publisher, (Element)method);
        }
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CachePut can't be applied for type Void", (Element)method);
        }
        CacheOperation operation = CacheOperationUtils.getCacheOperation(method, this.env, aspectContext);
        if (MethodUtils.isMono((ExecutableElement)method)) {
            if (MethodUtils.isMonoVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("@CachePut can't be applied for type Void", (Element)method);
            }
            body = this.buildBodyMono(method, operation, superCall);
        } else if (MethodUtils.isFuture((ExecutableElement)method)) {
            if (MethodUtils.isFutureVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("@CachePut can't be applied for type Void", (Element)method);
            }
            body = this.buildBodyFuture(method, operation, superCall);
        } else {
            body = this.buildBodySync(method, operation, superCall);
        }
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock getSyncBlock(ExecutableElement method, CacheOperation operation) {
        CacheOperation.CacheExecution prevCachePut;
        CacheOperation.CacheExecution cache;
        int i;
        CodeBlock.Builder builder = CodeBlock.builder();
        boolean isOptional = MethodUtils.isOptional((ExecutableElement)method);
        boolean isPrimitive = method.getReturnType() instanceof PrimitiveType;
        if (isOptional) {
            builder.beginControlFlow("_value.ifPresent(_v ->", new Object[0]);
        } else if (!isPrimitive) {
            builder.beginControlFlow("if(_value != null)", new Object[0]);
        }
        for (i = 0; i < operation.executions().size(); ++i) {
            cache = operation.executions().get(i);
            boolean prevKeyMatch = false;
            for (int j = 0; j < i; ++j) {
                prevCachePut = operation.executions().get(j);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                prevKeyMatch = true;
                break;
            }
            if (prevKeyMatch) continue;
            String keyField = "_key" + (i + 1);
            builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
        }
        for (i = 0; i < operation.executions().size(); ++i) {
            cache = operation.executions().get(i);
            String putKeyField = "_key" + (i + 1);
            for (int i1 = 0; i1 < i; ++i1) {
                prevCachePut = operation.executions().get(i1);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                putKeyField = "_key" + (i1 + 1);
            }
            if (isOptional) {
                builder.add("$L.put($L, _v);\n", new Object[]{cache.field(), putKeyField});
                continue;
            }
            builder.add("$L.put($L, _value);\n", new Object[]{cache.field(), putKeyField});
        }
        if (isOptional) {
            builder.endControlFlow(")", new Object[0]);
        } else if (!isPrimitive) {
            builder.endControlFlow();
        }
        return builder.add("return _value;", new Object[0]).build();
    }

    private CodeBlock buildBodySync(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("var _value = ", new Object[0]).add(superMethod, new Object[0]).add(";\n", new Object[0]);
        builder.add(this.getSyncBlock(method, operation));
        return builder.build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (operation.executions().stream().allMatch(e -> e.contract() == CacheOperation.CacheExecution.Contract.SYNC)) {
            CacheOperation.CacheExecution cache;
            int i;
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                boolean prevKeyMatch = false;
                for (int j = 0; j < i; ++j) {
                    CacheOperation.CacheExecution prevCachePut = operation.executions().get(j);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    prevKeyMatch = true;
                    break;
                }
                if (prevKeyMatch) continue;
                String keyField = "_key" + (i + 1);
                builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
            }
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]).beginControlFlow(".doOnSuccess(_result -> ", new Object[0]);
            if (isOptional) {
                builder.beginControlFlow("if(_result.isPresent())", new Object[0]);
            } else {
                builder.beginControlFlow("if(_result != null)", new Object[0]);
            }
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                String keyField = "_key" + (i + 1);
                for (int i1 = 0; i1 < i; ++i1) {
                    CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                    keyField = "_key" + (i1 + 1);
                }
                if (isOptional) {
                    builder.addStatement("$L.put($L, _result.get())", new Object[]{cache.field(), keyField});
                    continue;
                }
                builder.addStatement("$L.put($L, _result)", new Object[]{cache.field(), keyField});
            }
            builder.endControlFlow().endControlFlow(")", new Object[0]);
        } else if (operation.executions().size() > 1) {
            CacheOperation.CacheExecution cache;
            int i;
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                boolean prevKeyMatch = false;
                for (int j = 0; j < i; ++j) {
                    CacheOperation.CacheExecution prevCachePut = operation.executions().get(j);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    prevKeyMatch = true;
                    break;
                }
                if (prevKeyMatch) continue;
                String keyField = "_key" + (i + 1);
                builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
            }
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
            if (isOptional) {
                builder.beginControlFlow(".flatMap(_result -> ", new Object[0]).beginControlFlow("if(_result.isPresent())", new Object[0]).add("return $T.merge(\n", new Object[]{CommonClassNames.flux});
            } else {
                builder.add(".flatMap(_result -> $T.merge(\n", new Object[]{CommonClassNames.flux});
            }
            for (i = 0; i < operation.executions().size(); ++i) {
                String resultField;
                cache = operation.executions().get(i);
                String keyField = "_key" + (i + 1);
                for (int i1 = 0; i1 < i; ++i1) {
                    CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                    keyField = "_key" + (i1 + 1);
                }
                String string = resultField = isOptional ? "_result.get()" : "_result";
                String template = cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC ? (i == operation.executions().size() - 1 ? "$T.fromCompletionStage(() -> $L.putAsync($L, $L))\n" : "$T.fromCompletionStage(() -> $L.putAsync($L, $L)),\n") : (i == operation.executions().size() - 1 ? "$T.just($L.put($L, $L))\n" : "$T.just($L.put($L, $L)),\n");
                builder.add("\t", new Object[0]).add(template, new Object[]{CommonClassNames.mono, cache.field(), keyField, resultField});
            }
            if (isOptional) {
                builder.addStatement(").then(Mono.just(_result))", new Object[0]).endControlFlow().add("\n", new Object[0]).addStatement("return Mono.just(_result)", new Object[0]).endControlFlow(")", new Object[0]);
            } else {
                builder.add(").then(Mono.just(_result)));", new Object[0]);
            }
        } else {
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
            if (isOptional) {
                builder.add(".doOnSuccess(_result -> {\n    if(_result.isPresent()) {\n        var _key = $L;\n        $L.put(_key, _result.get());\n    }\n});\n", new Object[]{operation.executions().get(0).cacheKey().code(), operation.executions().get(0).field()});
            } else {
                builder.add(".doOnSuccess(_result -> {\n    if(_result != null) {\n        var _key = $L;\n        $L.put(_key, _result);\n    }\n});\n", new Object[]{operation.executions().get(0).cacheKey().code(), operation.executions().get(0).field()});
            }
        }
        return builder.build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        builder.add("return $L\n", new Object[]{superMethod}).beginControlFlow(".thenCompose(_value ->", new Object[0]);
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        builder.add(this.putCacheBlock(method, operation.executions(), "_value", isOptional));
        builder.addStatement("return $T.completedFuture(_value)", new Object[]{CompletableFuture.class}).endControlFlow(")", new Object[0]);
        return builder.build();
    }

    CodeBlock putCacheBlock(ExecutableElement method, List<CacheOperation.CacheExecution> executions, String valueField, boolean isValueOptional) {
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        CodeBlock.Builder builder = CodeBlock.builder();
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        if (isValueOptional) {
            builder.beginControlFlow("if($L.isPresent())", new Object[]{valueField});
        } else {
            builder.beginControlFlow("if($L != null)", new Object[]{valueField});
        }
        for (int i = 0; i < executions.size(); ++i) {
            CacheOperation.CacheExecution cache = executions.get(i);
            boolean prevKeyMatch = false;
            for (int j = 0; j < i; ++j) {
                CacheOperation.CacheExecution prevCachePut = executions.get(j);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                prevKeyMatch = true;
                break;
            }
            if (prevKeyMatch) continue;
            String keyField = "_key" + (i + 1);
            builder.addStatement("var $L = $L", new Object[]{keyField, cache.cacheKey().code()});
        }
        boolean allAreSync = executions.stream().allMatch(o -> o.contract() == CacheOperation.CacheExecution.Contract.SYNC);
        if (allAreSync) {
            for (int j = 0; j < executions.size(); ++j) {
                CacheOperation.CacheExecution cachePrevPut = executions.get(j);
                String putKeyField = "_key" + (j + 1);
                for (int i1 = 0; i1 < executions.size(); ++i1) {
                    CacheOperation.CacheExecution prevCachePut = executions.get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cachePrevPut.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    putKeyField = "_key" + (i1 + 1);
                    break;
                }
                if (isValueOptional) {
                    builder.addStatement("$L.put($L, $L.get())", new Object[]{cachePrevPut.field(), putKeyField, valueField});
                    continue;
                }
                builder.addStatement("$L.put($L, $L)", new Object[]{cachePrevPut.field(), putKeyField, valueField});
            }
            if (isValueOptional || !CommonUtils.isOptional((TypeMirror)completionType)) {
                builder.addStatement("return $T.completedFuture($L)", new Object[]{CompletableFuture.class, valueField});
            } else {
                builder.addStatement("return $T.completedFuture($T.of($L))", new Object[]{CompletableFuture.class, Optional.class, valueField});
            }
        } else {
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            for (int j = 0; j < executions.size(); ++j) {
                CacheOperation.CacheExecution cachePrevPut = executions.get(j);
                String putKeyField = "_key" + (j + 1);
                if (j != 0) {
                    codeBlock.add(",\n", new Object[0]);
                }
                for (int i1 = 0; i1 < executions.size(); ++i1) {
                    CacheOperation.CacheExecution prevCachePut = executions.get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cachePrevPut.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    putKeyField = "_key" + (i1 + 1);
                    break;
                }
                if (cachePrevPut.contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                    if (isValueOptional) {
                        codeBlock.add("\t$L.putAsync($L, $L.get()).toCompletableFuture()", new Object[]{cachePrevPut.field(), putKeyField, valueField});
                        continue;
                    }
                    codeBlock.add("\t$L.putAsync($L, $L).toCompletableFuture()", new Object[]{cachePrevPut.field(), putKeyField, valueField});
                    continue;
                }
                if (isValueOptional) {
                    codeBlock.add("\t$T.completedFuture($L.put($L, $L.get()))", new Object[]{CompletableFuture.class, cachePrevPut.field(), putKeyField, valueField});
                    continue;
                }
                codeBlock.add("\t$T.completedFuture($L.put($L, $L))", new Object[]{CompletableFuture.class, cachePrevPut.field(), putKeyField, valueField});
            }
            builder.add("return CompletableFuture.allOf(\n", new Object[0]).add(codeBlock.build());
            if (isValueOptional || !CommonUtils.isOptional((TypeMirror)completionType)) {
                builder.add("\n).thenApply(_ignore -> $L);\n", new Object[]{valueField});
            } else {
                builder.add("\n).thenApply(_ignore -> $T.ofNullable($L));\n", new Object[]{Optional.class, valueField});
            }
        }
        builder.endControlFlow();
        builder.add("\n", new Object[0]);
        return builder.build();
    }
}

