/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperationUtils;
import ru.tinkoff.kora.cache.annotation.processor.aop.AbstractAopCacheAspect;

public class CacheInvalidateAopKoraAspect
extends AbstractAopCacheAspect {
    private static final ClassName ANNOTATION_CACHE_INVALIDATE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidate", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_INVALIDATES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidates", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CacheInvalidateAopKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHE_INVALIDATE.canonicalName(), ANNOTATION_CACHE_INVALIDATES.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        if (MethodUtils.isFlux((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CacheInvalidate can't be applied for types assignable from " + CommonClassNames.flux, (Element)method);
        }
        if (MethodUtils.isPublisher((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CacheInvalidate can't be applied for type " + CommonClassNames.publisher, (Element)method);
        }
        CacheOperation operation = CacheOperationUtils.getCacheOperation(method, this.env, aspectContext);
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? (operation.type() == CacheOperation.Type.EVICT_ALL ? this.buildBodyMonoAll(method, operation, superCall) : this.buildBodyMono(method, operation, superCall)) : (MethodUtils.isFuture((ExecutableElement)method) ? (operation.type() == CacheOperation.Type.EVICT_ALL ? this.buildBodyFutureAll(method, operation, superCall) : this.buildBodyFuture(method, operation, superCall)) : (operation.type() == CacheOperation.Type.EVICT_ALL ? this.buildBodySyncAll(method, operation, superCall) : this.buildBodySync(method, operation, superCall)));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock getSyncBlock(ExecutableElement method, CacheOperation operation) {
        CacheOperation.CacheExecution cache;
        int i;
        CodeBlock.Builder builder = CodeBlock.builder();
        for (i = 0; i < operation.executions().size(); ++i) {
            cache = operation.executions().get(i);
            boolean prevKeyMatch = false;
            for (int j = 0; j < i; ++j) {
                CacheOperation.CacheExecution prevCachePut = operation.executions().get(j);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                prevKeyMatch = true;
                break;
            }
            if (prevKeyMatch) continue;
            String keyField = "_key" + (i + 1);
            builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
        }
        for (i = 0; i < operation.executions().size(); ++i) {
            cache = operation.executions().get(i);
            String keyField = "_key" + (i + 1);
            for (int i1 = 0; i1 < i; ++i1) {
                CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                keyField = "_key" + (i1 + 1);
            }
            builder.addStatement("$L.invalidate($L)", new Object[]{cache.field(), keyField});
        }
        return builder.build();
    }

    private CodeBlock buildBodySync(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.addStatement(superMethod, new Object[0]);
        } else {
            builder.add("var value = ", new Object[0]).addStatement(superMethod, new Object[0]);
        }
        builder.add(this.getSyncBlock(method, operation));
        if (!MethodUtils.isVoid((ExecutableElement)method)) {
            builder.addStatement("return value", new Object[0]);
        }
        return builder.build();
    }

    private CodeBlock buildBodySyncAll(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        StringBuilder builder = new StringBuilder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.append(superMethod).append(";\n");
        } else {
            builder.append("var _value = ").append(superMethod).append(";\n");
        }
        for (CacheOperation.CacheExecution cache : operation.executions()) {
            builder.append(cache.field()).append(".invalidateAll();\n");
        }
        if (!MethodUtils.isVoid((ExecutableElement)method)) {
            builder.append("return _value;");
        }
        return CodeBlock.builder().add(builder.toString(), new Object[0]).build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (operation.executions().stream().allMatch(e -> e.contract() == CacheOperation.CacheExecution.Contract.SYNC)) {
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
            builder.beginControlFlow(".doOnSuccess(_result -> ", new Object[0]);
            if (!MethodUtils.isMonoVoid((ExecutableElement)method)) {
                if (isOptional) {
                    builder.beginControlFlow("if(_result.isPresent())", new Object[0]);
                } else {
                    builder.beginControlFlow("if(_result != null)", new Object[0]);
                }
            }
            builder.add(this.getSyncBlock(method, operation));
            if (!MethodUtils.isMonoVoid((ExecutableElement)method)) {
                builder.endControlFlow();
            }
            builder.endControlFlow(")", new Object[0]);
        } else if (operation.executions().size() > 1) {
            CacheOperation.CacheExecution cache;
            int i;
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                boolean prevKeyMatch = false;
                for (int j = 0; j < i; ++j) {
                    CacheOperation.CacheExecution prevCachePut = operation.executions().get(j);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                    prevKeyMatch = true;
                    break;
                }
                if (prevKeyMatch) continue;
                String keyField = "_key" + (i + 1);
                builder.addStatement("var $L = $L", new Object[]{keyField, cache.cacheKey().code()});
            }
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
            if (MethodUtils.isMonoVoid((ExecutableElement)method)) {
                builder.add(".then(\n", new Object[0]).indent();
            } else {
                builder.add(".flatMap(_result -> \n", new Object[0]).indent();
            }
            builder.add("$T.merge(\n", new Object[]{CommonClassNames.flux});
            for (i = 0; i < operation.executions().size(); ++i) {
                cache = operation.executions().get(i);
                String keyField = "_key" + (i + 1);
                for (int i1 = 0; i1 < i; ++i1) {
                    CacheOperation.CacheExecution prevCache = operation.executions().get(i1);
                    if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCache.cacheKey().type())) continue;
                    keyField = "_key" + (i1 + 1);
                }
                String template = cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC ? (i == operation.executions().size() - 1 ? "$T.fromCompletionStage(() -> $L.invalidateAsync($L))\n" : "$T.fromCompletionStage(() -> $L.invalidateAsync($L)),\n") : (i == operation.executions().size() - 1 ? "$T.fromRunnable(() -> $L.invalidate($L))\n" : "$T.fromRunnable(() -> $L.invalidate($L)),\n");
                builder.add("\t", new Object[0]).add(template, new Object[]{CommonClassNames.mono, cache.field(), keyField});
            }
            if (MethodUtils.isMonoVoid((ExecutableElement)method)) {
                builder.add(").then()\n", new Object[0]).unindent().addStatement(")", new Object[0]);
            } else {
                builder.add(").then($T.just(_result))\n", new Object[]{CommonClassNames.mono}).unindent().addStatement(")", new Object[0]);
            }
        } else {
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
            builder.add(".doOnSuccess(_result -> $L.invalidate($L));", new Object[]{operation.executions().get(0).field(), operation.executions().get(0).cacheKey().code()});
        }
        return builder.build();
    }

    private CodeBlock buildBodyMonoAll(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        TypeMirror completionType = ((DeclaredType)method.getReturnType()).getTypeArguments().get(0);
        boolean isOptional = CommonUtils.isOptional((TypeMirror)completionType);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
        if (operation.executions().stream().allMatch(e -> e.contract() == CacheOperation.CacheExecution.Contract.SYNC)) {
            builder.beginControlFlow(".doOnSuccess(_result -> ", new Object[0]);
            if (!MethodUtils.isMonoVoid((ExecutableElement)method)) {
                if (isOptional) {
                    builder.beginControlFlow("if(_result.isPresent())", new Object[0]);
                } else {
                    builder.beginControlFlow("if(_result != null)", new Object[0]);
                }
            }
            for (CacheOperation.CacheExecution cache : operation.executions()) {
                builder.addStatement("$L.invalidateAll()", new Object[]{cache.field()});
            }
            if (!MethodUtils.isMonoVoid((ExecutableElement)method)) {
                builder.endControlFlow();
            }
            builder.endControlFlow(")", new Object[0]);
            return builder.build();
        }
        if (operation.executions().size() > 1) {
            if (MethodUtils.isMonoVoid((ExecutableElement)method)) {
                builder.add(".then(\n", new Object[0]).indent();
            } else {
                builder.add(".flatMap(_result -> \n", new Object[0]).indent();
            }
            builder.add("$T.merge(\n", new Object[]{CommonClassNames.flux});
            for (int i = 0; i < operation.executions().size(); ++i) {
                CacheOperation.CacheExecution cache = operation.executions().get(i);
                String template = cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC ? (i == operation.executions().size() - 1 ? "$T.fromCompletionStage(() -> $L.invalidateAllAsync())\n" : "$T.fromCompletionStage(() -> $L.invalidateAllAsync()),\n") : (i == operation.executions().size() - 1 ? "$T.fromRunnable(() -> $L.invalidateAll())\n" : "$T.fromRunnable(() -> $L.invalidateAll()),\n");
                builder.add("\t", new Object[0]).add(template, new Object[]{CommonClassNames.mono, cache.field()});
            }
            if (MethodUtils.isMonoVoid((ExecutableElement)method)) {
                builder.add(").then()\n", new Object[0]).unindent().addStatement(")", new Object[0]);
            } else {
                builder.add(").then($T.just(_result))\n", new Object[]{CommonClassNames.mono}).unindent().addStatement(")", new Object[0]);
            }
        } else {
            builder.add(".doOnSuccess(_result -> ", new Object[0]).add(operation.executions().get(0).field(), new Object[0]).add(".invalidateAll());\n", new Object[0]);
        }
        return builder.build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("return $L\n", new Object[]{superMethod});
        if (operation.executions().stream().allMatch(e -> e.contract() == CacheOperation.CacheExecution.Contract.SYNC)) {
            builder.beginControlFlow(".thenApply(_result -> ", new Object[0]);
            builder.add(this.getSyncBlock(method, operation));
            builder.addStatement("return _result", new Object[0]).endControlFlow(")", new Object[0]);
            return builder.build();
        }
        builder.indent().beginControlFlow(".thenCompose(_value ->", new Object[0]);
        for (int i = 0; i < operation.executions().size(); ++i) {
            CacheOperation.CacheExecution cache = operation.executions().get(i);
            boolean prevKeyMatch = false;
            for (int j = 0; j < i; ++j) {
                CacheOperation.CacheExecution prevCachePut = operation.executions().get(j);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                prevKeyMatch = true;
                break;
            }
            if (prevKeyMatch) continue;
            String keyField = "_key" + (i + 1);
            builder.add("var $L = ", new Object[]{keyField}).addStatement(cache.cacheKey().code());
        }
        CodeBlock.Builder allBuilder = CodeBlock.builder();
        allBuilder.add("return $T.allOf(\n", new Object[]{CompletableFuture.class});
        for (int i = 0; i < operation.executions().size(); ++i) {
            if (i != 0 && operation.executions().get(i - 1).contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                allBuilder.add(",\n", new Object[0]);
            }
            CacheOperation.CacheExecution cache = operation.executions().get(i);
            String putKeyField = "_key" + (i + 1);
            for (int i1 = 0; i1 < i; ++i1) {
                CacheOperation.CacheExecution prevCachePut = operation.executions().get(i1);
                if (!this.env.getTypeUtils().isSubtype(cache.cacheKey().type(), prevCachePut.cacheKey().type())) continue;
                putKeyField = "_key" + (i1 + 1);
            }
            if (cache.contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                allBuilder.add("\t$L.invalidateAsync($L).toCompletableFuture()", new Object[]{cache.field(), putKeyField});
                continue;
            }
            builder.addStatement("$L.invalidate($L)", new Object[]{cache.field(), putKeyField});
        }
        builder.add(allBuilder.build()).add("\n).thenApply(_v -> _value);\n", new Object[0]);
        return builder.endControlFlow(")", new Object[0]).unindent().build();
    }

    private CodeBlock buildBodyFutureAll(ExecutableElement method, CacheOperation operation, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("return $L\n", new Object[]{superMethod});
        if (operation.executions().stream().allMatch(e -> e.contract() == CacheOperation.CacheExecution.Contract.SYNC)) {
            builder.beginControlFlow(".thenApply(_result -> ", new Object[0]);
            for (CacheOperation.CacheExecution cache : operation.executions()) {
                builder.addStatement("$L.invalidateAll()", new Object[]{cache.field()});
            }
            builder.addStatement("return _result", new Object[0]).endControlFlow(")", new Object[0]);
            return builder.build();
        }
        builder.indent().beginControlFlow(".thenCompose(_value ->", new Object[0]);
        CodeBlock.Builder allBuilder = CodeBlock.builder();
        allBuilder.add("return $T.allOf(\n", new Object[]{CompletableFuture.class});
        for (int i = 0; i < operation.executions().size(); ++i) {
            CacheOperation.CacheExecution cache;
            if (i != 0 && operation.executions().get(i - 1).contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                allBuilder.add(",\n", new Object[0]);
            }
            if ((cache = operation.executions().get(i)).contract() == CacheOperation.CacheExecution.Contract.ASYNC) {
                allBuilder.add("\t$L.invalidateAllAsync().toCompletableFuture()", new Object[]{cache.field()});
                continue;
            }
            builder.addStatement("$L.invalidateAll()", new Object[]{cache.field()});
        }
        builder.add(allBuilder.build()).add("\n).thenApply(_v -> _value);\n", new Object[0]);
        return builder.endControlFlow(")", new Object[0]).unindent().build();
    }
}

