/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;

public final class CacheOperationUtils {
    private static final ClassName KEY_MAPPER_1 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[0]);
    private static final ClassName KEY_MAPPER_2 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper2"});
    private static final ClassName KEY_MAPPER_3 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper3"});
    private static final ClassName KEY_MAPPER_4 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper4"});
    private static final ClassName KEY_MAPPER_5 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper5"});
    private static final ClassName KEY_MAPPER_6 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper6"});
    private static final ClassName KEY_MAPPER_7 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper7"});
    private static final ClassName KEY_MAPPER_8 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper8"});
    private static final ClassName KEY_MAPPER_9 = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKeyMapper", (String[])new String[]{"CacheKeyMapper9"});
    private static final ClassName CACHE_ASYNC = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"AsyncCache", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHEABLE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheable", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHEABLES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheables", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_PUT = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePut", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_PUTS = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePuts", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_INVALIDATE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidate", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_INVALIDATES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidates", (String[])new String[0]);
    private static final Set<String> CACHE_ANNOTATIONS = Set.of(ANNOTATION_CACHEABLE.canonicalName(), ANNOTATION_CACHEABLES.canonicalName(), ANNOTATION_CACHE_PUT.canonicalName(), ANNOTATION_CACHE_PUTS.canonicalName(), ANNOTATION_CACHE_INVALIDATE.canonicalName(), ANNOTATION_CACHE_INVALIDATES.canonicalName());

    private CacheOperationUtils() {
    }

    public static CacheOperation getCacheOperation(ExecutableElement method, ProcessingEnvironment env, KoraAspect.AspectContext aspectContext) {
        List<AnnotationMirror> cacheables = CacheOperationUtils.getRepeatedAnnotations(method, ANNOTATION_CACHEABLE.canonicalName(), ANNOTATION_CACHEABLES.canonicalName());
        List<AnnotationMirror> puts = CacheOperationUtils.getRepeatedAnnotations(method, ANNOTATION_CACHE_PUT.canonicalName(), ANNOTATION_CACHE_PUTS.canonicalName());
        List<AnnotationMirror> invalidates = CacheOperationUtils.getRepeatedAnnotations(method, ANNOTATION_CACHE_INVALIDATE.canonicalName(), ANNOTATION_CACHE_INVALIDATES.canonicalName());
        String className = method.getEnclosingElement().getSimpleName().toString();
        String methodName = method.getSimpleName().toString();
        CacheOperation.Origin origin = new CacheOperation.Origin(className, methodName);
        if (!cacheables.isEmpty()) {
            if (!puts.isEmpty() || !invalidates.isEmpty()) {
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Method must have Cache annotations with same operation type, but got multiple different operation types for " + origin, (Element)method));
            }
            return CacheOperationUtils.getOperation(method, cacheables, CacheOperation.Type.GET, env, aspectContext);
        }
        if (!puts.isEmpty()) {
            if (!invalidates.isEmpty()) {
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Method must have Cache annotations with same operation type, but got multiple different operation types for " + origin, (Element)method));
            }
            return CacheOperationUtils.getOperation(method, puts, CacheOperation.Type.PUT, env, aspectContext);
        }
        if (!invalidates.isEmpty()) {
            boolean allInvalidateAll;
            List<Boolean> invalidateAlls = invalidates.stream().flatMap(a -> a.getElementValues().entrySet().stream()).filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("invalidateAll")).map(e -> (boolean)((Boolean)((AnnotationValue)e.getValue()).getValue())).toList();
            boolean anyInvalidateAll = !invalidateAlls.isEmpty() && invalidateAlls.stream().anyMatch(v -> v);
            boolean bl = allInvalidateAll = !invalidateAlls.isEmpty() && invalidateAlls.stream().allMatch(v -> v);
            if (anyInvalidateAll && !allInvalidateAll) {
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, ANNOTATION_CACHE_INVALIDATE.canonicalName() + " not all annotations are marked 'invalidateAll' out of all for " + origin, (Element)method));
            }
            CacheOperation.Type type = allInvalidateAll ? CacheOperation.Type.EVICT_ALL : CacheOperation.Type.EVICT;
            return CacheOperationUtils.getOperation(method, invalidates, type, env, aspectContext);
        }
        throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "None of " + CACHE_ANNOTATIONS + " cache annotations found", (Element)method));
    }

    private static CacheOperation getOperation(ExecutableElement method, List<AnnotationMirror> cacheAnnotations, CacheOperation.Type type, ProcessingEnvironment env, KoraAspect.AspectContext aspectContext) {
        String className = method.getEnclosingElement().getSimpleName().toString();
        String methodName = method.getSimpleName().toString();
        CacheOperation.Origin origin = new CacheOperation.Origin(className, methodName);
        ArrayList<List<Object>> cacheKeyArguments = new ArrayList<List<Object>>();
        ArrayList<CacheOperation.CacheExecution> cacheExecutions = new ArrayList<CacheOperation.CacheExecution>();
        for (AnnotationMirror annotation : cacheAnnotations) {
            CacheOperation.CacheKey cacheKey;
            List<Object> parameters = annotation.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("parameters")).map(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().filter(a -> a instanceof AnnotationValue).map(a -> ((AnnotationValue)a).getValue().toString()).toList()).findFirst().orElse(Collections.emptyList());
            if (parameters.isEmpty()) {
                parameters = method.getParameters().stream().map(p -> p.getSimpleName().toString()).toList();
            } else {
                for (String string : parameters) {
                    if (!method.getParameters().stream().noneMatch(p -> p.getSimpleName().contentEquals(parameter))) continue;
                    throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Unknown method parameter is declared: " + string, (Element)method));
                }
            }
            for (List list : cacheKeyArguments) {
                if (list.equals(parameters)) continue;
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, annotation.getClass() + " parameters mismatch for different annotations for: " + origin, (Element)method));
            }
            cacheKeyArguments.add(parameters);
            String cacheImpl = annotation.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst().orElseThrow();
            TypeElement typeElement = env.getElementUtils().getTypeElement(cacheImpl);
            String fieldCache = aspectContext.fieldFactory().constructorParam(typeElement.asType(), List.of());
            List<? extends TypeMirror> superTypes = env.getTypeUtils().directSupertypes(typeElement.asType());
            DeclaredType superType = (DeclaredType)superTypes.get(superTypes.size() - 1);
            DeclaredType cacheKeyMirror = MethodUtils.getGenericType((TypeMirror)superType).map(t -> (DeclaredType)t).orElseThrow();
            CommonUtils.MappingData mapper = CacheOperationUtils.getSuitableMapper(CommonUtils.parseMapping((Element)method));
            if (mapper != null) {
                List tags = mapper.mapperTags().isEmpty() ? List.of() : List.of(TagUtils.makeAnnotationSpec((Set)mapper.mapperTags()));
                String fieldMapper = aspectContext.fieldFactory().constructorParam(mapper.mapperClass(), tags);
                cacheKey = new CacheOperation.CacheKey(cacheKeyMirror, CodeBlock.of((String)"$L.map($L)", (Object[])new Object[]{fieldMapper, String.join((CharSequence)", ", parameters)}));
            } else if (parameters.size() == 1) {
                cacheKey = new CacheOperation.CacheKey(cacheKeyMirror, CodeBlock.of((String)((String)parameters.get(0)), (Object[])new Object[0]));
            } else if (type == CacheOperation.Type.EVICT_ALL) {
                cacheKey = new CacheOperation.CacheKey(null, null);
            } else {
                List<VariableElement> parameterResult = parameters.stream().flatMap(param -> method.getParameters().stream().filter(p -> p.getSimpleName().contentEquals((CharSequence)param))).map(p -> p).toList();
                Optional<ExecutableElement> keyConstructor = CacheOperationUtils.findKeyConstructor(cacheKeyMirror, parameterResult, env.getTypeUtils());
                if (keyConstructor.isPresent()) {
                    cacheKey = new CacheOperation.CacheKey(cacheKeyMirror, CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{cacheKeyMirror, String.join((CharSequence)", ", parameters)}));
                } else {
                    if (parameters.size() > 9) {
                        throw new ProcessingErrorException("@%s doesn't support more than 9 method arguments for Cache Key".formatted(annotation.getAnnotationType().asElement().getSimpleName()), (Element)method);
                    }
                    if (parameters.isEmpty() && (type == CacheOperation.Type.GET || type == CacheOperation.Type.EVICT)) {
                        throw new ProcessingErrorException("@%s requires minimum 1 Cache Key method argument, but got 0".formatted(annotation.getAnnotationType().asElement().getSimpleName().toString()), (Element)method);
                    }
                    DeclaredType mapperType = CacheOperationUtils.getKeyMapper(cacheKeyMirror, parameterResult, env);
                    String fieldMapper = aspectContext.fieldFactory().constructorParam((TypeMirror)mapperType, List.of());
                    cacheKey = new CacheOperation.CacheKey(cacheKeyMirror, CodeBlock.of((String)"$L.map($L)", (Object[])new Object[]{fieldMapper, String.join((CharSequence)", ", parameters)}));
                }
            }
            CacheOperation.CacheExecution.Contract contractType = CacheOperation.CacheExecution.Contract.SYNC;
            if (env.getTypeUtils().directSupertypes(superType).stream().anyMatch(t -> {
                DeclaredType dt;
                return t instanceof DeclaredType && (dt = (DeclaredType)t).asElement().toString().equals(CACHE_ASYNC.canonicalName());
            })) {
                contractType = CacheOperation.CacheExecution.Contract.ASYNC;
            }
            cacheExecutions.add(new CacheOperation.CacheExecution(fieldCache, typeElement, superType, contractType, cacheKey));
        }
        return new CacheOperation(type, cacheExecutions, origin);
    }

    @Nullable
    private static CommonUtils.MappingData getSuitableMapper(CommonUtils.MappersData mappers) {
        if (mappers.isEmpty() || mappers.mapperClasses() == null) {
            return null;
        }
        return Stream.of(mappers.getMapping(KEY_MAPPER_1), mappers.getMapping(KEY_MAPPER_2), mappers.getMapping(KEY_MAPPER_3), mappers.getMapping(KEY_MAPPER_4), mappers.getMapping(KEY_MAPPER_5), mappers.getMapping(KEY_MAPPER_6), mappers.getMapping(KEY_MAPPER_7), mappers.getMapping(KEY_MAPPER_8), mappers.getMapping(KEY_MAPPER_9)).filter(Objects::nonNull).filter(m -> m.mapperClass() != null).findFirst().orElse(null);
    }

    private static DeclaredType getKeyMapper(DeclaredType cacheKeyMirror, List<VariableElement> parameters, ProcessingEnvironment env) {
        ClassName mapper = switch (parameters.size()) {
            case 1 -> KEY_MAPPER_1;
            case 2 -> KEY_MAPPER_2;
            case 3 -> KEY_MAPPER_3;
            case 4 -> KEY_MAPPER_4;
            case 5 -> KEY_MAPPER_5;
            case 6 -> KEY_MAPPER_6;
            case 7 -> KEY_MAPPER_7;
            case 8 -> KEY_MAPPER_8;
            case 9 -> KEY_MAPPER_9;
            default -> throw new ProcessingErrorException("Cache doesn't support %s parameters for Cache Key".formatted(parameters.size()), (Element)parameters.get(0));
        };
        ArrayList<DeclaredType> args = new ArrayList<DeclaredType>();
        args.add(cacheKeyMirror);
        parameters.forEach(a -> args.add((DeclaredType)a.asType()));
        TypeElement mapperElement = env.getElementUtils().getTypeElement(mapper.canonicalName());
        return env.getTypeUtils().getDeclaredType(mapperElement, (TypeMirror[])args.toArray(TypeMirror[]::new));
    }

    private static Optional<ExecutableElement> findKeyConstructor(DeclaredType type, List<VariableElement> parameters, Types types) {
        VariableElement constructorParam;
        VariableElement methodParam;
        int i;
        boolean isCandidate;
        List<? extends VariableElement> constructorParams;
        List<ExecutableElement> constructors = type.asElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> (ExecutableElement)e).filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).filter(c -> c.getParameters().size() == parameters.size()).toList();
        if (constructors.isEmpty()) {
            return Optional.empty();
        }
        for (ExecutableElement constructor : constructors) {
            constructorParams = constructor.getParameters();
            isCandidate = true;
            for (i = 0; i < parameters.size(); ++i) {
                methodParam = parameters.get(i);
                constructorParam = constructorParams.get(i);
                if (types.isSameType(methodParam.asType(), constructorParam.asType())) continue;
                isCandidate = false;
                break;
            }
            if (!isCandidate) continue;
            return Optional.of(constructor);
        }
        for (ExecutableElement constructor : constructors) {
            constructorParams = constructor.getParameters();
            isCandidate = true;
            for (i = 0; i < parameters.size(); ++i) {
                methodParam = parameters.get(i);
                constructorParam = constructorParams.get(i);
                if (types.isSubtype(methodParam.asType(), constructorParam.asType())) continue;
                isCandidate = false;
                break;
            }
            if (!isCandidate) continue;
            return Optional.of(constructor);
        }
        return Optional.empty();
    }

    private static List<AnnotationMirror> getRepeatedAnnotations(Element element, String annotation, String parentAnnotation) {
        List<AnnotationMirror> repeated = element.getAnnotationMirrors().stream().filter(pa -> pa.getAnnotationType().toString().contentEquals(parentAnnotation)).flatMap(pa -> pa.getElementValues().entrySet().stream()).flatMap(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().map(AnnotationMirror.class::cast)).filter(a -> a.getAnnotationType().toString().contentEquals(annotation)).toList();
        if (!repeated.isEmpty()) {
            return repeated;
        }
        return element.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().contentEquals(annotation)).map(a -> a).toList();
    }
}

