/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.common.DefaultComponent;

public class CacheAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z][0-9a-zA-Z_]*");
    private static final ClassName ANNOTATION_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cache", (String[])new String[0]);
    private static final ClassName CAFFEINE_TELEMETRY = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCacheTelemetry", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCache", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE_FACTORY = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCacheFactory", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE_CONFIG = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCacheConfig", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE_IMPL = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"AbstractCaffeineCache", (String[])new String[0]);
    private static final ClassName REDIS_TELEMETRY = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheTelemetry", (String[])new String[0]);
    private static final ClassName REDIS_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCache", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_IMPL = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"AbstractRedisCache", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_CONFIG = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheConfig", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_CLIENT = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheClient", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_MAPPER_KEY = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheKeyMapper", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_MAPPER_VALUE = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheValueMapper", (String[])new String[0]);

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHE.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement cacheAnnotation = this.processingEnv.getElementUtils().getTypeElement(ANNOTATION_CACHE.canonicalName());
        if (cacheAnnotation == null) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(cacheAnnotation)) {
            if (!element.getKind().isInterface()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@Cache annotation is intended to be used on interfaces, but was: " + element.getKind().name(), element);
                continue;
            }
            TypeElement cacheContract = (TypeElement)element;
            ParameterizedTypeName cacheContractType = this.getCacheSuperType(cacheContract);
            if (cacheContractType == null) continue;
            String packageName = this.getPackage(cacheContract);
            ClassName cacheContractClassName = ClassName.get((TypeElement)cacheContract);
            String configPath = CacheAnnotationProcessor.getCacheTypeConfigPath(cacheContract);
            if (!NAME_PATTERN.matcher(configPath).find()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cache config path doesn't match pattern: " + NAME_PATTERN, cacheContract);
                continue;
            }
            TypeName cacheImplBase = this.getCacheImplBase(cacheContract, cacheContractType);
            TypeSpec implSpec = TypeSpec.classBuilder((ClassName)CacheAnnotationProcessor.getCacheImpl(cacheContract)).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{CacheAnnotationProcessor.class.getCanonicalName()})).build()).addMethod(this.getCacheConstructor(configPath, cacheContractType)).superclass(cacheImplBase).addSuperinterface(cacheContract.asType()).build();
            try {
                DeclaredType dt;
                List<? extends TypeMirror> superTypes;
                TypeMirror superType;
                TypeMirror keyType;
                JavaFile implFile = JavaFile.builder((String)cacheContractClassName.packageName(), (TypeSpec)implSpec).build();
                implFile.writeTo(this.processingEnv.getFiler());
                TypeSpec.Builder moduleSpecBuilder = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)packageName, (String)"$%sModule".formatted(cacheContractClassName.simpleName()), (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{CacheAnnotationProcessor.class.getCanonicalName()})).build()).addAnnotation(CommonClassNames.module).addMethod(this.getCacheMethodImpl(cacheContract, cacheContractType)).addMethod(this.getCacheMethodConfig(cacheContract, cacheContractType));
                if (cacheContractType.rawType.equals((Object)REDIS_CACHE) && (keyType = ((DeclaredType)(superType = (superTypes = this.processingEnv.getTypeUtils().directSupertypes(cacheContract.asType())).get(superTypes.size() - 1))).getTypeArguments().get(0)) instanceof DeclaredType && (dt = (DeclaredType)keyType).asElement().getKind() == ElementKind.RECORD) {
                    moduleSpecBuilder.addMethod(this.getCacheRedisKeyMapperForRecord(dt));
                }
                TypeSpec moduleSpec = moduleSpecBuilder.build();
                JavaFile moduleFile = JavaFile.builder((String)cacheContractClassName.packageName(), (TypeSpec)moduleSpec).build();
                moduleFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Nullable
    private ParameterizedTypeName getCacheSuperType(TypeElement candidate) {
        List<? extends TypeMirror> interfaces = candidate.getInterfaces();
        if (interfaces.size() != 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Cache annotated interface should implement one one interface and it should be one of: %s, %s".formatted(REDIS_CACHE.canonicalName(), CAFFEINE_CACHE.canonicalName()));
            return null;
        }
        DeclaredType superinterface = (DeclaredType)interfaces.get(0);
        TypeElement superinterfaceElement = (TypeElement)superinterface.asElement();
        if (superinterfaceElement.getQualifiedName().contentEquals(CAFFEINE_CACHE.canonicalName())) {
            return (ParameterizedTypeName)TypeName.get((TypeMirror)superinterface);
        }
        if (superinterfaceElement.getQualifiedName().contentEquals(REDIS_CACHE.canonicalName())) {
            return (ParameterizedTypeName)TypeName.get((TypeMirror)superinterface);
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "@Cache is expected to be known super type %s or %s, but was %s".formatted(REDIS_CACHE.canonicalName(), CAFFEINE_CACHE.canonicalName(), superinterface));
        return null;
    }

    private TypeName getCacheImplBase(TypeElement cacheContract, ParameterizedTypeName cacheType) {
        if (cacheType.rawType.equals((Object)CAFFEINE_CACHE)) {
            return ParameterizedTypeName.get((ClassName)CAFFEINE_CACHE_IMPL, (TypeName[])new TypeName[]{(TypeName)cacheType.typeArguments.get(0), (TypeName)cacheType.typeArguments.get(1)});
        }
        if (cacheType.rawType.equals((Object)REDIS_CACHE)) {
            return ParameterizedTypeName.get((ClassName)REDIS_CACHE_IMPL, (TypeName[])new TypeName[]{(TypeName)cacheType.typeArguments.get(0), (TypeName)cacheType.typeArguments.get(1)});
        }
        throw new UnsupportedOperationException("Unknown type: " + cacheContract.getQualifiedName());
    }

    private static String getCacheTypeConfigPath(TypeElement cacheContract) {
        AnnotationMirror cacheAnnotation = Objects.requireNonNull(AnnotationUtils.findAnnotation((Element)cacheContract, (ClassName)ANNOTATION_CACHE));
        return Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)cacheAnnotation, (String)"value"));
    }

    private MethodSpec getCacheMethodConfig(TypeElement cacheContract, ParameterizedTypeName cacheType) {
        ClassName returnType;
        String configPath = CacheAnnotationProcessor.getCacheTypeConfigPath(cacheContract);
        ClassName cacheContractName = ClassName.get((TypeElement)cacheContract);
        String methodName = "%s_Config".formatted(cacheContractName.simpleName());
        if (cacheType.rawType.equals((Object)CAFFEINE_CACHE)) {
            returnType = CAFFEINE_CACHE_CONFIG;
        } else if (cacheType.rawType.equals((Object)REDIS_CACHE)) {
            returnType = REDIS_CACHE_CONFIG;
        } else {
            throw new IllegalArgumentException("Unknown cache type: " + cacheType.rawType);
        }
        ParameterizedTypeName extractorType = ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{returnType});
        return MethodSpec.methodBuilder((String)methodName).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", "$T.class", new Object[]{cacheContractName}).build()).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)extractorType, "extractor", new Modifier[0]).addStatement("return extractor.extract(config.get($S))", new Object[]{configPath}).returns((TypeName)returnType).build();
    }

    private MethodSpec getCacheRedisKeyMapperForRecord(DeclaredType keyType) {
        ArrayList<String> methodNameBuilder = new ArrayList<String>();
        Element nextType = keyType.asElement();
        while (nextType.getKind() != ElementKind.PACKAGE) {
            methodNameBuilder.add(nextType.getSimpleName().toString());
            nextType = nextType.getEnclosingElement();
        }
        Collections.reverse(methodNameBuilder);
        String prefix = String.join((CharSequence)"_", methodNameBuilder);
        String methodName = "%s_RedisKeyMapper".formatted(prefix);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addAnnotation(DefaultComponent.class);
        List<Element> recordFields = keyType.asElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.RECORD_COMPONENT).toList();
        CodeBlock.Builder keyBuilder = CodeBlock.builder();
        CodeBlock.Builder compositeKeyBuilder = CodeBlock.builder();
        CodeBlock.Builder copyBuilder = CodeBlock.builder();
        copyBuilder.addStatement("var offset = 0", new Object[0]);
        for (int i = 0; i < recordFields.size(); ++i) {
            Element recordField = recordFields.get(i);
            String mapperName = "keyMapper" + (i + 1);
            methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_KEY, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)recordField.asType())}), mapperName, new Modifier[0]);
            String keyName = "_key" + (i + 1);
            keyBuilder.addStatement("var $L = $L.apply($T.requireNonNull(key.$L(), $S))", new Object[]{keyName, mapperName, Objects.class, recordField.getSimpleName().toString(), "Cache key '%s' field '%s' must be non null".formatted(keyType.asElement().toString(), recordField.getSimpleName().toString())});
            if (i == 0) {
                compositeKeyBuilder.add("var _compositeKey = new byte[", new Object[0]);
                for (int j = 0; j < recordFields.size(); ++j) {
                    String compKeyName = "_key" + (j + 1);
                    if (j != 0) {
                        compositeKeyBuilder.add(" + $T.DELIMITER.length + $L.length", new Object[]{REDIS_CACHE_MAPPER_KEY, compKeyName});
                        continue;
                    }
                    compositeKeyBuilder.add("$L.length", new Object[]{compKeyName});
                }
                copyBuilder.addStatement("$T.arraycopy($L, 0, _compositeKey, 0, $L.length)", new Object[]{System.class, keyName, keyName});
                copyBuilder.addStatement("offset += $L.length", new Object[]{keyName});
                continue;
            }
            copyBuilder.addStatement("$T.arraycopy($T.DELIMITER, 0, _compositeKey, offset, $T.DELIMITER.length)", new Object[]{System.class, REDIS_CACHE_MAPPER_KEY, REDIS_CACHE_MAPPER_KEY});
            copyBuilder.addStatement("offset += $T.DELIMITER.length", new Object[]{REDIS_CACHE_MAPPER_KEY});
            copyBuilder.addStatement("$T.arraycopy($L, 0, _compositeKey, offset, $L.length)", new Object[]{System.class, keyName, keyName});
            if (i == recordFields.size() - 1) continue;
            copyBuilder.addStatement("offset += $L.length", new Object[]{keyName});
        }
        compositeKeyBuilder.addStatement("]", new Object[0]);
        copyBuilder.addStatement("return _compositeKey", new Object[0]);
        return methodBuilder.addCode(CodeBlock.builder().beginControlFlow("return key -> ", new Object[0]).add(keyBuilder.build()).add(compositeKeyBuilder.build()).add(copyBuilder.build()).endControlFlow().add(";", new Object[0]).build()).returns((TypeName)ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_KEY, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)keyType)})).build();
    }

    private static ClassName getCacheImpl(TypeElement cacheContract) {
        ClassName cacheImplName = ClassName.get((TypeElement)cacheContract);
        return ClassName.get((String)cacheImplName.packageName(), (String)"$%sImpl".formatted(cacheImplName.simpleName()), (String[])new String[0]);
    }

    private MethodSpec getCacheMethodImpl(TypeElement cacheContract, ParameterizedTypeName cacheType) {
        ClassName cacheImplName = CacheAnnotationProcessor.getCacheImpl(cacheContract);
        String methodName = "%s_Impl".formatted(cacheImplName.simpleName());
        if (cacheType.rawType.equals((Object)CAFFEINE_CACHE)) {
            return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)CAFFEINE_CACHE_CONFIG, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", "$T.class", new Object[]{cacheContract}).build()).build()).addParameter((TypeName)CAFFEINE_CACHE_FACTORY, "factory", new Modifier[0]).addParameter((TypeName)CAFFEINE_TELEMETRY, "telemetry", new Modifier[0]).addStatement("return new $T(config, factory, telemetry)", new Object[]{cacheImplName}).returns(TypeName.get((TypeMirror)cacheContract.asType())).build();
        }
        if (cacheType.rawType.equals((Object)REDIS_CACHE)) {
            TypeName keyType = (TypeName)cacheType.typeArguments.get(0);
            TypeName valueType = (TypeName)cacheType.typeArguments.get(1);
            ParameterizedTypeName keyMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_KEY, (TypeName[])new TypeName[]{keyType});
            ParameterizedTypeName valueMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_VALUE, (TypeName[])new TypeName[]{valueType});
            DeclaredType cacheDeclaredType = cacheContract.getInterfaces().stream().filter(i -> ClassName.get((TypeMirror)i).equals((Object)cacheType)).map(i -> (DeclaredType)i).findFirst().orElseThrow();
            ParameterSpec.Builder valueParamBuilder = ParameterSpec.builder((TypeName)valueMapperType, (String)"valueMapper", (Modifier[])new Modifier[0]);
            Set valueTags = TagUtils.parseTagValue((AnnotatedConstruct)cacheDeclaredType.getTypeArguments().get(1));
            if (!valueTags.isEmpty()) {
                valueParamBuilder.addAnnotation(TagUtils.makeAnnotationSpec((Set)valueTags));
            }
            ParameterSpec.Builder keyParamBuilder = ParameterSpec.builder((TypeName)keyMapperType, (String)"keyMapper", (Modifier[])new Modifier[0]);
            Set keyTags = TagUtils.parseTagValue((AnnotatedConstruct)cacheDeclaredType.getTypeArguments().get(0));
            if (!keyTags.isEmpty()) {
                keyParamBuilder.addAnnotation(TagUtils.makeAnnotationSpec((Set)keyTags));
            }
            return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)REDIS_CACHE_CONFIG, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", "$T.class", new Object[]{cacheContract}).build()).build()).addParameter((TypeName)REDIS_CACHE_CLIENT, "redisClient", new Modifier[0]).addParameter((TypeName)REDIS_TELEMETRY, "telemetry", new Modifier[0]).addParameter(keyParamBuilder.build()).addParameter(valueParamBuilder.build()).addStatement("return new $T(config, redisClient, telemetry, keyMapper, valueMapper)", new Object[]{cacheImplName}).returns(TypeName.get((TypeMirror)cacheContract.asType())).build();
        }
        throw new IllegalArgumentException("Unknown cache type: " + cacheType.rawType);
    }

    private MethodSpec getCacheConstructor(String configPath, ParameterizedTypeName cacheContract) {
        if (cacheContract.rawType.equals((Object)CAFFEINE_CACHE)) {
            return MethodSpec.constructorBuilder().addParameter((TypeName)CAFFEINE_CACHE_CONFIG, "config", new Modifier[0]).addParameter((TypeName)CAFFEINE_CACHE_FACTORY, "factory", new Modifier[0]).addParameter((TypeName)CAFFEINE_TELEMETRY, "telemetry", new Modifier[0]).addStatement("super($S, config, factory, telemetry)", new Object[]{configPath}).build();
        }
        if (cacheContract.rawType.equals((Object)REDIS_CACHE)) {
            TypeName keyType = (TypeName)cacheContract.typeArguments.get(0);
            TypeName valueType = (TypeName)cacheContract.typeArguments.get(1);
            ParameterizedTypeName keyMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_KEY, (TypeName[])new TypeName[]{keyType});
            ParameterizedTypeName valueMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_VALUE, (TypeName[])new TypeName[]{valueType});
            return MethodSpec.constructorBuilder().addParameter((TypeName)REDIS_CACHE_CONFIG, "config", new Modifier[0]).addParameter((TypeName)REDIS_CACHE_CLIENT, "redisClient", new Modifier[0]).addParameter((TypeName)REDIS_TELEMETRY, "telemetry", new Modifier[0]).addParameter((TypeName)keyMapperType, "keyMapper", new Modifier[0]).addParameter((TypeName)valueMapperType, "valueMapper", new Modifier[0]).addStatement("super($S, config, redisClient, telemetry, keyMapper, valueMapper)", new Object[]{configPath}).build();
        }
        throw new IllegalArgumentException("Unknown cache type: " + cacheContract.rawType);
    }

    private String getPackage(Element element) {
        return this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }
}

