/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.PrimitiveType;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperationUtils;
import ru.tinkoff.kora.cache.annotation.processor.aop.AbstractAopCacheAspect;

public class CacheableAopKoraAspect
extends AbstractAopCacheAspect {
    private static final ClassName ANNOTATION_CACHEABLE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheable", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHEABLES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheables", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CacheableAopKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHEABLE.canonicalName(), ANNOTATION_CACHEABLES.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        if (MethodUtils.isFuture((ExecutableElement)method)) {
            throw new ProcessingErrorException("@Cacheable can't be applied for types assignable from " + Future.class, (Element)method);
        }
        if (MethodUtils.isFlux((ExecutableElement)method)) {
            throw new ProcessingErrorException("@Cacheable can't be applied for types assignable from " + Flux.class, (Element)method);
        }
        CacheOperation operation = CacheOperationUtils.getCacheMeta(method);
        List<String> cacheFields = this.getCacheFields(operation, this.env, aspectContext);
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? this.buildBodyMono(method, operation, cacheFields, superCall) : this.buildBodySync(method, operation, cacheFields, superCall);
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        CodeBlock keyBlock;
        String superMethod = this.getSuperMethod(method, superCall);
        if (operation.parameters().size() == 1) {
            keyBlock = CodeBlock.builder().add("var _key = $L;\n", new Object[]{operation.parameters().get(0)}).build();
        } else {
            String recordParameters = this.getKeyRecordParameters(operation, method);
            keyBlock = CodeBlock.builder().add("var _key = $T.of($L);\n", new Object[]{this.getCacheKey(operation), recordParameters}).build();
        }
        boolean isOptional = MethodUtils.isOptional((ExecutableElement)method);
        if (operation.cacheImplementations().size() == 1) {
            if (isOptional) {
                return CodeBlock.builder().add(keyBlock).add(CodeBlock.of((String)"return $T.ofNullable($L.computeIfAbsent(_key, _k -> $L.orElse(null)));\n", (Object[])new Object[]{Optional.class, cacheFields.get(0), superMethod})).build();
            }
            return CodeBlock.builder().add(keyBlock).add(CodeBlock.of((String)"return $L.computeIfAbsent(_key, _k -> $L);\n", (Object[])new Object[]{cacheFields.get(0), superMethod})).build();
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < cacheFields.size(); ++i) {
            String cache = cacheFields.get(i);
            String prefix = i == 0 ? "var _value = " : "_value = ";
            builder.add(prefix, new Object[0]).add(cache, new Object[0]).add(".get(_key);\n", new Object[0]);
            builder.beginControlFlow("if(_value != null)", new Object[0]);
            for (int j = 0; j < i; ++j) {
                String cachePrevPut = cacheFields.get(j);
                builder.add("\t", new Object[0]).add(cachePrevPut, new Object[0]).add(".put(_key, _value);\n", new Object[0]);
            }
            if (isOptional) {
                builder.add("return $T.of(_value);", new Object[]{Optional.class});
            } else {
                builder.add("return _value;", new Object[0]);
            }
            builder.add("\n", new Object[0]);
            builder.endControlFlow();
            builder.add("\n", new Object[0]);
        }
        builder.add("var _result = ", new Object[0]).add(superMethod, new Object[0]).add(";\n", new Object[0]);
        boolean isPrimitive = method.getReturnType() instanceof PrimitiveType;
        if (isOptional) {
            builder.beginControlFlow("_result.ifPresent(_v ->", new Object[0]);
        } else if (!isPrimitive) {
            builder.beginControlFlow("if(_result != null)", new Object[0]);
        }
        for (String cache : cacheFields) {
            if (isOptional) {
                builder.add(cache, new Object[0]).add(".put(_key, _v);\n", new Object[0]);
                continue;
            }
            builder.add(cache, new Object[0]).add(".put(_key, _result);\n", new Object[0]);
        }
        if (isOptional) {
            builder.endControlFlow(")", new Object[0]);
        } else if (!isPrimitive) {
            builder.endControlFlow();
        }
        builder.add("return _result;", new Object[0]);
        return CodeBlock.builder().add(keyBlock).add(builder.build()).build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String cache;
        int i;
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        for (i = 0; i < cacheFields.size(); ++i) {
            cache = cacheFields.get(i);
            String prefix = i == 0 ? "var _value = " : "_value = _value.switchIfEmpty(";
            String getPart = ".getAsync(_key)";
            builder.add(prefix, new Object[0]).add(cache, new Object[0]).add(".getAsync(_key)", new Object[0]);
            if (i > 1) {
                builder.add("\n", new Object[0]).add("    .publishOn($T.boundedElastic())\n    .doOnSuccess(_fromCache -> {\n        if(_fromCache != null) {\n            $T.merge($T.of(\n", new Object[]{Schedulers.class, Flux.class, List.class});
                for (int j = 0; j < i; ++j) {
                    String prevCache = cacheFields.get(j);
                    String suffix = j == i - 1 ? ".putAsync(_key, _fromCache)\n" : ".putAsync(_key, _fromCache),\n";
                    builder.add("\t\t\t\t", new Object[0]).add(prevCache, new Object[0]).add(suffix, new Object[0]);
                }
                builder.add("\t\t)).then().block();\n}}));\n\n", new Object[0]);
                continue;
            }
            if (i == 1) {
                builder.add("\n\t", new Object[0]).add(String.format(".doOnSuccess(_fromCache -> {\n        if(_fromCache != null) {\n            %s.put(_key, _fromCache);\n        }\n}));\n", cacheFields.get(0)), new Object[0]).add("\n", new Object[0]);
                continue;
            }
            builder.add(";\n", new Object[0]);
        }
        builder.add("return _value.switchIfEmpty(", new Object[0]).add(superMethod, new Object[0]);
        if (cacheFields.size() > 1) {
            builder.add(".flatMap(_result -> $T.merge($T.of(\n", new Object[]{Flux.class, List.class});
            for (i = 0; i < cacheFields.size(); ++i) {
                cache = cacheFields.get(i);
                String suffix = i == cacheFields.size() - 1 ? ".putAsync(_key, _result)\n" : ".putAsync(_key, _result),\n";
                builder.add("\t", new Object[0]).add(cache, new Object[0]).add(suffix, new Object[0]);
            }
            builder.add(")).then(Mono.just(_result))));", new Object[0]);
        } else if (operation.parameters().size() == 1) {
            builder.add(".doOnSuccess(_result -> {\n    if(_result != null) {\n        $L.put($L, _result);\n    }\n}));\n", new Object[]{cacheFields.get(0), operation.parameters().get(0)});
        } else {
            String recordParameters = this.getKeyRecordParameters(operation, method);
            builder.add(".doOnSuccess(_result -> {\n    if(_result != null) {\n        $L.put($T.of($L), _result);\n    }\n}));\n", new Object[]{cacheFields.get(0), this.getCacheKey(operation), recordParameters});
        }
        if (operation.parameters().size() == 1) {
            return CodeBlock.builder().add("var _key = $L;\n", new Object[]{operation.parameters().get(0)}).add(builder.build()).build();
        }
        String recordParameters = this.getKeyRecordParameters(operation, method);
        return CodeBlock.builder().add("var _key = $T.of($L);\n", new Object[]{this.getCacheKey(operation), recordParameters}).add(builder.build()).build();
    }
}

