/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.PrimitiveType;
import reactor.core.publisher.Flux;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperationUtils;
import ru.tinkoff.kora.cache.annotation.processor.aop.AbstractAopCacheAspect;

public class CachePutAopKoraAspect
extends AbstractAopCacheAspect {
    private static final ClassName ANNOTATION_CACHE_PUT = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePut", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_PUTS = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePuts", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CachePutAopKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHE_PUT.canonicalName(), ANNOTATION_CACHE_PUTS.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        if (MethodUtils.isFuture((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CachePut can't be applied for types assignable from " + Future.class, (Element)method);
        }
        if (MethodUtils.isFlux((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CachePut can't be applied for types assignable from " + Flux.class, (Element)method);
        }
        CacheOperation operation = CacheOperationUtils.getCacheMeta(method);
        List<String> cacheFields = this.getCacheFields(operation, this.env, aspectContext);
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? this.buildBodyMono(method, operation, cacheFields, superCall) : this.buildBodySync(method, operation, cacheFields, superCall);
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("var _value = ", new Object[0]).add(superMethod, new Object[0]).add(";\n", new Object[0]);
        boolean isOptional = MethodUtils.isOptional((ExecutableElement)method);
        boolean isPrimitive = method.getReturnType() instanceof PrimitiveType;
        if (isOptional) {
            builder.beginControlFlow("_value.ifPresent(_v ->", new Object[0]);
        } else if (!isPrimitive) {
            builder.beginControlFlow("if(_value != null)", new Object[0]);
        }
        if (operation.parameters().size() == 1) {
            builder.add("var _key = $L;\n", new Object[]{operation.parameters().get(0)});
        } else {
            String recordParameters = this.getKeyRecordParameters(operation, method);
            builder.add("var _key = $T.of($L);\n", new Object[]{this.getCacheKey(operation), recordParameters});
        }
        for (String cache : cacheFields) {
            if (isOptional) {
                builder.add(cache, new Object[0]).add(".put(_key, _v);\n", new Object[0]);
                continue;
            }
            builder.add(cache, new Object[0]).add(".put(_key, _value);\n", new Object[0]);
        }
        if (isOptional) {
            builder.endControlFlow(")", new Object[0]);
        } else if (!isPrimitive) {
            builder.endControlFlow();
        }
        builder.add("return _value;", new Object[0]);
        return builder.build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        CodeBlock.Builder builder = CodeBlock.builder();
        if (cacheFields.size() > 1) {
            if (operation.parameters().size() == 1) {
                builder.add("var _key = $L;\n", new Object[]{operation.parameters().get(0)});
            } else {
                String recordParameters = this.getKeyRecordParameters(operation, method);
                builder.add("var _key = $T.of($L);\n", new Object[]{this.getCacheKey(operation), recordParameters});
            }
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]).add(".flatMap(_result -> $T.merge($T.of(\n", new Object[]{Flux.class, List.class});
            for (int i = 0; i < cacheFields.size(); ++i) {
                String cache = cacheFields.get(i);
                String suffix = i == cacheFields.size() - 1 ? ".putAsync(_key, _result)\n" : ".putAsync(_key, _result),\n";
                builder.add("\t", new Object[0]).add(cache, new Object[0]).add(suffix, new Object[0]);
            }
            builder.add(")).then(Mono.just(_result)));", new Object[0]);
        } else {
            builder.add("return ", new Object[0]).add(superMethod, new Object[0]);
            if (operation.parameters().size() == 1) {
                builder.add(".doOnSuccess(_result -> {\n    if(_result != null) {\n        $L.put($L, _result);\n    }\n});\n", new Object[]{cacheFields.get(0), operation.parameters().get(0)});
            } else {
                String recordParameters = this.getKeyRecordParameters(operation, method);
                builder.add(".doOnSuccess(_result -> {\n    if(_result != null) {\n        $L.put($T.of($L), _result);\n    }\n});\n", new Object[]{cacheFields.get(0), this.getCacheKey(operation), recordParameters});
            }
        }
        return builder.build();
    }
}

