/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import reactor.core.publisher.Flux;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperationUtils;
import ru.tinkoff.kora.cache.annotation.processor.aop.AbstractAopCacheAspect;

public class CacheInvalidateAopKoraAspect
extends AbstractAopCacheAspect {
    private static final ClassName ANNOTATION_CACHE_INVALIDATE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidate", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_INVALIDATES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidates", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CacheInvalidateAopKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHE_INVALIDATE.canonicalName(), ANNOTATION_CACHE_INVALIDATES.canonicalName());
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        if (MethodUtils.isFuture((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CacheInvalidate can't be applied for types assignable from " + Future.class, (Element)method);
        }
        if (MethodUtils.isFlux((ExecutableElement)method)) {
            throw new ProcessingErrorException("@CacheInvalidate can't be applied for types assignable from " + Flux.class, (Element)method);
        }
        CacheOperation operation = CacheOperationUtils.getCacheMeta(method);
        List<String> cacheFields = this.getCacheFields(operation, this.env, aspectContext);
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? (operation.type() == CacheOperation.Type.EVICT_ALL ? this.buildBodyMonoAll(method, operation, cacheFields, superCall) : this.buildBodyMono(method, operation, cacheFields, superCall)) : (operation.type() == CacheOperation.Type.EVICT_ALL ? this.buildBodySyncAll(method, operation, cacheFields, superCall) : this.buildBodySync(method, operation, cacheFields, superCall));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        StringBuilder builder = new StringBuilder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.append(superMethod).append(";\n");
        } else {
            builder.append("var value = ").append(superMethod).append(";\n");
        }
        for (String cache : cacheFields) {
            builder.append(cache).append(".invalidate(_key);\n");
        }
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.append("return;");
        } else {
            builder.append("return value;");
        }
        if (operation.parameters().size() == 1) {
            return CodeBlock.builder().add("var _key = $L;\n", new Object[]{operation.parameters().get(0)}).add(builder.toString(), new Object[0]).build();
        }
        String recordParameters = this.getKeyRecordParameters(operation, method);
        return CodeBlock.builder().add("var _key = $T.of($L);\n", new Object[]{this.getCacheKey(operation), recordParameters}).add(builder.toString(), new Object[0]).build();
    }

    private CodeBlock buildBodySyncAll(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        StringBuilder builder = new StringBuilder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.append(superMethod).append(";\n");
        } else {
            builder.append("var _value = ").append(superMethod).append(";\n");
        }
        for (String cache : cacheFields) {
            builder.append(cache).append(".invalidateAll();\n");
        }
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.append("return;");
        } else {
            builder.append("return _value;");
        }
        return CodeBlock.builder().add(builder.toString(), new Object[0]).build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        StringBuilder builder = new StringBuilder();
        builder.append("return ").append(superMethod);
        if (cacheFields.size() > 1) {
            builder.append(".publishOn(reactor.core.scheduler.Schedulers.boundedElastic()).doOnSuccess(_result -> reactor.core.publisher.Flux.merge(java.util.List.of(\n");
            for (int i = 0; i < cacheFields.size(); ++i) {
                String cache = cacheFields.get(i);
                String suffix = i == cacheFields.size() - 1 ? ".invalidateAsync(_key)\n" : ".invalidateAsync(_key),\n";
                builder.append("\t").append(cache).append(suffix);
            }
            builder.append(")).then().block());");
        } else {
            builder.append(".doOnSuccess(_result -> ").append(cacheFields.get(0)).append(".invalidate(_key));\n");
        }
        if (operation.parameters().size() == 1) {
            return CodeBlock.builder().add("var _key = $L;\n", new Object[]{operation.parameters().get(0)}).add(builder.toString(), new Object[0]).build();
        }
        String recordParameters = this.getKeyRecordParameters(operation, method);
        return CodeBlock.builder().add("var _key = $T.of($L);\n", new Object[]{this.getCacheKey(operation), recordParameters}).add(builder.toString(), new Object[0]).build();
    }

    private CodeBlock buildBodyMonoAll(ExecutableElement method, CacheOperation operation, List<String> cacheFields, String superCall) {
        String superMethod = this.getSuperMethod(method, superCall);
        StringBuilder builder = new StringBuilder();
        builder.append("return ").append(superMethod);
        if (cacheFields.size() > 1) {
            builder.append(".publishOn(reactor.core.scheduler.Schedulers.boundedElastic()).doOnSuccess(_result -> reactor.core.publisher.Flux.merge(java.util.List.of(\n");
            for (int i = 0; i < cacheFields.size(); ++i) {
                String cache = cacheFields.get(i);
                String suffix = i == cacheFields.size() - 1 ? ".invalidateAllAsync()\n" : ".invalidateAllAsync(),\n";
                builder.append("\t").append(cache).append(suffix);
            }
            builder.append(")).then().block());");
        } else {
            builder.append(".doOnSuccess(_result -> ").append(cacheFields.get(0)).append(".invalidateAll());\n");
        }
        return CodeBlock.builder().add(builder.toString(), new Object[0]).build();
    }
}

