/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;

abstract class AbstractAopCacheAspect
implements KoraAspect {
    private static final ClassName KEY_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache", (String)"CacheKey", (String[])new String[0]);

    AbstractAopCacheAspect() {
    }

    ClassName getCacheKey(CacheOperation operation) {
        return KEY_CACHE;
    }

    List<String> getCacheFields(CacheOperation operation, ProcessingEnvironment env, KoraAspect.AspectContext aspectContext) {
        ArrayList<String> cacheFields = new ArrayList<String>();
        for (String cacheImpl : operation.cacheImplementations()) {
            TypeElement cacheElement = env.getElementUtils().getTypeElement(cacheImpl);
            String fieldCache = aspectContext.fieldFactory().constructorParam(cacheElement.asType(), List.of());
            cacheFields.add(fieldCache);
        }
        return cacheFields;
    }

    String getKeyRecordParameters(CacheOperation operation, ExecutableElement method) {
        return String.join((CharSequence)", ", operation.getParametersNames(method));
    }

    String getSuperMethod(ExecutableElement method, String superCall) {
        return ((CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(superCall + "("), (String)")"))).toString();
    }
}

