/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor;

import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.cache.annotation.processor.CacheOperation;

public final class CacheOperationUtils {
    private static final ClassName ANNOTATION_CACHEABLE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheable", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHEABLES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cacheables", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_PUT = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePut", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_PUTS = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CachePuts", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_INVALIDATE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidate", (String[])new String[0]);
    private static final ClassName ANNOTATION_CACHE_INVALIDATES = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"CacheInvalidates", (String[])new String[0]);
    private static final Set<String> CACHE_ANNOTATIONS = Set.of(ANNOTATION_CACHEABLE.canonicalName(), ANNOTATION_CACHEABLES.canonicalName(), ANNOTATION_CACHE_PUT.canonicalName(), ANNOTATION_CACHE_PUTS.canonicalName(), ANNOTATION_CACHE_INVALIDATE.canonicalName(), ANNOTATION_CACHE_INVALIDATES.canonicalName());

    private CacheOperationUtils() {
    }

    public static CacheOperation getCacheMeta(ExecutableElement method) {
        List<AnnotationMirror> cacheables = CacheOperationUtils.getRepeatedAnnotations(method, ANNOTATION_CACHEABLE.canonicalName(), ANNOTATION_CACHEABLES.canonicalName());
        List<AnnotationMirror> puts = CacheOperationUtils.getRepeatedAnnotations(method, ANNOTATION_CACHE_PUT.canonicalName(), ANNOTATION_CACHE_PUTS.canonicalName());
        List<AnnotationMirror> invalidates = CacheOperationUtils.getRepeatedAnnotations(method, ANNOTATION_CACHE_INVALIDATE.canonicalName(), ANNOTATION_CACHE_INVALIDATES.canonicalName());
        String className = method.getEnclosingElement().getSimpleName().toString();
        String methodName = method.getSimpleName().toString();
        CacheOperation.Origin origin = new CacheOperation.Origin(className, methodName);
        if (!cacheables.isEmpty()) {
            if (!puts.isEmpty() || !invalidates.isEmpty()) {
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Method must have Cache annotations with same operation type, but got multiple different operation types for " + origin, (Element)method));
            }
            return CacheOperationUtils.getOperation(method, cacheables, CacheOperation.Type.GET);
        }
        if (!puts.isEmpty()) {
            if (!invalidates.isEmpty()) {
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Method must have Cache annotations with same operation type, but got multiple different operation types for " + origin, (Element)method));
            }
            return CacheOperationUtils.getOperation(method, puts, CacheOperation.Type.PUT);
        }
        if (!invalidates.isEmpty()) {
            boolean allInvalidateAll;
            List<Boolean> invalidateAlls = invalidates.stream().flatMap(a -> a.getElementValues().entrySet().stream()).filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("invalidateAll")).map(e -> (boolean)((Boolean)((AnnotationValue)e.getValue()).getValue())).toList();
            boolean anyInvalidateAll = !invalidateAlls.isEmpty() && invalidateAlls.stream().anyMatch(v -> v);
            boolean bl = allInvalidateAll = !invalidateAlls.isEmpty() && invalidateAlls.stream().allMatch(v -> v);
            if (anyInvalidateAll && !allInvalidateAll) {
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, ANNOTATION_CACHE_INVALIDATE.canonicalName() + " not all annotations are marked 'invalidateAll' out of all for " + origin, (Element)method));
            }
            CacheOperation.Type type = allInvalidateAll ? CacheOperation.Type.EVICT_ALL : CacheOperation.Type.EVICT;
            return CacheOperationUtils.getOperation(method, invalidates, type);
        }
        throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "None of " + CACHE_ANNOTATIONS + " cache annotations found", (Element)method));
    }

    private static CacheOperation getOperation(ExecutableElement method, List<AnnotationMirror> cacheAnnotations, CacheOperation.Type type) {
        String className = method.getEnclosingElement().getSimpleName().toString();
        String methodName = method.getSimpleName().toString();
        CacheOperation.Origin origin = new CacheOperation.Origin(className, methodName);
        ArrayList cacheKeyArguments = new ArrayList();
        ArrayList<String> cacheImpls = new ArrayList<String>();
        for (AnnotationMirror annotation : cacheAnnotations) {
            List<Object> parameters = annotation.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("parameters")).map(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().filter(a -> a instanceof AnnotationValue).map(a -> ((AnnotationValue)a).getValue().toString()).toList()).findFirst().orElse(Collections.emptyList());
            if (parameters.isEmpty()) {
                parameters = method.getParameters().stream().map(p -> p.getSimpleName().toString()).toList();
            } else {
                for (String string : parameters) {
                    if (!method.getParameters().stream().noneMatch(p -> p.getSimpleName().contentEquals(parameter))) continue;
                    throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Unknown method parameter is declared: " + string, (Element)method));
                }
            }
            for (List list : cacheKeyArguments) {
                if (list.equals(parameters)) continue;
                throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, annotation.getClass() + " parameters mismatch for different annotations for: " + origin, (Element)method));
            }
            cacheKeyArguments.add(parameters);
            String cacheImpl = annotation.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst().orElseThrow();
            cacheImpls.add(cacheImpl);
        }
        List<VariableElement> parameterResult = ((List)cacheKeyArguments.get(0)).stream().flatMap(param -> method.getParameters().stream().filter(p -> p.getSimpleName().contentEquals((CharSequence)param))).map(p -> p).toList();
        return new CacheOperation(type, cacheImpls, parameterResult, origin);
    }

    private static List<AnnotationMirror> getRepeatedAnnotations(Element element, String annotation, String parentAnnotation) {
        List<AnnotationMirror> repeated = element.getAnnotationMirrors().stream().filter(pa -> pa.getAnnotationType().toString().contentEquals(parentAnnotation)).flatMap(pa -> pa.getElementValues().entrySet().stream()).flatMap(e -> ((List)((AnnotationValue)e.getValue()).getValue()).stream().map(AnnotationMirror.class::cast)).filter(a -> a.getAnnotationType().toString().contentEquals(annotation)).toList();
        if (!repeated.isEmpty()) {
            return repeated;
        }
        return element.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().contentEquals(annotation)).map(a -> a).toList();
    }
}

