/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public record CacheOperation(Type type, List<String> cacheImplementations, List<VariableElement> parameters, Origin origin) {
    public List<String> getParametersNames(ExecutableElement method) {
        return this.getParameters(method).stream().map(p -> p.getSimpleName().toString()).toList();
    }

    public List<VariableElement> getParameters(ExecutableElement method) {
        if (this.parameters.isEmpty()) {
            return method.getParameters().stream().filter(this::isParameterSupported).map(p -> p).toList();
        }
        ArrayList<VariableElement> methodParameters = new ArrayList<VariableElement>();
        for (VariableElement parameter : this.parameters) {
            Optional<VariableElement> arg = method.getParameters().stream().filter(p -> p.getSimpleName().contentEquals(parameter.getSimpleName())).findFirst();
            if (arg.isPresent()) {
                methodParameters.add(arg.get());
                continue;
            }
            throw new IllegalArgumentException("Specified CacheKey parameter '" + parameter + "' is not present in method signature: " + this.origin());
        }
        return methodParameters;
    }

    public boolean isParameterSupported(VariableElement parameter) {
        return this.parameters.isEmpty() || this.parameters.stream().anyMatch(p -> p.getSimpleName().contentEquals(parameter.toString()));
    }

    public static enum Type {
        GET,
        PUT,
        EVICT,
        EVICT_ALL;

    }

    public record Origin(String className, String methodName) {
        @Override
        public String toString() {
            return "[class=" + this.className + ", method=" + this.methodName + "]";
        }
    }
}

