/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;

public class CacheAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z][0-9a-zA-Z_]*");
    private static final ClassName ANNOTATION_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache.annotation", (String)"Cache", (String[])new String[0]);
    private static final ClassName CAFFEINE_TELEMETRY = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCacheTelemetry", (String[])new String[0]);
    private static final ClassName REDIS_TELEMETRY = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheTelemetry", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCache", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE_FACTORY = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCacheFactory", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE_CONFIG = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"CaffeineCacheConfig", (String[])new String[0]);
    private static final ClassName CAFFEINE_CACHE_IMPL = ClassName.get((String)"ru.tinkoff.kora.cache.caffeine", (String)"AbstractCaffeineCache", (String[])new String[0]);
    private static final ClassName REDIS_CACHE = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCache", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_IMPL = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"AbstractRedisCache", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_CONFIG = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheConfig", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_CLIENT_SYNC = ClassName.get((String)"ru.tinkoff.kora.cache.redis.client", (String)"SyncRedisClient", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_CLIENT_REACTIVE = ClassName.get((String)"ru.tinkoff.kora.cache.redis.client", (String)"ReactiveRedisClient", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_MAPPER_KEY = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheKeyMapper", (String[])new String[0]);
    private static final ClassName REDIS_CACHE_MAPPER_VALUE = ClassName.get((String)"ru.tinkoff.kora.cache.redis", (String)"RedisCacheValueMapper", (String[])new String[0]);

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_CACHE.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement cacheAnnotation = this.processingEnv.getElementUtils().getTypeElement(ANNOTATION_CACHE.canonicalName());
        if (cacheAnnotation == null) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(cacheAnnotation)) {
            if (!element.getKind().isInterface()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@Cache annotation is intended to be used on interfaces, but was: " + element.getKind().name(), element);
                continue;
            }
            TypeElement cacheContract = (TypeElement)element;
            ParameterizedTypeName cacheContractType = this.getCacheSuperType(cacheContract);
            if (cacheContractType == null) continue;
            String packageName = this.getPackage(cacheContract);
            ClassName cacheContractClassName = ClassName.get((TypeElement)cacheContract);
            String configPath = CacheAnnotationProcessor.getCacheTypeConfigPath(cacheContract);
            if (!NAME_PATTERN.matcher(configPath).find()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cache config path doesn't match pattern: " + NAME_PATTERN, cacheContract);
                continue;
            }
            TypeName cacheImplBase = this.getCacheImplBase(cacheContract, cacheContractType);
            TypeSpec implSpec = TypeSpec.classBuilder((ClassName)CacheAnnotationProcessor.getCacheImpl(cacheContract)).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{CacheAnnotationProcessor.class.getCanonicalName()})).build()).addMethod(this.getCacheConstructor(configPath, cacheContractType)).superclass(cacheImplBase).addSuperinterface(cacheContract.asType()).build();
            try {
                JavaFile implFile = JavaFile.builder((String)cacheContractClassName.packageName(), (TypeSpec)implSpec).build();
                implFile.writeTo(this.processingEnv.getFiler());
                TypeSpec moduleSpec = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)packageName, (String)"$%sModule".formatted(cacheContractClassName.simpleName()), (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{CacheAnnotationProcessor.class.getCanonicalName()})).build()).addAnnotation(CommonClassNames.module).addMethod(this.getCacheMethodImpl(cacheContract, cacheContractType)).addMethod(this.getCacheMethodConfig(cacheContract, cacheContractType)).build();
                JavaFile moduleFile = JavaFile.builder((String)cacheContractClassName.packageName(), (TypeSpec)moduleSpec).build();
                moduleFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Nullable
    private ParameterizedTypeName getCacheSuperType(TypeElement candidate) {
        List<? extends TypeMirror> interfaces = candidate.getInterfaces();
        if (interfaces.size() != 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Cache annotated interface should implement one one interface and it should be one of: %s, %s".formatted(REDIS_CACHE.canonicalName(), CAFFEINE_CACHE.canonicalName()));
            return null;
        }
        DeclaredType superinterface = (DeclaredType)interfaces.get(0);
        TypeElement superinterfaceElement = (TypeElement)superinterface.asElement();
        if (superinterfaceElement.getQualifiedName().contentEquals(CAFFEINE_CACHE.canonicalName())) {
            return (ParameterizedTypeName)TypeName.get((TypeMirror)superinterface);
        }
        if (superinterfaceElement.getQualifiedName().contentEquals(REDIS_CACHE.canonicalName())) {
            return (ParameterizedTypeName)TypeName.get((TypeMirror)superinterface);
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "@Cache is expected to be known super type %s or %s, but was %s".formatted(REDIS_CACHE.canonicalName(), CAFFEINE_CACHE.canonicalName(), superinterface));
        return null;
    }

    private TypeName getCacheImplBase(TypeElement cacheContract, ParameterizedTypeName cacheType) {
        if (cacheType.rawType.equals((Object)CAFFEINE_CACHE)) {
            return ParameterizedTypeName.get((ClassName)CAFFEINE_CACHE_IMPL, (TypeName[])new TypeName[]{(TypeName)cacheType.typeArguments.get(0), (TypeName)cacheType.typeArguments.get(1)});
        }
        if (cacheType.rawType.equals((Object)REDIS_CACHE)) {
            return ParameterizedTypeName.get((ClassName)REDIS_CACHE_IMPL, (TypeName[])new TypeName[]{(TypeName)cacheType.typeArguments.get(0), (TypeName)cacheType.typeArguments.get(1)});
        }
        throw new UnsupportedOperationException("Unknown implementation: " + cacheContract.getQualifiedName());
    }

    private static String getCacheTypeConfigPath(TypeElement cacheContract) {
        AnnotationMirror cacheAnnotation = Objects.requireNonNull(AnnotationUtils.findAnnotation((Element)cacheContract, (ClassName)ANNOTATION_CACHE));
        return Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)cacheAnnotation, (String)"value"));
    }

    private MethodSpec getCacheMethodConfig(TypeElement cacheContract, ParameterizedTypeName cacheType) {
        ClassName returnType;
        String configPath = CacheAnnotationProcessor.getCacheTypeConfigPath(cacheContract);
        ClassName cacheContractName = ClassName.get((TypeElement)cacheContract);
        String methodName = "%sConfig".formatted(cacheContractName.simpleName());
        if (cacheType.rawType.equals((Object)CAFFEINE_CACHE)) {
            returnType = CAFFEINE_CACHE_CONFIG;
        } else if (cacheType.rawType.equals((Object)REDIS_CACHE)) {
            returnType = REDIS_CACHE_CONFIG;
        } else {
            throw new IllegalArgumentException("Unknown cache type: " + cacheType.rawType);
        }
        ParameterizedTypeName extractorType = ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{returnType});
        return MethodSpec.methodBuilder((String)methodName).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", cacheContractName.simpleName() + ".class", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)extractorType, "extractor", new Modifier[0]).addStatement("return extractor.extract(config.get($S))", new Object[]{configPath}).returns((TypeName)returnType).build();
    }

    private static ClassName getCacheImpl(TypeElement cacheContract) {
        ClassName cacheImplName = ClassName.get((TypeElement)cacheContract);
        return ClassName.get((String)cacheImplName.packageName(), (String)"$%sImpl".formatted(cacheImplName.simpleName()), (String[])new String[0]);
    }

    private MethodSpec getCacheMethodImpl(TypeElement cacheContract, ParameterizedTypeName cacheType) {
        ClassName cacheImplName = CacheAnnotationProcessor.getCacheImpl(cacheContract);
        String methodName = "%sImpl".formatted(cacheImplName.simpleName());
        if (cacheType.rawType.equals((Object)CAFFEINE_CACHE)) {
            return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)CAFFEINE_CACHE_CONFIG, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", cacheContract.getSimpleName().toString() + ".class", new Object[0]).build()).build()).addParameter((TypeName)CAFFEINE_CACHE_FACTORY, "factory", new Modifier[0]).addParameter((TypeName)CAFFEINE_TELEMETRY, "telemetry", new Modifier[0]).addStatement("return new $T(config, factory, telemetry)", new Object[]{cacheImplName}).returns(TypeName.get((TypeMirror)cacheContract.asType())).build();
        }
        if (cacheType.rawType.equals((Object)REDIS_CACHE)) {
            TypeName keyType = (TypeName)cacheType.typeArguments.get(0);
            TypeName valueType = (TypeName)cacheType.typeArguments.get(1);
            ParameterizedTypeName keyMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_KEY, (TypeName[])new TypeName[]{keyType});
            ParameterizedTypeName valueMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_VALUE, (TypeName[])new TypeName[]{valueType});
            return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)REDIS_CACHE_CONFIG, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", cacheContract.getSimpleName().toString() + ".class", new Object[0]).build()).build()).addParameter((TypeName)REDIS_CACHE_CLIENT_SYNC, "syncClient", new Modifier[0]).addParameter((TypeName)REDIS_CACHE_CLIENT_REACTIVE, "reactiveClient", new Modifier[0]).addParameter((TypeName)REDIS_TELEMETRY, "telemetry", new Modifier[0]).addParameter((TypeName)keyMapperType, "keyMapper", new Modifier[0]).addParameter((TypeName)valueMapperType, "valueMapper", new Modifier[0]).addStatement("return new $T(config, syncClient, reactiveClient, telemetry, keyMapper, valueMapper)", new Object[]{cacheImplName}).returns(TypeName.get((TypeMirror)cacheContract.asType())).build();
        }
        throw new IllegalArgumentException("Unknown cache type: " + cacheType.rawType);
    }

    private MethodSpec getCacheConstructor(String configPath, ParameterizedTypeName cacheContract) {
        if (cacheContract.rawType.equals((Object)CAFFEINE_CACHE)) {
            return MethodSpec.constructorBuilder().addParameter((TypeName)CAFFEINE_CACHE_CONFIG, "config", new Modifier[0]).addParameter((TypeName)CAFFEINE_CACHE_FACTORY, "factory", new Modifier[0]).addParameter((TypeName)CAFFEINE_TELEMETRY, "telemetry", new Modifier[0]).addStatement("super($S, config, factory, telemetry)", new Object[]{configPath}).build();
        }
        if (cacheContract.rawType.equals((Object)REDIS_CACHE)) {
            TypeName keyType = (TypeName)cacheContract.typeArguments.get(0);
            TypeName valueType = (TypeName)cacheContract.typeArguments.get(1);
            ParameterizedTypeName keyMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_KEY, (TypeName[])new TypeName[]{keyType});
            ParameterizedTypeName valueMapperType = ParameterizedTypeName.get((ClassName)REDIS_CACHE_MAPPER_VALUE, (TypeName[])new TypeName[]{valueType});
            return MethodSpec.constructorBuilder().addParameter((TypeName)REDIS_CACHE_CONFIG, "config", new Modifier[0]).addParameter((TypeName)REDIS_CACHE_CLIENT_SYNC, "syncClient", new Modifier[0]).addParameter((TypeName)REDIS_CACHE_CLIENT_REACTIVE, "reactiveClient", new Modifier[0]).addParameter((TypeName)REDIS_TELEMETRY, "telemetry", new Modifier[0]).addParameter((TypeName)keyMapperType, "keyMapper", new Modifier[0]).addParameter((TypeName)valueMapperType, "valueMapper", new Modifier[0]).addStatement("super($S, config, syncClient, reactiveClient, telemetry, keyMapper, valueMapper)", new Object[]{configPath}).build();
        }
        throw new IllegalArgumentException("Unknown cache type: " + cacheContract.rawType);
    }

    private String getPackage(Element element) {
        return this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }
}

