package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import ru.tinkoff.piapi.contract.v1.UsersServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.UsersService.
 */
public object UsersServiceGrpcKt {
  public const val SERVICE_NAME: String = UsersServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = UsersServiceGrpc.getServiceDescriptor()

  public val getAccountsMethod: MethodDescriptor<GetAccountsRequest, GetAccountsResponse>
    @JvmStatic
    get() = UsersServiceGrpc.getGetAccountsMethod()

  public val getMarginAttributesMethod:
      MethodDescriptor<GetMarginAttributesRequest, GetMarginAttributesResponse>
    @JvmStatic
    get() = UsersServiceGrpc.getGetMarginAttributesMethod()

  public val getUserTariffMethod: MethodDescriptor<GetUserTariffRequest, GetUserTariffResponse>
    @JvmStatic
    get() = UsersServiceGrpc.getGetUserTariffMethod()

  public val getInfoMethod: MethodDescriptor<GetInfoRequest, GetInfoResponse>
    @JvmStatic
    get() = UsersServiceGrpc.getGetInfoMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.UsersService service as
   * suspending coroutines.
   */
  @StubFor(UsersServiceGrpc::class)
  public class UsersServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<UsersServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions): UsersServiceCoroutineStub
        = UsersServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getAccounts(request: GetAccountsRequest, headers: Metadata = Metadata()):
        GetAccountsResponse = unaryRpc(
      channel,
      UsersServiceGrpc.getGetAccountsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getMarginAttributes(request: GetMarginAttributesRequest, headers: Metadata =
        Metadata()): GetMarginAttributesResponse = unaryRpc(
      channel,
      UsersServiceGrpc.getGetMarginAttributesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getUserTariff(request: GetUserTariffRequest, headers: Metadata = Metadata()):
        GetUserTariffResponse = unaryRpc(
      channel,
      UsersServiceGrpc.getGetUserTariffMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getInfo(request: GetInfoRequest, headers: Metadata = Metadata()):
        GetInfoResponse = unaryRpc(
      channel,
      UsersServiceGrpc.getGetInfoMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.UsersService service based
   * on Kotlin coroutines.
   */
  public abstract class UsersServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.UsersService.GetAccounts.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getAccounts(request: GetAccountsRequest): GetAccountsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.UsersService.GetAccounts is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.UsersService.GetMarginAttributes.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getMarginAttributes(request: GetMarginAttributesRequest):
        GetMarginAttributesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.UsersService.GetMarginAttributes is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.UsersService.GetUserTariff.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getUserTariff(request: GetUserTariffRequest): GetUserTariffResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.UsersService.GetUserTariff is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.UsersService.GetInfo.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getInfo(request: GetInfoRequest): GetInfoResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.UsersService.GetInfo is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = UsersServiceGrpc.getGetAccountsMethod(),
      implementation = ::getAccounts
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = UsersServiceGrpc.getGetMarginAttributesMethod(),
      implementation = ::getMarginAttributes
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = UsersServiceGrpc.getGetUserTariffMethod(),
      implementation = ::getUserTariff
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = UsersServiceGrpc.getGetInfoMethod(),
      implementation = ::getInfo
    )).build()
  }
}
