package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import ru.tinkoff.piapi.contract.v1.StopOrdersServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.StopOrdersService.
 */
public object StopOrdersServiceGrpcKt {
  public const val SERVICE_NAME: String = StopOrdersServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = StopOrdersServiceGrpc.getServiceDescriptor()

  public val postStopOrderMethod: MethodDescriptor<PostStopOrderRequest, PostStopOrderResponse>
    @JvmStatic
    get() = StopOrdersServiceGrpc.getPostStopOrderMethod()

  public val getStopOrdersMethod: MethodDescriptor<GetStopOrdersRequest, GetStopOrdersResponse>
    @JvmStatic
    get() = StopOrdersServiceGrpc.getGetStopOrdersMethod()

  public val cancelStopOrderMethod:
      MethodDescriptor<CancelStopOrderRequest, CancelStopOrderResponse>
    @JvmStatic
    get() = StopOrdersServiceGrpc.getCancelStopOrderMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.StopOrdersService service
   * as suspending coroutines.
   */
  @StubFor(StopOrdersServiceGrpc::class)
  public class StopOrdersServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<StopOrdersServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        StopOrdersServiceCoroutineStub = StopOrdersServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun postStopOrder(request: PostStopOrderRequest, headers: Metadata = Metadata()):
        PostStopOrderResponse = unaryRpc(
      channel,
      StopOrdersServiceGrpc.getPostStopOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getStopOrders(request: GetStopOrdersRequest, headers: Metadata = Metadata()):
        GetStopOrdersResponse = unaryRpc(
      channel,
      StopOrdersServiceGrpc.getGetStopOrdersMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun cancelStopOrder(request: CancelStopOrderRequest, headers: Metadata =
        Metadata()): CancelStopOrderResponse = unaryRpc(
      channel,
      StopOrdersServiceGrpc.getCancelStopOrderMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.StopOrdersService service
   * based on Kotlin coroutines.
   */
  public abstract class StopOrdersServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.StopOrdersService.PostStopOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun postStopOrder(request: PostStopOrderRequest): PostStopOrderResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.StopOrdersService.PostStopOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.StopOrdersService.GetStopOrders.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getStopOrders(request: GetStopOrdersRequest): GetStopOrdersResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.StopOrdersService.GetStopOrders is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.StopOrdersService.CancelStopOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun cancelStopOrder(request: CancelStopOrderRequest):
        CancelStopOrderResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.StopOrdersService.CancelStopOrder is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = StopOrdersServiceGrpc.getPostStopOrderMethod(),
      implementation = ::postStopOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = StopOrdersServiceGrpc.getGetStopOrdersMethod(),
      implementation = ::getStopOrders
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = StopOrdersServiceGrpc.getCancelStopOrderMethod(),
      implementation = ::cancelStopOrder
    )).build()
  }
}
