package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import ru.tinkoff.piapi.contract.v1.SandboxServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.SandboxService.
 */
public object SandboxServiceGrpcKt {
  public const val SERVICE_NAME: String = SandboxServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = SandboxServiceGrpc.getServiceDescriptor()

  public val openSandboxAccountMethod:
      MethodDescriptor<OpenSandboxAccountRequest, OpenSandboxAccountResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getOpenSandboxAccountMethod()

  public val getSandboxAccountsMethod: MethodDescriptor<GetAccountsRequest, GetAccountsResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxAccountsMethod()

  public val closeSandboxAccountMethod:
      MethodDescriptor<CloseSandboxAccountRequest, CloseSandboxAccountResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getCloseSandboxAccountMethod()

  public val postSandboxOrderMethod: MethodDescriptor<PostOrderRequest, PostOrderResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getPostSandboxOrderMethod()

  public val replaceSandboxOrderMethod: MethodDescriptor<ReplaceOrderRequest, PostOrderResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getReplaceSandboxOrderMethod()

  public val getSandboxOrdersMethod: MethodDescriptor<GetOrdersRequest, GetOrdersResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxOrdersMethod()

  public val cancelSandboxOrderMethod: MethodDescriptor<CancelOrderRequest, CancelOrderResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getCancelSandboxOrderMethod()

  public val getSandboxOrderStateMethod: MethodDescriptor<GetOrderStateRequest, OrderState>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxOrderStateMethod()

  public val getSandboxPositionsMethod: MethodDescriptor<PositionsRequest, PositionsResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxPositionsMethod()

  public val getSandboxOperationsMethod: MethodDescriptor<OperationsRequest, OperationsResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxOperationsMethod()

  public val getSandboxOperationsByCursorMethod:
      MethodDescriptor<GetOperationsByCursorRequest, GetOperationsByCursorResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxOperationsByCursorMethod()

  public val getSandboxPortfolioMethod: MethodDescriptor<PortfolioRequest, PortfolioResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxPortfolioMethod()

  public val sandboxPayInMethod: MethodDescriptor<SandboxPayInRequest, SandboxPayInResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getSandboxPayInMethod()

  public val getSandboxWithdrawLimitsMethod:
      MethodDescriptor<WithdrawLimitsRequest, WithdrawLimitsResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxWithdrawLimitsMethod()

  public val getSandboxMaxLotsMethod: MethodDescriptor<GetMaxLotsRequest, GetMaxLotsResponse>
    @JvmStatic
    get() = SandboxServiceGrpc.getGetSandboxMaxLotsMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.SandboxService service as
   * suspending coroutines.
   */
  @StubFor(SandboxServiceGrpc::class)
  public class SandboxServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<SandboxServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        SandboxServiceCoroutineStub = SandboxServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun openSandboxAccount(request: OpenSandboxAccountRequest, headers: Metadata =
        Metadata()): OpenSandboxAccountResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getOpenSandboxAccountMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxAccounts(request: GetAccountsRequest, headers: Metadata =
        Metadata()): GetAccountsResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxAccountsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun closeSandboxAccount(request: CloseSandboxAccountRequest, headers: Metadata =
        Metadata()): CloseSandboxAccountResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getCloseSandboxAccountMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun postSandboxOrder(request: PostOrderRequest, headers: Metadata = Metadata()):
        PostOrderResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getPostSandboxOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun replaceSandboxOrder(request: ReplaceOrderRequest, headers: Metadata =
        Metadata()): PostOrderResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getReplaceSandboxOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxOrders(request: GetOrdersRequest, headers: Metadata = Metadata()):
        GetOrdersResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxOrdersMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun cancelSandboxOrder(request: CancelOrderRequest, headers: Metadata =
        Metadata()): CancelOrderResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getCancelSandboxOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxOrderState(request: GetOrderStateRequest, headers: Metadata =
        Metadata()): OrderState = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxOrderStateMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxPositions(request: PositionsRequest, headers: Metadata =
        Metadata()): PositionsResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxPositionsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxOperations(request: OperationsRequest, headers: Metadata =
        Metadata()): OperationsResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxOperationsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxOperationsByCursor(request: GetOperationsByCursorRequest,
        headers: Metadata = Metadata()): GetOperationsByCursorResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxOperationsByCursorMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxPortfolio(request: PortfolioRequest, headers: Metadata =
        Metadata()): PortfolioResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxPortfolioMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun sandboxPayIn(request: SandboxPayInRequest, headers: Metadata = Metadata()):
        SandboxPayInResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getSandboxPayInMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxWithdrawLimits(request: WithdrawLimitsRequest, headers: Metadata =
        Metadata()): WithdrawLimitsResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxWithdrawLimitsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getSandboxMaxLots(request: GetMaxLotsRequest, headers: Metadata =
        Metadata()): GetMaxLotsResponse = unaryRpc(
      channel,
      SandboxServiceGrpc.getGetSandboxMaxLotsMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.SandboxService service
   * based on Kotlin coroutines.
   */
  public abstract class SandboxServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.OpenSandboxAccount.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun openSandboxAccount(request: OpenSandboxAccountRequest):
        OpenSandboxAccountResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.OpenSandboxAccount is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxAccounts.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxAccounts(request: GetAccountsRequest): GetAccountsResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxAccounts is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.CloseSandboxAccount.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun closeSandboxAccount(request: CloseSandboxAccountRequest):
        CloseSandboxAccountResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.CloseSandboxAccount is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.PostSandboxOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun postSandboxOrder(request: PostOrderRequest): PostOrderResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.PostSandboxOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.ReplaceSandboxOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun replaceSandboxOrder(request: ReplaceOrderRequest): PostOrderResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.ReplaceSandboxOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOrders.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxOrders(request: GetOrdersRequest): GetOrdersResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOrders is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.CancelSandboxOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun cancelSandboxOrder(request: CancelOrderRequest): CancelOrderResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.CancelSandboxOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOrderState.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxOrderState(request: GetOrderStateRequest): OrderState = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOrderState is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxPositions.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxPositions(request: PositionsRequest): PositionsResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxPositions is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOperations.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxOperations(request: OperationsRequest): OperationsResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOperations is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOperationsByCursor.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxOperationsByCursor(request: GetOperationsByCursorRequest):
        GetOperationsByCursorResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxOperationsByCursor is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxPortfolio.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxPortfolio(request: PortfolioRequest): PortfolioResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxPortfolio is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.SandboxPayIn.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun sandboxPayIn(request: SandboxPayInRequest): SandboxPayInResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.SandboxPayIn is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxWithdrawLimits.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxWithdrawLimits(request: WithdrawLimitsRequest):
        WithdrawLimitsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxWithdrawLimits is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxMaxLots.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getSandboxMaxLots(request: GetMaxLotsRequest): GetMaxLotsResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.SandboxService.GetSandboxMaxLots is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getOpenSandboxAccountMethod(),
      implementation = ::openSandboxAccount
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxAccountsMethod(),
      implementation = ::getSandboxAccounts
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getCloseSandboxAccountMethod(),
      implementation = ::closeSandboxAccount
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getPostSandboxOrderMethod(),
      implementation = ::postSandboxOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getReplaceSandboxOrderMethod(),
      implementation = ::replaceSandboxOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxOrdersMethod(),
      implementation = ::getSandboxOrders
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getCancelSandboxOrderMethod(),
      implementation = ::cancelSandboxOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxOrderStateMethod(),
      implementation = ::getSandboxOrderState
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxPositionsMethod(),
      implementation = ::getSandboxPositions
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxOperationsMethod(),
      implementation = ::getSandboxOperations
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxOperationsByCursorMethod(),
      implementation = ::getSandboxOperationsByCursor
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxPortfolioMethod(),
      implementation = ::getSandboxPortfolio
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getSandboxPayInMethod(),
      implementation = ::sandboxPayIn
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxWithdrawLimitsMethod(),
      implementation = ::getSandboxWithdrawLimits
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SandboxServiceGrpc.getGetSandboxMaxLotsMethod(),
      implementation = ::getSandboxMaxLots
    )).build()
  }
}
