package ru.tinkoff.piapi.contract.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Сервис предназначен для работы с торговыми поручениями:&lt;/br&gt; **1**.
 *выставление;&lt;/br&gt; **2**. отмена;&lt;/br&gt; **3**. получение статуса;&lt;/br&gt; **4**.
 *расчёт полной стоимости;&lt;/br&gt; **5**. получение списка заявок.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.57.1)",
    comments = "Source: orders.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class OrdersServiceGrpc {

  private OrdersServiceGrpc() {}

  public static final java.lang.String SERVICE_NAME = "tinkoff.public.invest.api.contract.v1.OrdersService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PostOrderRequest,
      ru.tinkoff.piapi.contract.v1.PostOrderResponse> getPostOrderMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PostOrder",
      requestType = ru.tinkoff.piapi.contract.v1.PostOrderRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.PostOrderResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PostOrderRequest,
      ru.tinkoff.piapi.contract.v1.PostOrderResponse> getPostOrderMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PostOrderRequest, ru.tinkoff.piapi.contract.v1.PostOrderResponse> getPostOrderMethod;
    if ((getPostOrderMethod = OrdersServiceGrpc.getPostOrderMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getPostOrderMethod = OrdersServiceGrpc.getPostOrderMethod) == null) {
          OrdersServiceGrpc.getPostOrderMethod = getPostOrderMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.PostOrderRequest, ru.tinkoff.piapi.contract.v1.PostOrderResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PostOrder"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PostOrderRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PostOrderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("PostOrder"))
              .build();
        }
      }
    }
    return getPostOrderMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest,
      ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse> getPostOrderAsyncMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PostOrderAsync",
      requestType = ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest,
      ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse> getPostOrderAsyncMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest, ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse> getPostOrderAsyncMethod;
    if ((getPostOrderAsyncMethod = OrdersServiceGrpc.getPostOrderAsyncMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getPostOrderAsyncMethod = OrdersServiceGrpc.getPostOrderAsyncMethod) == null) {
          OrdersServiceGrpc.getPostOrderAsyncMethod = getPostOrderAsyncMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest, ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PostOrderAsync"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("PostOrderAsync"))
              .build();
        }
      }
    }
    return getPostOrderAsyncMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.CancelOrderRequest,
      ru.tinkoff.piapi.contract.v1.CancelOrderResponse> getCancelOrderMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CancelOrder",
      requestType = ru.tinkoff.piapi.contract.v1.CancelOrderRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.CancelOrderResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.CancelOrderRequest,
      ru.tinkoff.piapi.contract.v1.CancelOrderResponse> getCancelOrderMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.CancelOrderRequest, ru.tinkoff.piapi.contract.v1.CancelOrderResponse> getCancelOrderMethod;
    if ((getCancelOrderMethod = OrdersServiceGrpc.getCancelOrderMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getCancelOrderMethod = OrdersServiceGrpc.getCancelOrderMethod) == null) {
          OrdersServiceGrpc.getCancelOrderMethod = getCancelOrderMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.CancelOrderRequest, ru.tinkoff.piapi.contract.v1.CancelOrderResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CancelOrder"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.CancelOrderRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.CancelOrderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("CancelOrder"))
              .build();
        }
      }
    }
    return getCancelOrderMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrderStateRequest,
      ru.tinkoff.piapi.contract.v1.OrderState> getGetOrderStateMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetOrderState",
      requestType = ru.tinkoff.piapi.contract.v1.GetOrderStateRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.OrderState.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrderStateRequest,
      ru.tinkoff.piapi.contract.v1.OrderState> getGetOrderStateMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrderStateRequest, ru.tinkoff.piapi.contract.v1.OrderState> getGetOrderStateMethod;
    if ((getGetOrderStateMethod = OrdersServiceGrpc.getGetOrderStateMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getGetOrderStateMethod = OrdersServiceGrpc.getGetOrderStateMethod) == null) {
          OrdersServiceGrpc.getGetOrderStateMethod = getGetOrderStateMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.GetOrderStateRequest, ru.tinkoff.piapi.contract.v1.OrderState>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetOrderState"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOrderStateRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.OrderState.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("GetOrderState"))
              .build();
        }
      }
    }
    return getGetOrderStateMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrdersRequest,
      ru.tinkoff.piapi.contract.v1.GetOrdersResponse> getGetOrdersMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetOrders",
      requestType = ru.tinkoff.piapi.contract.v1.GetOrdersRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.GetOrdersResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrdersRequest,
      ru.tinkoff.piapi.contract.v1.GetOrdersResponse> getGetOrdersMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrdersRequest, ru.tinkoff.piapi.contract.v1.GetOrdersResponse> getGetOrdersMethod;
    if ((getGetOrdersMethod = OrdersServiceGrpc.getGetOrdersMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getGetOrdersMethod = OrdersServiceGrpc.getGetOrdersMethod) == null) {
          OrdersServiceGrpc.getGetOrdersMethod = getGetOrdersMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.GetOrdersRequest, ru.tinkoff.piapi.contract.v1.GetOrdersResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetOrders"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOrdersRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOrdersResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("GetOrders"))
              .build();
        }
      }
    }
    return getGetOrdersMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest,
      ru.tinkoff.piapi.contract.v1.PostOrderResponse> getReplaceOrderMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ReplaceOrder",
      requestType = ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.PostOrderResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest,
      ru.tinkoff.piapi.contract.v1.PostOrderResponse> getReplaceOrderMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest, ru.tinkoff.piapi.contract.v1.PostOrderResponse> getReplaceOrderMethod;
    if ((getReplaceOrderMethod = OrdersServiceGrpc.getReplaceOrderMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getReplaceOrderMethod = OrdersServiceGrpc.getReplaceOrderMethod) == null) {
          OrdersServiceGrpc.getReplaceOrderMethod = getReplaceOrderMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest, ru.tinkoff.piapi.contract.v1.PostOrderResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ReplaceOrder"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.PostOrderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("ReplaceOrder"))
              .build();
        }
      }
    }
    return getReplaceOrderMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest,
      ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse> getGetMaxLotsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetMaxLots",
      requestType = ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest,
      ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse> getGetMaxLotsMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest, ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse> getGetMaxLotsMethod;
    if ((getGetMaxLotsMethod = OrdersServiceGrpc.getGetMaxLotsMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getGetMaxLotsMethod = OrdersServiceGrpc.getGetMaxLotsMethod) == null) {
          OrdersServiceGrpc.getGetMaxLotsMethod = getGetMaxLotsMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest, ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetMaxLots"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("GetMaxLots"))
              .build();
        }
      }
    }
    return getGetMaxLotsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest,
      ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse> getGetOrderPriceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetOrderPrice",
      requestType = ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest.class,
      responseType = ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest,
      ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse> getGetOrderPriceMethod() {
    io.grpc.MethodDescriptor<ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest, ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse> getGetOrderPriceMethod;
    if ((getGetOrderPriceMethod = OrdersServiceGrpc.getGetOrderPriceMethod) == null) {
      synchronized (OrdersServiceGrpc.class) {
        if ((getGetOrderPriceMethod = OrdersServiceGrpc.getGetOrderPriceMethod) == null) {
          OrdersServiceGrpc.getGetOrderPriceMethod = getGetOrderPriceMethod =
              io.grpc.MethodDescriptor.<ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest, ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetOrderPrice"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OrdersServiceMethodDescriptorSupplier("GetOrderPrice"))
              .build();
        }
      }
    }
    return getGetOrderPriceMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static OrdersServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OrdersServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OrdersServiceStub>() {
        @java.lang.Override
        public OrdersServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OrdersServiceStub(channel, callOptions);
        }
      };
    return OrdersServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static OrdersServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OrdersServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OrdersServiceBlockingStub>() {
        @java.lang.Override
        public OrdersServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OrdersServiceBlockingStub(channel, callOptions);
        }
      };
    return OrdersServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static OrdersServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OrdersServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OrdersServiceFutureStub>() {
        @java.lang.Override
        public OrdersServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OrdersServiceFutureStub(channel, callOptions);
        }
      };
    return OrdersServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Сервис предназначен для работы с торговыми поручениями:&lt;/br&gt; **1**.
   *выставление;&lt;/br&gt; **2**. отмена;&lt;/br&gt; **3**. получение статуса;&lt;/br&gt; **4**.
   *расчёт полной стоимости;&lt;/br&gt; **5**. получение списка заявок.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     *Метод выставления заявки.
     * </pre>
     */
    default void postOrder(ru.tinkoff.piapi.contract.v1.PostOrderRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPostOrderMethod(), responseObserver);
    }

    /**
     * <pre>
     *Асинхронный метод выставления заявки.
     * </pre>
     */
    default void postOrderAsync(ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPostOrderAsyncMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод отмены биржевой заявки.
     * </pre>
     */
    default void cancelOrder(ru.tinkoff.piapi.contract.v1.CancelOrderRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.CancelOrderResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCancelOrderMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения статуса торгового поручения.
     * </pre>
     */
    default void getOrderState(ru.tinkoff.piapi.contract.v1.GetOrderStateRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.OrderState> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetOrderStateMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения списка активных заявок по счёту.
     * </pre>
     */
    default void getOrders(ru.tinkoff.piapi.contract.v1.GetOrdersRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOrdersResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetOrdersMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод изменения выставленной заявки.
     * </pre>
     */
    default void replaceOrder(ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReplaceOrderMethod(), responseObserver);
    }

    /**
     * <pre>
     *расчет количества доступных для покупки/продажи лотов
     * </pre>
     */
    default void getMaxLots(ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetMaxLotsMethod(), responseObserver);
    }

    /**
     * <pre>
     *Метод получения предварительной стоимости для лимитной заявки
     * </pre>
     */
    default void getOrderPrice(ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetOrderPriceMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service OrdersService.
   * <pre>
   * Сервис предназначен для работы с торговыми поручениями:&lt;/br&gt; **1**.
   *выставление;&lt;/br&gt; **2**. отмена;&lt;/br&gt; **3**. получение статуса;&lt;/br&gt; **4**.
   *расчёт полной стоимости;&lt;/br&gt; **5**. получение списка заявок.
   * </pre>
   */
  public static abstract class OrdersServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return OrdersServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service OrdersService.
   * <pre>
   * Сервис предназначен для работы с торговыми поручениями:&lt;/br&gt; **1**.
   *выставление;&lt;/br&gt; **2**. отмена;&lt;/br&gt; **3**. получение статуса;&lt;/br&gt; **4**.
   *расчёт полной стоимости;&lt;/br&gt; **5**. получение списка заявок.
   * </pre>
   */
  public static final class OrdersServiceStub
      extends io.grpc.stub.AbstractAsyncStub<OrdersServiceStub> {
    private OrdersServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OrdersServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OrdersServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     *Метод выставления заявки.
     * </pre>
     */
    public void postOrder(ru.tinkoff.piapi.contract.v1.PostOrderRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPostOrderMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Асинхронный метод выставления заявки.
     * </pre>
     */
    public void postOrderAsync(ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPostOrderAsyncMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод отмены биржевой заявки.
     * </pre>
     */
    public void cancelOrder(ru.tinkoff.piapi.contract.v1.CancelOrderRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.CancelOrderResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCancelOrderMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения статуса торгового поручения.
     * </pre>
     */
    public void getOrderState(ru.tinkoff.piapi.contract.v1.GetOrderStateRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.OrderState> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetOrderStateMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения списка активных заявок по счёту.
     * </pre>
     */
    public void getOrders(ru.tinkoff.piapi.contract.v1.GetOrdersRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOrdersResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetOrdersMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод изменения выставленной заявки.
     * </pre>
     */
    public void replaceOrder(ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReplaceOrderMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *расчет количества доступных для покупки/продажи лотов
     * </pre>
     */
    public void getMaxLots(ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetMaxLotsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Метод получения предварительной стоимости для лимитной заявки
     * </pre>
     */
    public void getOrderPrice(ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest request,
        io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetOrderPriceMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service OrdersService.
   * <pre>
   * Сервис предназначен для работы с торговыми поручениями:&lt;/br&gt; **1**.
   *выставление;&lt;/br&gt; **2**. отмена;&lt;/br&gt; **3**. получение статуса;&lt;/br&gt; **4**.
   *расчёт полной стоимости;&lt;/br&gt; **5**. получение списка заявок.
   * </pre>
   */
  public static final class OrdersServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<OrdersServiceBlockingStub> {
    private OrdersServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OrdersServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OrdersServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     *Метод выставления заявки.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.PostOrderResponse postOrder(ru.tinkoff.piapi.contract.v1.PostOrderRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPostOrderMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Асинхронный метод выставления заявки.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse postOrderAsync(ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPostOrderAsyncMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод отмены биржевой заявки.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.CancelOrderResponse cancelOrder(ru.tinkoff.piapi.contract.v1.CancelOrderRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCancelOrderMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения статуса торгового поручения.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.OrderState getOrderState(ru.tinkoff.piapi.contract.v1.GetOrderStateRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetOrderStateMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения списка активных заявок по счёту.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.GetOrdersResponse getOrders(ru.tinkoff.piapi.contract.v1.GetOrdersRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetOrdersMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод изменения выставленной заявки.
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.PostOrderResponse replaceOrder(ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReplaceOrderMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *расчет количества доступных для покупки/продажи лотов
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse getMaxLots(ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetMaxLotsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Метод получения предварительной стоимости для лимитной заявки
     * </pre>
     */
    public ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse getOrderPrice(ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetOrderPriceMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service OrdersService.
   * <pre>
   * Сервис предназначен для работы с торговыми поручениями:&lt;/br&gt; **1**.
   *выставление;&lt;/br&gt; **2**. отмена;&lt;/br&gt; **3**. получение статуса;&lt;/br&gt; **4**.
   *расчёт полной стоимости;&lt;/br&gt; **5**. получение списка заявок.
   * </pre>
   */
  public static final class OrdersServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<OrdersServiceFutureStub> {
    private OrdersServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OrdersServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OrdersServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     *Метод выставления заявки.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.PostOrderResponse> postOrder(
        ru.tinkoff.piapi.contract.v1.PostOrderRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPostOrderMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Асинхронный метод выставления заявки.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse> postOrderAsync(
        ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPostOrderAsyncMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод отмены биржевой заявки.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.CancelOrderResponse> cancelOrder(
        ru.tinkoff.piapi.contract.v1.CancelOrderRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCancelOrderMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения статуса торгового поручения.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.OrderState> getOrderState(
        ru.tinkoff.piapi.contract.v1.GetOrderStateRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetOrderStateMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения списка активных заявок по счёту.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.GetOrdersResponse> getOrders(
        ru.tinkoff.piapi.contract.v1.GetOrdersRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetOrdersMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод изменения выставленной заявки.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.PostOrderResponse> replaceOrder(
        ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReplaceOrderMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *расчет количества доступных для покупки/продажи лотов
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse> getMaxLots(
        ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetMaxLotsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Метод получения предварительной стоимости для лимитной заявки
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse> getOrderPrice(
        ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetOrderPriceMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_POST_ORDER = 0;
  private static final int METHODID_POST_ORDER_ASYNC = 1;
  private static final int METHODID_CANCEL_ORDER = 2;
  private static final int METHODID_GET_ORDER_STATE = 3;
  private static final int METHODID_GET_ORDERS = 4;
  private static final int METHODID_REPLACE_ORDER = 5;
  private static final int METHODID_GET_MAX_LOTS = 6;
  private static final int METHODID_GET_ORDER_PRICE = 7;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_POST_ORDER:
          serviceImpl.postOrder((ru.tinkoff.piapi.contract.v1.PostOrderRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderResponse>) responseObserver);
          break;
        case METHODID_POST_ORDER_ASYNC:
          serviceImpl.postOrderAsync((ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse>) responseObserver);
          break;
        case METHODID_CANCEL_ORDER:
          serviceImpl.cancelOrder((ru.tinkoff.piapi.contract.v1.CancelOrderRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.CancelOrderResponse>) responseObserver);
          break;
        case METHODID_GET_ORDER_STATE:
          serviceImpl.getOrderState((ru.tinkoff.piapi.contract.v1.GetOrderStateRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.OrderState>) responseObserver);
          break;
        case METHODID_GET_ORDERS:
          serviceImpl.getOrders((ru.tinkoff.piapi.contract.v1.GetOrdersRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOrdersResponse>) responseObserver);
          break;
        case METHODID_REPLACE_ORDER:
          serviceImpl.replaceOrder((ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.PostOrderResponse>) responseObserver);
          break;
        case METHODID_GET_MAX_LOTS:
          serviceImpl.getMaxLots((ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse>) responseObserver);
          break;
        case METHODID_GET_ORDER_PRICE:
          serviceImpl.getOrderPrice((ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest) request,
              (io.grpc.stub.StreamObserver<ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getPostOrderMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.PostOrderRequest,
              ru.tinkoff.piapi.contract.v1.PostOrderResponse>(
                service, METHODID_POST_ORDER)))
        .addMethod(
          getPostOrderAsyncMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.PostOrderAsyncRequest,
              ru.tinkoff.piapi.contract.v1.PostOrderAsyncResponse>(
                service, METHODID_POST_ORDER_ASYNC)))
        .addMethod(
          getCancelOrderMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.CancelOrderRequest,
              ru.tinkoff.piapi.contract.v1.CancelOrderResponse>(
                service, METHODID_CANCEL_ORDER)))
        .addMethod(
          getGetOrderStateMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.GetOrderStateRequest,
              ru.tinkoff.piapi.contract.v1.OrderState>(
                service, METHODID_GET_ORDER_STATE)))
        .addMethod(
          getGetOrdersMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.GetOrdersRequest,
              ru.tinkoff.piapi.contract.v1.GetOrdersResponse>(
                service, METHODID_GET_ORDERS)))
        .addMethod(
          getReplaceOrderMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.ReplaceOrderRequest,
              ru.tinkoff.piapi.contract.v1.PostOrderResponse>(
                service, METHODID_REPLACE_ORDER)))
        .addMethod(
          getGetMaxLotsMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.GetMaxLotsRequest,
              ru.tinkoff.piapi.contract.v1.GetMaxLotsResponse>(
                service, METHODID_GET_MAX_LOTS)))
        .addMethod(
          getGetOrderPriceMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              ru.tinkoff.piapi.contract.v1.GetOrderPriceRequest,
              ru.tinkoff.piapi.contract.v1.GetOrderPriceResponse>(
                service, METHODID_GET_ORDER_PRICE)))
        .build();
  }

  private static abstract class OrdersServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    OrdersServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return ru.tinkoff.piapi.contract.v1.Orders.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("OrdersService");
    }
  }

  private static final class OrdersServiceFileDescriptorSupplier
      extends OrdersServiceBaseDescriptorSupplier {
    OrdersServiceFileDescriptorSupplier() {}
  }

  private static final class OrdersServiceMethodDescriptorSupplier
      extends OrdersServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    OrdersServiceMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (OrdersServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new OrdersServiceFileDescriptorSupplier())
              .addMethod(getPostOrderMethod())
              .addMethod(getPostOrderAsyncMethod())
              .addMethod(getCancelOrderMethod())
              .addMethod(getGetOrderStateMethod())
              .addMethod(getGetOrdersMethod())
              .addMethod(getReplaceOrderMethod())
              .addMethod(getGetMaxLotsMethod())
              .addMethod(getGetOrderPriceMethod())
              .build();
        }
      }
    }
    return result;
  }
}
