package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.serverStreamingRpc
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.serverStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.flow.Flow
import ru.tinkoff.piapi.contract.v1.OrdersStreamServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.OrdersStreamService.
 */
public object OrdersStreamServiceGrpcKt {
  public const val SERVICE_NAME: String = OrdersStreamServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = OrdersStreamServiceGrpc.getServiceDescriptor()

  public val tradesStreamMethod: MethodDescriptor<TradesStreamRequest, TradesStreamResponse>
    @JvmStatic
    get() = OrdersStreamServiceGrpc.getTradesStreamMethod()

  public val orderStateStreamMethod:
      MethodDescriptor<OrderStateStreamRequest, OrderStateStreamResponse>
    @JvmStatic
    get() = OrdersStreamServiceGrpc.getOrderStateStreamMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.OrdersStreamService
   * service as suspending coroutines.
   */
  @StubFor(OrdersStreamServiceGrpc::class)
  public class OrdersStreamServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<OrdersStreamServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        OrdersStreamServiceCoroutineStub = OrdersStreamServiceCoroutineStub(channel, callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun tradesStream(request: TradesStreamRequest, headers: Metadata = Metadata()):
        Flow<TradesStreamResponse> = serverStreamingRpc(
      channel,
      OrdersStreamServiceGrpc.getTradesStreamMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun orderStateStream(request: OrderStateStreamRequest, headers: Metadata = Metadata()):
        Flow<OrderStateStreamResponse> = serverStreamingRpc(
      channel,
      OrdersStreamServiceGrpc.getOrderStateStreamMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.OrdersStreamService
   * service based on Kotlin coroutines.
   */
  public abstract class OrdersStreamServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersStreamService.TradesStream.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun tradesStream(request: TradesStreamRequest): Flow<TradesStreamResponse> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersStreamService.TradesStream is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersStreamService.OrderStateStream.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun orderStateStream(request: OrderStateStreamRequest):
        Flow<OrderStateStreamResponse> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersStreamService.OrderStateStream is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = OrdersStreamServiceGrpc.getTradesStreamMethod(),
      implementation = ::tradesStream
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = OrdersStreamServiceGrpc.getOrderStateStreamMethod(),
      implementation = ::orderStateStream
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.OrdersService.
 */
public object OrdersServiceGrpcKt {
  public const val SERVICE_NAME: String = OrdersServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = OrdersServiceGrpc.getServiceDescriptor()

  public val postOrderMethod: MethodDescriptor<PostOrderRequest, PostOrderResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getPostOrderMethod()

  public val postOrderAsyncMethod: MethodDescriptor<PostOrderAsyncRequest, PostOrderAsyncResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getPostOrderAsyncMethod()

  public val cancelOrderMethod: MethodDescriptor<CancelOrderRequest, CancelOrderResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getCancelOrderMethod()

  public val getOrderStateMethod: MethodDescriptor<GetOrderStateRequest, OrderState>
    @JvmStatic
    get() = OrdersServiceGrpc.getGetOrderStateMethod()

  public val getOrdersMethod: MethodDescriptor<GetOrdersRequest, GetOrdersResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getGetOrdersMethod()

  public val replaceOrderMethod: MethodDescriptor<ReplaceOrderRequest, PostOrderResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getReplaceOrderMethod()

  public val getMaxLotsMethod: MethodDescriptor<GetMaxLotsRequest, GetMaxLotsResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getGetMaxLotsMethod()

  public val getOrderPriceMethod: MethodDescriptor<GetOrderPriceRequest, GetOrderPriceResponse>
    @JvmStatic
    get() = OrdersServiceGrpc.getGetOrderPriceMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.OrdersService service as
   * suspending coroutines.
   */
  @StubFor(OrdersServiceGrpc::class)
  public class OrdersServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<OrdersServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        OrdersServiceCoroutineStub = OrdersServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun postOrder(request: PostOrderRequest, headers: Metadata = Metadata()):
        PostOrderResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getPostOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun postOrderAsync(request: PostOrderAsyncRequest, headers: Metadata =
        Metadata()): PostOrderAsyncResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getPostOrderAsyncMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun cancelOrder(request: CancelOrderRequest, headers: Metadata = Metadata()):
        CancelOrderResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getCancelOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getOrderState(request: GetOrderStateRequest, headers: Metadata = Metadata()):
        OrderState = unaryRpc(
      channel,
      OrdersServiceGrpc.getGetOrderStateMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getOrders(request: GetOrdersRequest, headers: Metadata = Metadata()):
        GetOrdersResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getGetOrdersMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun replaceOrder(request: ReplaceOrderRequest, headers: Metadata = Metadata()):
        PostOrderResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getReplaceOrderMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getMaxLots(request: GetMaxLotsRequest, headers: Metadata = Metadata()):
        GetMaxLotsResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getGetMaxLotsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getOrderPrice(request: GetOrderPriceRequest, headers: Metadata = Metadata()):
        GetOrderPriceResponse = unaryRpc(
      channel,
      OrdersServiceGrpc.getGetOrderPriceMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.OrdersService service
   * based on Kotlin coroutines.
   */
  public abstract class OrdersServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.PostOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun postOrder(request: PostOrderRequest): PostOrderResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.PostOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.PostOrderAsync.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun postOrderAsync(request: PostOrderAsyncRequest): PostOrderAsyncResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.PostOrderAsync is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.CancelOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun cancelOrder(request: CancelOrderRequest): CancelOrderResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.CancelOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.GetOrderState.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getOrderState(request: GetOrderStateRequest): OrderState = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.GetOrderState is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.GetOrders.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getOrders(request: GetOrdersRequest): GetOrdersResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.GetOrders is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.ReplaceOrder.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun replaceOrder(request: ReplaceOrderRequest): PostOrderResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.ReplaceOrder is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.GetMaxLots.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getMaxLots(request: GetMaxLotsRequest): GetMaxLotsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.GetMaxLots is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OrdersService.GetOrderPrice.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getOrderPrice(request: GetOrderPriceRequest): GetOrderPriceResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OrdersService.GetOrderPrice is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(OrdersServiceGrpc.getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getPostOrderMethod(),
      implementation = ::postOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getPostOrderAsyncMethod(),
      implementation = ::postOrderAsync
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getCancelOrderMethod(),
      implementation = ::cancelOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getGetOrderStateMethod(),
      implementation = ::getOrderState
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getGetOrdersMethod(),
      implementation = ::getOrders
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getReplaceOrderMethod(),
      implementation = ::replaceOrder
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getGetMaxLotsMethod(),
      implementation = ::getMaxLots
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OrdersServiceGrpc.getGetOrderPriceMethod(),
      implementation = ::getOrderPrice
    )).build()
  }
}
