package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.serverStreamingRpc
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.serverStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.flow.Flow
import ru.tinkoff.piapi.contract.v1.OperationsServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.OperationsService.
 */
public object OperationsServiceGrpcKt {
  public const val SERVICE_NAME: String = OperationsServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = OperationsServiceGrpc.getServiceDescriptor()

  public val getOperationsMethod: MethodDescriptor<OperationsRequest, OperationsResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetOperationsMethod()

  public val getPortfolioMethod: MethodDescriptor<PortfolioRequest, PortfolioResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetPortfolioMethod()

  public val getPositionsMethod: MethodDescriptor<PositionsRequest, PositionsResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetPositionsMethod()

  public val getWithdrawLimitsMethod:
      MethodDescriptor<WithdrawLimitsRequest, WithdrawLimitsResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetWithdrawLimitsMethod()

  public val getBrokerReportMethod: MethodDescriptor<BrokerReportRequest, BrokerReportResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetBrokerReportMethod()

  public val getDividendsForeignIssuerMethod:
      MethodDescriptor<GetDividendsForeignIssuerRequest, GetDividendsForeignIssuerResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetDividendsForeignIssuerMethod()

  public val getOperationsByCursorMethod:
      MethodDescriptor<GetOperationsByCursorRequest, GetOperationsByCursorResponse>
    @JvmStatic
    get() = OperationsServiceGrpc.getGetOperationsByCursorMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.OperationsService service
   * as suspending coroutines.
   */
  @StubFor(OperationsServiceGrpc::class)
  public class OperationsServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<OperationsServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        OperationsServiceCoroutineStub = OperationsServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getOperations(request: OperationsRequest, headers: Metadata = Metadata()):
        OperationsResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetOperationsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getPortfolio(request: PortfolioRequest, headers: Metadata = Metadata()):
        PortfolioResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetPortfolioMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getPositions(request: PositionsRequest, headers: Metadata = Metadata()):
        PositionsResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetPositionsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getWithdrawLimits(request: WithdrawLimitsRequest, headers: Metadata =
        Metadata()): WithdrawLimitsResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetWithdrawLimitsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getBrokerReport(request: BrokerReportRequest, headers: Metadata =
        Metadata()): BrokerReportResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetBrokerReportMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getDividendsForeignIssuer(request: GetDividendsForeignIssuerRequest,
        headers: Metadata = Metadata()): GetDividendsForeignIssuerResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetDividendsForeignIssuerMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getOperationsByCursor(request: GetOperationsByCursorRequest,
        headers: Metadata = Metadata()): GetOperationsByCursorResponse = unaryRpc(
      channel,
      OperationsServiceGrpc.getGetOperationsByCursorMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.OperationsService service
   * based on Kotlin coroutines.
   */
  public abstract class OperationsServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetOperations.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getOperations(request: OperationsRequest): OperationsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetOperations is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetPortfolio.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getPortfolio(request: PortfolioRequest): PortfolioResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetPortfolio is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetPositions.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getPositions(request: PositionsRequest): PositionsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetPositions is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetWithdrawLimits.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getWithdrawLimits(request: WithdrawLimitsRequest):
        WithdrawLimitsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetWithdrawLimits is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetBrokerReport.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getBrokerReport(request: BrokerReportRequest): BrokerReportResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetBrokerReport is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetDividendsForeignIssuer.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getDividendsForeignIssuer(request: GetDividendsForeignIssuerRequest):
        GetDividendsForeignIssuerResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetDividendsForeignIssuer is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsService.GetOperationsByCursor.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getOperationsByCursor(request: GetOperationsByCursorRequest):
        GetOperationsByCursorResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsService.GetOperationsByCursor is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetOperationsMethod(),
      implementation = ::getOperations
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetPortfolioMethod(),
      implementation = ::getPortfolio
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetPositionsMethod(),
      implementation = ::getPositions
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetWithdrawLimitsMethod(),
      implementation = ::getWithdrawLimits
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetBrokerReportMethod(),
      implementation = ::getBrokerReport
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetDividendsForeignIssuerMethod(),
      implementation = ::getDividendsForeignIssuer
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = OperationsServiceGrpc.getGetOperationsByCursorMethod(),
      implementation = ::getOperationsByCursor
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.OperationsStreamService.
 */
public object OperationsStreamServiceGrpcKt {
  public const val SERVICE_NAME: String = OperationsStreamServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = OperationsStreamServiceGrpc.getServiceDescriptor()

  public val portfolioStreamMethod:
      MethodDescriptor<PortfolioStreamRequest, PortfolioStreamResponse>
    @JvmStatic
    get() = OperationsStreamServiceGrpc.getPortfolioStreamMethod()

  public val positionsStreamMethod:
      MethodDescriptor<PositionsStreamRequest, PositionsStreamResponse>
    @JvmStatic
    get() = OperationsStreamServiceGrpc.getPositionsStreamMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.OperationsStreamService
   * service as suspending coroutines.
   */
  @StubFor(OperationsStreamServiceGrpc::class)
  public class OperationsStreamServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<OperationsStreamServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        OperationsStreamServiceCoroutineStub = OperationsStreamServiceCoroutineStub(channel,
        callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun portfolioStream(request: PortfolioStreamRequest, headers: Metadata = Metadata()):
        Flow<PortfolioStreamResponse> = serverStreamingRpc(
      channel,
      OperationsStreamServiceGrpc.getPortfolioStreamMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun positionsStream(request: PositionsStreamRequest, headers: Metadata = Metadata()):
        Flow<PositionsStreamResponse> = serverStreamingRpc(
      channel,
      OperationsStreamServiceGrpc.getPositionsStreamMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.OperationsStreamService
   * service based on Kotlin coroutines.
   */
  public abstract class OperationsStreamServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsStreamService.PortfolioStream.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun portfolioStream(request: PortfolioStreamRequest): Flow<PortfolioStreamResponse>
        = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsStreamService.PortfolioStream is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for
     * tinkoff.public.invest.api.contract.v1.OperationsStreamService.PositionsStream.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun positionsStream(request: PositionsStreamRequest): Flow<PositionsStreamResponse>
        = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.OperationsStreamService.PositionsStream is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(OperationsStreamServiceGrpc.getServiceDescriptor())
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = OperationsStreamServiceGrpc.getPortfolioStreamMethod(),
      implementation = ::portfolioStream
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = OperationsStreamServiceGrpc.getPositionsStreamMethod(),
      implementation = ::positionsStream
    )).build()
  }
}
