package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.bidiStreamingRpc
import io.grpc.kotlin.ClientCalls.serverStreamingRpc
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.bidiStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.serverStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.flow.Flow
import ru.tinkoff.piapi.contract.v1.MarketDataServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.MarketDataService.
 */
public object MarketDataServiceGrpcKt {
  public const val SERVICE_NAME: String = MarketDataServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = MarketDataServiceGrpc.getServiceDescriptor()

  public val getCandlesMethod: MethodDescriptor<GetCandlesRequest, GetCandlesResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetCandlesMethod()

  public val getLastPricesMethod: MethodDescriptor<GetLastPricesRequest, GetLastPricesResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetLastPricesMethod()

  public val getOrderBookMethod: MethodDescriptor<GetOrderBookRequest, GetOrderBookResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetOrderBookMethod()

  public val getTradingStatusMethod:
      MethodDescriptor<GetTradingStatusRequest, GetTradingStatusResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetTradingStatusMethod()

  public val getTradingStatusesMethod:
      MethodDescriptor<GetTradingStatusesRequest, GetTradingStatusesResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetTradingStatusesMethod()

  public val getLastTradesMethod: MethodDescriptor<GetLastTradesRequest, GetLastTradesResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetLastTradesMethod()

  public val getClosePricesMethod: MethodDescriptor<GetClosePricesRequest, GetClosePricesResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetClosePricesMethod()

  public val getTechAnalysisMethod:
      MethodDescriptor<GetTechAnalysisRequest, GetTechAnalysisResponse>
    @JvmStatic
    get() = MarketDataServiceGrpc.getGetTechAnalysisMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.MarketDataService service
   * as suspending coroutines.
   */
  @StubFor(MarketDataServiceGrpc::class)
  public class MarketDataServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<MarketDataServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        MarketDataServiceCoroutineStub = MarketDataServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getCandles(request: GetCandlesRequest, headers: Metadata = Metadata()):
        GetCandlesResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetCandlesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getLastPrices(request: GetLastPricesRequest, headers: Metadata = Metadata()):
        GetLastPricesResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetLastPricesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getOrderBook(request: GetOrderBookRequest, headers: Metadata = Metadata()):
        GetOrderBookResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetOrderBookMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getTradingStatus(request: GetTradingStatusRequest, headers: Metadata =
        Metadata()): GetTradingStatusResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetTradingStatusMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getTradingStatuses(request: GetTradingStatusesRequest, headers: Metadata =
        Metadata()): GetTradingStatusesResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetTradingStatusesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getLastTrades(request: GetLastTradesRequest, headers: Metadata = Metadata()):
        GetLastTradesResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetLastTradesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getClosePrices(request: GetClosePricesRequest, headers: Metadata =
        Metadata()): GetClosePricesResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetClosePricesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getTechAnalysis(request: GetTechAnalysisRequest, headers: Metadata =
        Metadata()): GetTechAnalysisResponse = unaryRpc(
      channel,
      MarketDataServiceGrpc.getGetTechAnalysisMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.MarketDataService service
   * based on Kotlin coroutines.
   */
  public abstract class MarketDataServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetCandles.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getCandles(request: GetCandlesRequest): GetCandlesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetCandles is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetLastPrices.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getLastPrices(request: GetLastPricesRequest): GetLastPricesResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetLastPrices is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetOrderBook.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getOrderBook(request: GetOrderBookRequest): GetOrderBookResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetOrderBook is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetTradingStatus.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getTradingStatus(request: GetTradingStatusRequest):
        GetTradingStatusResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetTradingStatus is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetTradingStatuses.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getTradingStatuses(request: GetTradingStatusesRequest):
        GetTradingStatusesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetTradingStatuses is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetLastTrades.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getLastTrades(request: GetLastTradesRequest): GetLastTradesResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetLastTrades is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetClosePrices.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getClosePrices(request: GetClosePricesRequest): GetClosePricesResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetClosePrices is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataService.GetTechAnalysis.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getTechAnalysis(request: GetTechAnalysisRequest):
        GetTechAnalysisResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataService.GetTechAnalysis is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetCandlesMethod(),
      implementation = ::getCandles
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetLastPricesMethod(),
      implementation = ::getLastPrices
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetOrderBookMethod(),
      implementation = ::getOrderBook
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetTradingStatusMethod(),
      implementation = ::getTradingStatus
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetTradingStatusesMethod(),
      implementation = ::getTradingStatuses
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetLastTradesMethod(),
      implementation = ::getLastTrades
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetClosePricesMethod(),
      implementation = ::getClosePrices
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataServiceGrpc.getGetTechAnalysisMethod(),
      implementation = ::getTechAnalysis
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.MarketDataStreamService.
 */
public object MarketDataStreamServiceGrpcKt {
  public const val SERVICE_NAME: String = MarketDataStreamServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = MarketDataStreamServiceGrpc.getServiceDescriptor()

  public val marketDataStreamMethod: MethodDescriptor<MarketDataRequest, MarketDataResponse>
    @JvmStatic
    get() = MarketDataStreamServiceGrpc.getMarketDataStreamMethod()

  public val marketDataServerSideStreamMethod:
      MethodDescriptor<MarketDataServerSideStreamRequest, MarketDataResponse>
    @JvmStatic
    get() = MarketDataStreamServiceGrpc.getMarketDataServerSideStreamMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.MarketDataStreamService
   * service as suspending coroutines.
   */
  @StubFor(MarketDataStreamServiceGrpc::class)
  public class MarketDataStreamServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<MarketDataStreamServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        MarketDataStreamServiceCoroutineStub = MarketDataStreamServiceCoroutineStub(channel,
        callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * The [Flow] of requests is collected once each time the [Flow] of responses is
     * collected. If collection of the [Flow] of responses completes normally or
     * exceptionally before collection of `requests` completes, the collection of
     * `requests` is cancelled.  If the collection of `requests` completes
     * exceptionally for any other reason, then the collection of the [Flow] of responses
     * completes exceptionally for the same reason and the RPC is cancelled with that reason.
     *
     * @param requests A [Flow] of request messages.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun marketDataStream(requests: Flow<MarketDataRequest>, headers: Metadata = Metadata()):
        Flow<MarketDataResponse> = bidiStreamingRpc(
      channel,
      MarketDataStreamServiceGrpc.getMarketDataStreamMethod(),
      requests,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun marketDataServerSideStream(request: MarketDataServerSideStreamRequest,
        headers: Metadata = Metadata()): Flow<MarketDataResponse> = serverStreamingRpc(
      channel,
      MarketDataStreamServiceGrpc.getMarketDataServerSideStreamMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.MarketDataStreamService
   * service based on Kotlin coroutines.
   */
  public abstract class MarketDataStreamServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataStreamService.MarketDataStream.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param requests A [Flow] of requests from the client.  This flow can be
     *        collected only once and throws [java.lang.IllegalStateException] on attempts to
     * collect
     *        it more than once.
     */
    public open fun marketDataStream(requests: Flow<MarketDataRequest>): Flow<MarketDataResponse> =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataStreamService.MarketDataStream is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for
     * tinkoff.public.invest.api.contract.v1.MarketDataStreamService.MarketDataServerSideStream.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun marketDataServerSideStream(request: MarketDataServerSideStreamRequest):
        Flow<MarketDataResponse> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.MarketDataStreamService.MarketDataServerSideStream is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(MarketDataStreamServiceGrpc.getServiceDescriptor())
      .addMethod(bidiStreamingServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataStreamServiceGrpc.getMarketDataStreamMethod(),
      implementation = ::marketDataStream
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = MarketDataStreamServiceGrpc.getMarketDataServerSideStreamMethod(),
      implementation = ::marketDataServerSideStream
    )).build()
  }
}
