package ru.tinkoff.piapi.contract.v1

import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.Deprecated
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import ru.tinkoff.piapi.contract.v1.InstrumentsServiceGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for
 * tinkoff.public.invest.api.contract.v1.InstrumentsService.
 */
public object InstrumentsServiceGrpcKt {
  public const val SERVICE_NAME: String = InstrumentsServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = InstrumentsServiceGrpc.getServiceDescriptor()

  public val tradingSchedulesMethod:
      MethodDescriptor<TradingSchedulesRequest, TradingSchedulesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getTradingSchedulesMethod()

  public val bondByMethod: MethodDescriptor<InstrumentRequest, BondResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getBondByMethod()

  public val bondsMethod: MethodDescriptor<InstrumentsRequest, BondsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getBondsMethod()

  public val getBondCouponsMethod: MethodDescriptor<GetBondCouponsRequest, GetBondCouponsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetBondCouponsMethod()

  public val getBondEventsMethod: MethodDescriptor<GetBondEventsRequest, GetBondEventsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetBondEventsMethod()

  public val currencyByMethod: MethodDescriptor<InstrumentRequest, CurrencyResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getCurrencyByMethod()

  public val currenciesMethod: MethodDescriptor<InstrumentsRequest, CurrenciesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getCurrenciesMethod()

  public val etfByMethod: MethodDescriptor<InstrumentRequest, EtfResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getEtfByMethod()

  public val etfsMethod: MethodDescriptor<InstrumentsRequest, EtfsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getEtfsMethod()

  public val futureByMethod: MethodDescriptor<InstrumentRequest, FutureResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getFutureByMethod()

  public val futuresMethod: MethodDescriptor<InstrumentsRequest, FuturesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getFuturesMethod()

  public val optionByMethod: MethodDescriptor<InstrumentRequest, OptionResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getOptionByMethod()

  public val optionsMethod: MethodDescriptor<InstrumentsRequest, OptionsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getOptionsMethod()

  public val optionsByMethod: MethodDescriptor<FilterOptionsRequest, OptionsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getOptionsByMethod()

  public val shareByMethod: MethodDescriptor<InstrumentRequest, ShareResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getShareByMethod()

  public val sharesMethod: MethodDescriptor<InstrumentsRequest, SharesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getSharesMethod()

  public val indicativesMethod: MethodDescriptor<IndicativesRequest, IndicativesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getIndicativesMethod()

  public val getAccruedInterestsMethod:
      MethodDescriptor<GetAccruedInterestsRequest, GetAccruedInterestsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetAccruedInterestsMethod()

  public val getFuturesMarginMethod:
      MethodDescriptor<GetFuturesMarginRequest, GetFuturesMarginResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetFuturesMarginMethod()

  public val getInstrumentByMethod: MethodDescriptor<InstrumentRequest, InstrumentResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetInstrumentByMethod()

  public val getDividendsMethod: MethodDescriptor<GetDividendsRequest, GetDividendsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetDividendsMethod()

  public val getAssetByMethod: MethodDescriptor<AssetRequest, AssetResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetAssetByMethod()

  public val getAssetsMethod: MethodDescriptor<AssetsRequest, AssetsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetAssetsMethod()

  public val getFavoritesMethod: MethodDescriptor<GetFavoritesRequest, GetFavoritesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetFavoritesMethod()

  public val editFavoritesMethod: MethodDescriptor<EditFavoritesRequest, EditFavoritesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getEditFavoritesMethod()

  public val getCountriesMethod: MethodDescriptor<GetCountriesRequest, GetCountriesResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetCountriesMethod()

  public val findInstrumentMethod: MethodDescriptor<FindInstrumentRequest, FindInstrumentResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getFindInstrumentMethod()

  public val getBrandsMethod: MethodDescriptor<GetBrandsRequest, GetBrandsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetBrandsMethod()

  public val getBrandByMethod: MethodDescriptor<GetBrandRequest, Brand>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetBrandByMethod()

  public val getAssetFundamentalsMethod:
      MethodDescriptor<GetAssetFundamentalsRequest, GetAssetFundamentalsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetAssetFundamentalsMethod()

  public val getAssetReportsMethod:
      MethodDescriptor<GetAssetReportsRequest, GetAssetReportsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetAssetReportsMethod()

  public val getConsensusForecastsMethod:
      MethodDescriptor<GetConsensusForecastsRequest, GetConsensusForecastsResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetConsensusForecastsMethod()

  public val getForecastByMethod: MethodDescriptor<GetForecastRequest, GetForecastResponse>
    @JvmStatic
    get() = InstrumentsServiceGrpc.getGetForecastByMethod()

  /**
   * A stub for issuing RPCs to a(n) tinkoff.public.invest.api.contract.v1.InstrumentsService
   * service as suspending coroutines.
   */
  @StubFor(InstrumentsServiceGrpc::class)
  public class InstrumentsServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<InstrumentsServiceCoroutineStub>(channel, callOptions) {
    public override fun build(channel: Channel, callOptions: CallOptions):
        InstrumentsServiceCoroutineStub = InstrumentsServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun tradingSchedules(request: TradingSchedulesRequest, headers: Metadata =
        Metadata()): TradingSchedulesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getTradingSchedulesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun bondBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        BondResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getBondByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun bonds(request: InstrumentsRequest, headers: Metadata = Metadata()):
        BondsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getBondsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getBondCoupons(request: GetBondCouponsRequest, headers: Metadata =
        Metadata()): GetBondCouponsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetBondCouponsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getBondEvents(request: GetBondEventsRequest, headers: Metadata = Metadata()):
        GetBondEventsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetBondEventsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun currencyBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        CurrencyResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getCurrencyByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun currencies(request: InstrumentsRequest, headers: Metadata = Metadata()):
        CurrenciesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getCurrenciesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun etfBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        EtfResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getEtfByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun etfs(request: InstrumentsRequest, headers: Metadata = Metadata()):
        EtfsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getEtfsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun futureBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        FutureResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getFutureByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun futures(request: InstrumentsRequest, headers: Metadata = Metadata()):
        FuturesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getFuturesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun optionBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        OptionResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getOptionByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    @Deprecated("The underlying service method is marked deprecated.")
    public suspend fun options(request: InstrumentsRequest, headers: Metadata = Metadata()):
        OptionsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getOptionsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun optionsBy(request: FilterOptionsRequest, headers: Metadata = Metadata()):
        OptionsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getOptionsByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun shareBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        ShareResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getShareByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun shares(request: InstrumentsRequest, headers: Metadata = Metadata()):
        SharesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getSharesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun indicatives(request: IndicativesRequest, headers: Metadata = Metadata()):
        IndicativesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getIndicativesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getAccruedInterests(request: GetAccruedInterestsRequest, headers: Metadata =
        Metadata()): GetAccruedInterestsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetAccruedInterestsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getFuturesMargin(request: GetFuturesMarginRequest, headers: Metadata =
        Metadata()): GetFuturesMarginResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetFuturesMarginMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getInstrumentBy(request: InstrumentRequest, headers: Metadata = Metadata()):
        InstrumentResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetInstrumentByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getDividends(request: GetDividendsRequest, headers: Metadata = Metadata()):
        GetDividendsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetDividendsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getAssetBy(request: AssetRequest, headers: Metadata = Metadata()):
        AssetResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetAssetByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getAssets(request: AssetsRequest, headers: Metadata = Metadata()):
        AssetsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetAssetsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getFavorites(request: GetFavoritesRequest, headers: Metadata = Metadata()):
        GetFavoritesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetFavoritesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun editFavorites(request: EditFavoritesRequest, headers: Metadata = Metadata()):
        EditFavoritesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getEditFavoritesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getCountries(request: GetCountriesRequest, headers: Metadata = Metadata()):
        GetCountriesResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetCountriesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun findInstrument(request: FindInstrumentRequest, headers: Metadata =
        Metadata()): FindInstrumentResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getFindInstrumentMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getBrands(request: GetBrandsRequest, headers: Metadata = Metadata()):
        GetBrandsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetBrandsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getBrandBy(request: GetBrandRequest, headers: Metadata = Metadata()): Brand =
        unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetBrandByMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getAssetFundamentals(request: GetAssetFundamentalsRequest, headers: Metadata
        = Metadata()): GetAssetFundamentalsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetAssetFundamentalsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getAssetReports(request: GetAssetReportsRequest, headers: Metadata =
        Metadata()): GetAssetReportsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetAssetReportsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getConsensusForecasts(request: GetConsensusForecastsRequest,
        headers: Metadata = Metadata()): GetConsensusForecastsResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetConsensusForecastsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getForecastBy(request: GetForecastRequest, headers: Metadata = Metadata()):
        GetForecastResponse = unaryRpc(
      channel,
      InstrumentsServiceGrpc.getGetForecastByMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the tinkoff.public.invest.api.contract.v1.InstrumentsService service
   * based on Kotlin coroutines.
   */
  public abstract class InstrumentsServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.TradingSchedules.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun tradingSchedules(request: TradingSchedulesRequest):
        TradingSchedulesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.TradingSchedules is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.BondBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun bondBy(request: InstrumentRequest): BondResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.BondBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Bonds.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun bonds(request: InstrumentsRequest): BondsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Bonds is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBondCoupons.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getBondCoupons(request: GetBondCouponsRequest): GetBondCouponsResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBondCoupons is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBondEvents.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getBondEvents(request: GetBondEventsRequest): GetBondEventsResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBondEvents is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.CurrencyBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun currencyBy(request: InstrumentRequest): CurrencyResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.CurrencyBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Currencies.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun currencies(request: InstrumentsRequest): CurrenciesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Currencies is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.EtfBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun etfBy(request: InstrumentRequest): EtfResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.EtfBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Etfs.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun etfs(request: InstrumentsRequest): EtfsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Etfs is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.FutureBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun futureBy(request: InstrumentRequest): FutureResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.FutureBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Futures.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun futures(request: InstrumentsRequest): FuturesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Futures is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.OptionBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun optionBy(request: InstrumentRequest): OptionResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.OptionBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Options.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    @Deprecated("The underlying service method is marked deprecated.")
    public open suspend fun options(request: InstrumentsRequest): OptionsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Options is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.OptionsBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun optionsBy(request: FilterOptionsRequest): OptionsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.OptionsBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.ShareBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun shareBy(request: InstrumentRequest): ShareResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.ShareBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Shares.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun shares(request: InstrumentsRequest): SharesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Shares is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.Indicatives.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun indicatives(request: IndicativesRequest): IndicativesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.Indicatives is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAccruedInterests.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getAccruedInterests(request: GetAccruedInterestsRequest):
        GetAccruedInterestsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAccruedInterests is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetFuturesMargin.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getFuturesMargin(request: GetFuturesMarginRequest):
        GetFuturesMarginResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetFuturesMargin is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetInstrumentBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getInstrumentBy(request: InstrumentRequest): InstrumentResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetInstrumentBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetDividends.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getDividends(request: GetDividendsRequest): GetDividendsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetDividends is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssetBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getAssetBy(request: AssetRequest): AssetResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssetBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssets.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getAssets(request: AssetsRequest): AssetsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssets is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetFavorites.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getFavorites(request: GetFavoritesRequest): GetFavoritesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetFavorites is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.EditFavorites.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun editFavorites(request: EditFavoritesRequest): EditFavoritesResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.EditFavorites is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetCountries.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getCountries(request: GetCountriesRequest): GetCountriesResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetCountries is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.FindInstrument.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun findInstrument(request: FindInstrumentRequest): FindInstrumentResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.FindInstrument is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBrands.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getBrands(request: GetBrandsRequest): GetBrandsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBrands is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBrandBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getBrandBy(request: GetBrandRequest): Brand = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetBrandBy is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssetFundamentals.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getAssetFundamentals(request: GetAssetFundamentalsRequest):
        GetAssetFundamentalsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssetFundamentals is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssetReports.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getAssetReports(request: GetAssetReportsRequest):
        GetAssetReportsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetAssetReports is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetConsensusForecasts.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getConsensusForecasts(request: GetConsensusForecastsRequest):
        GetConsensusForecastsResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetConsensusForecasts is unimplemented"))

    /**
     * Returns the response to an RPC for
     * tinkoff.public.invest.api.contract.v1.InstrumentsService.GetForecastBy.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getForecastBy(request: GetForecastRequest): GetForecastResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method tinkoff.public.invest.api.contract.v1.InstrumentsService.GetForecastBy is unimplemented"))

    public final override fun bindService(): ServerServiceDefinition =
        builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getTradingSchedulesMethod(),
      implementation = ::tradingSchedules
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getBondByMethod(),
      implementation = ::bondBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getBondsMethod(),
      implementation = ::bonds
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetBondCouponsMethod(),
      implementation = ::getBondCoupons
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetBondEventsMethod(),
      implementation = ::getBondEvents
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getCurrencyByMethod(),
      implementation = ::currencyBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getCurrenciesMethod(),
      implementation = ::currencies
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getEtfByMethod(),
      implementation = ::etfBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getEtfsMethod(),
      implementation = ::etfs
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getFutureByMethod(),
      implementation = ::futureBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getFuturesMethod(),
      implementation = ::futures
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getOptionByMethod(),
      implementation = ::optionBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getOptionsMethod(),
      implementation = ::options
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getOptionsByMethod(),
      implementation = ::optionsBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getShareByMethod(),
      implementation = ::shareBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getSharesMethod(),
      implementation = ::shares
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getIndicativesMethod(),
      implementation = ::indicatives
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetAccruedInterestsMethod(),
      implementation = ::getAccruedInterests
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetFuturesMarginMethod(),
      implementation = ::getFuturesMargin
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetInstrumentByMethod(),
      implementation = ::getInstrumentBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetDividendsMethod(),
      implementation = ::getDividends
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetAssetByMethod(),
      implementation = ::getAssetBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetAssetsMethod(),
      implementation = ::getAssets
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetFavoritesMethod(),
      implementation = ::getFavorites
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getEditFavoritesMethod(),
      implementation = ::editFavorites
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetCountriesMethod(),
      implementation = ::getCountries
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getFindInstrumentMethod(),
      implementation = ::findInstrument
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetBrandsMethod(),
      implementation = ::getBrands
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetBrandByMethod(),
      implementation = ::getBrandBy
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetAssetFundamentalsMethod(),
      implementation = ::getAssetFundamentals
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetAssetReportsMethod(),
      implementation = ::getAssetReports
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetConsensusForecastsMethod(),
      implementation = ::getConsensusForecasts
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = InstrumentsServiceGrpc.getGetForecastByMethod(),
      implementation = ::getForecastBy
    )).build()
  }
}
