/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.plugins.buildmetrics.jvm.labels;

import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.plugins.buildmetrics.api.labels.Label;
import ru.tinkoff.plugins.buildmetrics.utils.system.SystemProperties;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"javaRuntimeVersionLabel", "Lru/tinkoff/plugins/buildmetrics/api/labels/Label;", "", "systemProperties", "Lru/tinkoff/plugins/buildmetrics/utils/system/SystemProperties;", "jvmLabels", "", "jvmSpecificationVersionLabel", "jvmVendorLabel", "systemPropertyLabel", "name", "property", "build-metrics-jvm"})
public final class JvmLabelsKt {
    @NotNull
    public static final List<Label<?>> jvmLabels(@NotNull SystemProperties systemProperties) {
        Intrinsics.checkNotNullParameter((Object)systemProperties, (String)"systemProperties");
        Object[] objectArray = new Label[]{JvmLabelsKt.jvmVendorLabel(systemProperties), JvmLabelsKt.jvmSpecificationVersionLabel(systemProperties), JvmLabelsKt.javaRuntimeVersionLabel(systemProperties)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final Label<String> jvmVendorLabel(@NotNull SystemProperties systemProperties) {
        Intrinsics.checkNotNullParameter((Object)systemProperties, (String)"systemProperties");
        return JvmLabelsKt.systemPropertyLabel(systemProperties, "java_vendor", "java.vendor");
    }

    @NotNull
    public static final Label<String> jvmSpecificationVersionLabel(@NotNull SystemProperties systemProperties) {
        Intrinsics.checkNotNullParameter((Object)systemProperties, (String)"systemProperties");
        return JvmLabelsKt.systemPropertyLabel(systemProperties, "java_specification_version", "java.specification.version");
    }

    @NotNull
    public static final Label<String> javaRuntimeVersionLabel(@NotNull SystemProperties systemProperties) {
        Intrinsics.checkNotNullParameter((Object)systemProperties, (String)"systemProperties");
        return JvmLabelsKt.systemPropertyLabel(systemProperties, "java_runtime_version", "java.runtime.version");
    }

    private static final Label<String> systemPropertyLabel(SystemProperties systemProperties, String name, String property) {
        String string = systemProperties.property(property);
        if (string == null) {
            throw new IllegalStateException(("Failed to get property '" + property + "'").toString());
        }
        return new Label(name, (Serializable)((Object)string));
    }
}

