/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.query.select;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.quipy.query.BasicQuery;
import ru.quipy.query.exception.InvalidQueryStateException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J!\u0010\u0011\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lru/quipy/query/select/SelectQuery;", "Lru/quipy/query/BasicQuery;", "schema", "", "relation", "(Ljava/lang/String;Ljava/lang/String;)V", "limit", "", "orderByColumn", "sortingOrder", "Lru/quipy/query/select/SelectQuery$SortingOrder;", "build", "orderBy", "column", "mode", "validate", "", "withValues", "values", "", "", "([Ljava/lang/Object;)Lru/quipy/query/select/SelectQuery;", "SortingOrder", "tiny-postgresql-event-store"})
public final class SelectQuery
extends BasicQuery<SelectQuery> {
    private int limit;
    @Nullable
    private String orderByColumn;
    @NotNull
    private SortingOrder sortingOrder;

    public SelectQuery(@NotNull String schema, @NotNull String relation) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        super(schema, relation);
        this.limit = -1;
        this.sortingOrder = SortingOrder.ASCENDING;
    }

    @NotNull
    public final SelectQuery limit(int limit) {
        if (limit > 0) {
            this.limit = limit;
        }
        return this;
    }

    @Override
    @NotNull
    public String build() {
        String columnsStr = "*";
        if (!((Collection)this.getColumns()).isEmpty()) {
            columnsStr = CollectionsKt.joinToString$default((Iterable)this.getColumns(), null, null, null, (int)0, null, null, (int)63, null);
        }
        String string = "select " + columnsStr + " from " + this.getSchema() + '.' + this.getRelation();
        Object[] objectArray = new Object[]{};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql2 = string2;
        if (!((Collection)this.getConditions()).isEmpty()) {
            sql2 = sql2 + " where " + CollectionsKt.joinToString$default((Iterable)this.getConditions(), (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null);
        }
        if (this.orderByColumn != null) {
            sql2 = sql2 + " order by " + this.orderByColumn + ' ' + this.sortingOrder.getSqlName();
        }
        if (this.limit > 0) {
            sql2 = sql2 + " limit " + this.limit;
        }
        return sql2;
    }

    @Override
    @NotNull
    public SelectQuery withValues(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public final SelectQuery orderBy(@NotNull String column, @NotNull SortingOrder mode) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.orderByColumn = column;
        this.sortingOrder = this.sortingOrder;
        return this;
    }

    public static /* synthetic */ SelectQuery orderBy$default(SelectQuery selectQuery, String string, SortingOrder sortingOrder, int n, Object object) {
        if ((n & 2) != 0) {
            sortingOrder = SortingOrder.ASCENDING;
        }
        return selectQuery.orderBy(string, sortingOrder);
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.orderByColumn != null && !CollectionsKt.contains((Iterable)this.getColumns(), (Object)this.orderByColumn)) {
            throw new InvalidQueryStateException("Colunm " + this.orderByColumn + " is not present in select columns [" + CollectionsKt.joinToString$default((Iterable)this.getColumns(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']');
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lru/quipy/query/select/SelectQuery$SortingOrder;", "", "sqlName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSqlName", "()Ljava/lang/String;", "ASCENDING", "DESCENDING", "tiny-postgresql-event-store"})
    public static final class SortingOrder
    extends Enum<SortingOrder> {
        @NotNull
        private final String sqlName;
        public static final /* enum */ SortingOrder ASCENDING = new SortingOrder("asc");
        public static final /* enum */ SortingOrder DESCENDING = new SortingOrder("desc");
        private static final /* synthetic */ SortingOrder[] $VALUES;

        private SortingOrder(String sqlName) {
            this.sqlName = sqlName;
        }

        @NotNull
        public final String getSqlName() {
            return this.sqlName;
        }

        public static SortingOrder[] values() {
            return (SortingOrder[])$VALUES.clone();
        }

        public static SortingOrder valueOf(String value) {
            return Enum.valueOf(SortingOrder.class, value);
        }

        static {
            $VALUES = sortingOrderArray = new SortingOrder[]{SortingOrder.ASCENDING, SortingOrder.DESCENDING};
        }
    }
}

