/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.query.insert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.quipy.query.BasicQuery;
import ru.quipy.query.exception.InvalidQueryStateException;
import ru.quipy.query.insert.BatchInsertQuery;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0006\u0010\u000b\u001a\u00020\u0003J\b\u0010\f\u001a\u00020\rH\u0014J!\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0011R>\u0010\u0006\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t0\u0007j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/quipy/query/insert/BatchInsertQuery;", "Lru/quipy/query/BasicQuery;", "schema", "", "relation", "(Ljava/lang/String;Ljava/lang/String;)V", "batches", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "build", "getTemplate", "validate", "", "withValues", "values", "", "([Ljava/lang/Object;)Lru/quipy/query/insert/BatchInsertQuery;", "tiny-postgresql-event-store"})
public final class BatchInsertQuery
extends BasicQuery<BatchInsertQuery> {
    @NotNull
    private final ArrayList<ArrayList<Object>> batches;

    public BatchInsertQuery(@NotNull String schema, @NotNull String relation) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        super(schema, relation);
        this.batches = new ArrayList();
    }

    @Override
    @NotNull
    public BatchInsertQuery withValues(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        ArrayList<Object> batch = new ArrayList<Object>();
        for (Object value : values) {
            batch.add(value);
        }
        this.batches.add(batch);
        return this;
    }

    @NotNull
    public final String getTemplate() {
        String string = "insert into %s.%s (%s) values (%s)";
        Object[] objectArray = new Object[]{this.getSchema(), this.getRelation(), CollectionsKt.joinToString$default((Iterable)this.getColumns(), null, null, null, (int)0, null, null, (int)63, null), CollectionsKt.joinToString$default((Iterable)this.getColumns(), null, null, null, (int)0, null, (Function1)getTemplate.1.INSTANCE, (int)31, null)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @Override
    protected void validate() {
        for (ArrayList<Object> batch : this.batches) {
            if (batch.size() == this.getColumns().size()) continue;
            throw new InvalidQueryStateException("Columns size doesn't match batch values size\ncolumns[" + CollectionsKt.joinToString$default((Iterable)this.getColumns(), null, null, null, (int)0, null, null, (int)63, null) + "]\nvalues[" + CollectionsKt.joinToString$default((Iterable)this.getValues(), null, null, null, (int)0, null, null, (int)63, null) + ']');
        }
    }

    @Override
    @NotNull
    public String build() {
        this.validate();
        List resultQueries = new ArrayList();
        for (ArrayList<Object> batch : this.batches) {
            Object[] objectArray;
            Intrinsics.checkNotNullExpressionValue(batch, (String)"batch");
            Collection $this$toTypedArray$iv = batch;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new Object[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            super.withValues(Arrays.copyOf(objectArray, objectArray.length));
            String string = "insert into %s.%s (%s) values (%s)";
            Object[] objectArray2 = new Object[]{this.getSchema(), this.getRelation(), CollectionsKt.joinToString$default((Iterable)this.getColumns(), null, null, null, (int)0, null, null, (int)63, null), CollectionsKt.joinToString$default((Iterable)this.getValues(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(this){
                final /* synthetic */ BatchInsertQuery this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BatchInsertQuery.access$convertValueToString(this.this$0, it);
                }
            }), (int)31, null)};
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            resultQueries.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)resultQueries, (CharSequence)";\n", null, null, (int)0, null, null, (int)62, null);
    }

    public static final /* synthetic */ String access$convertValueToString(BatchInsertQuery $this, Object value) {
        return $this.convertValueToString(value);
    }
}

